/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.QualifiedBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.util.QualifiedBasesHashSet;
import java.awt.Component;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class SchemaVisualizationFrame
extends JFrame {
    private SchemaImpl schema;
    private Vector basesCollector;

    public SchemaVisualizationFrame(SchemaImpl schema) {
        this.schema = schema;
        this.setDefaultCloseOperation(3);
        this.basesCollector = new Vector();
    }

    public void vizualize() throws Exception {
        ((Component)this).setSize(1000, 700);
        JTree visualizationTree = new JTree(this.createBaseNode(null, this.schema));
        JScrollPane treeVisualizationScrollPane = new JScrollPane(visualizationTree);
        visualizationTree.setVisible(true);
        treeVisualizationScrollPane.getViewport().repaint();
        this.getContentPane().add(treeVisualizationScrollPane);
        ((Component)this).setVisible(true);
    }

    private DefaultMutableTreeNode createNode(Class fieldClass, String fieldName, Object fieldObj) throws Exception {
        DefaultMutableTreeNode result = null;
        result = fieldObj != null && fieldObj instanceof BaseImpl ? this.createBaseNode(fieldName, (BaseImpl)fieldObj) : (fieldObj != null ? (fieldObj instanceof Vector ? this.createVectorNode(fieldName, (Vector)fieldObj) : (fieldObj instanceof QualifiedBasesHashSet ? this.createVectorNode(fieldName, ((QualifiedBasesHashSet)fieldObj).qualifiedBases()) : new DefaultMutableTreeNode(this.extractClassName(fieldClass) + " - " + (fieldName != null ? fieldName + " - " : "") + fieldObj.toString()))) : new DefaultMutableTreeNode(this.extractClassName(fieldClass) + " - " + (fieldName != null ? fieldName + " - " : "") + "null"));
        return result;
    }

    private DefaultMutableTreeNode createBaseNode(String fieldName, BaseImpl base) throws Exception {
        DefaultMutableTreeNode result = null;
        Class<?> baseClass = base.getClass();
        String qualificationString = null;
        boolean visualize = true;
        if (base instanceof QualifiedBaseImpl) {
            visualize = !this.basesCollector.contains(base);
            QualifiedBaseImpl qualifiedBase = (QualifiedBaseImpl)base;
            qualificationString = qualifiedBase.getTargetNamespace() + " : " + qualifiedBase.getName();
        }
        String identifivcationStr = this.extractClassName(baseClass) + (fieldName != null ? " - " + fieldName : "") + (qualificationString != null ? " - " + qualificationString : "");
        result = new DefaultMutableTreeNode(identifivcationStr);
        if (visualize) {
            this.basesCollector.add(base);
            Vector collector = this.extractFields(baseClass);
            int j = 0;
            while (j < collector.size()) {
                Field[] fields = (Field[])collector.get(j);
                int i = 0;
                while (i < fields.length) {
                    Field field = fields[i];
                    String fieldObjName = field.getName();
                    if (!(field.getModifiers() != 4 || fieldObjName.equals("redefiningSchema") || fieldObjName.equals("ownerSchema") || fieldObjName.equals("associatedNode"))) {
                        Class<?> fieldClass = field.getType();
                        Object fieldObj = field.get(base);
                        if (fieldObj == base) {
                            result.add(new DefaultMutableTreeNode(this.extractClassName(fieldClass) + " - " + fieldObjName));
                        } else {
                            result.add(this.createNode(fieldClass, fieldObjName, fieldObj));
                        }
                    }
                    ++i;
                }
                ++j;
            }
        }
        return result;
    }

    private Vector extractFields(Class declaringClass) {
        Vector<Field[]> result = new Vector<Field[]>();
        Class processingClass = declaringClass;
        while (!processingClass.getName().equals("java.lang.Object")) {
            Field[] processingClassfields = processingClass.getDeclaredFields();
            result.add(processingClassfields);
            processingClass = processingClass.getSuperclass();
        }
        return result;
    }

    private DefaultMutableTreeNode createVectorNode(String fieldName, Vector collector) throws Exception {
        DefaultMutableTreeNode result = new DefaultMutableTreeNode("Vector" + (fieldName != null ? " - " + fieldName : ""));
        int i = 0;
        while (i < collector.size()) {
            Object obj = collector.get(i);
            if (obj == null) {
                result.add(new DefaultMutableTreeNode("null"));
            } else {
                result.add(this.createNode(obj.getClass(), null, obj));
            }
            ++i;
        }
        return result;
    }

    private DefaultMutableTreeNode createHashtableNode(String fieldName, Hashtable collector) throws Exception {
        DefaultMutableTreeNode result = new DefaultMutableTreeNode("Hashtable" + (fieldName != null ? " - " + fieldName : ""));
        Enumeration enumeration = collector.elements();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            result.add(this.createNode(obj.getClass(), null, obj));
        }
        return result;
    }

    private String extractClassName(Class objClass) {
        String className = objClass.getName();
        Package classPackage = objClass.getPackage();
        if (classPackage == null) {
            return className;
        }
        String classPackageName = objClass.getPackage().getName();
        return className.substring(classPackageName.length() + 1);
    }
}

