/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.InfoItemDeclarationBase;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.ComplexTypeDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.QualifiedBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.TypeDefinitionBaseImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.schema.validator.SimpleTypeValidator;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import org.w3c.dom.Node;

public abstract class InfoItemDeclarationBaseImpl
extends QualifiedBaseImpl
implements InfoItemDeclarationBase {
    protected TypeDefinitionBaseImpl typeDefinition;
    protected ComplexTypeDefinitionImpl scope;
    protected String defaultValue;
    protected String fixedValue;

    public InfoItemDeclarationBaseImpl() {
        this(null, null, false);
    }

    public InfoItemDeclarationBaseImpl(Node associatedNode, BaseInfo baseInfo, boolean isTopLevel) {
        super(associatedNode, baseInfo, isTopLevel);
    }

    public final TypeDefinitionBase getTypeDefinition() {
        return this.typeDefinition;
    }

    public final ComplexTypeDefinition getScope() {
        return this.scope;
    }

    public final String getValueConstraintDefault() {
        return this.defaultValue;
    }

    public final String getValueConstraintFixed() {
        return this.fixedValue;
    }

    public boolean match(Base infoItemDeclarationBase) {
        if (!super.match(infoItemDeclarationBase)) {
            return false;
        }
        InfoItemDeclarationBaseImpl targetInfoItemDeclrBase = (InfoItemDeclarationBaseImpl)infoItemDeclarationBase;
        return Tools.compareBases(this.typeDefinition, targetInfoItemDeclrBase.typeDefinition) && Tools.compareStringProps(this.defaultValue, targetInfoItemDeclrBase.defaultValue) && Tools.compareStringProps(this.fixedValue, targetInfoItemDeclrBase.fixedValue);
    }

    protected void checkValueConstraint() throws SchemaComponentException {
        if (this.defaultValue != null && this.fixedValue != null) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of info item declaration base " + DOM.toXPath(this.associatedNode) + " is not correct. 'Default' and 'fixed' must not both be present.");
        }
        if (this.typeDefinition.isDerivedFrom(this.baseInfo.getSchema().getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "ID"), false, false) && (this.defaultValue != null || this.fixedValue != null)) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of info item declaration base '" + DOM.toXPath(this.associatedNode) + "' is not correct. If the {type definition} is or is derived from ID then there must not be a {value constraint}.");
        }
        String valueConstraint = null;
        if (this.fixedValue != null) {
            valueConstraint = this.fixedValue;
        } else if (this.defaultValue != null) {
            valueConstraint = this.defaultValue;
        }
        SimpleTypeDefinition simpleTypeDef = null;
        simpleTypeDef = this.typeDefinition instanceof SimpleTypeDefinition ? (SimpleTypeDefinition)((Object)this.typeDefinition) : ((ComplexTypeDefinition)((Object)this.typeDefinition)).getContentTypeSimpleTypeDefinition();
        if (valueConstraint != null && simpleTypeDef != null && !SimpleTypeValidator.validateSimpleTypeDefinition(simpleTypeDef, null, null, valueConstraint, false, null)) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of info item declaration base " + DOM.toXPath(this.associatedNode) + " is not correct. If {value constraint} is present, it's value must be valid with respect to the corresponding simple content.");
        }
    }

    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        InfoItemDeclarationBaseImpl result = (InfoItemDeclarationBaseImpl)super.initializeBase(base, clonedCollector);
        result.typeDefinition = this.typeDefinition.isBuiltIn ? this.typeDefinition : (TypeDefinitionBaseImpl)this.typeDefinition.clone(clonedCollector);
        result.defaultValue = this.defaultValue;
        result.fixedValue = this.fixedValue;
        return result;
    }
}

