/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class NestedRuntimeException
extends RuntimeException {
    public static final String WRAPPING = " -> ";
    public static final String TRACE_SEPARATOR = "\t----------------------------------------";
    private Throwable cause;

    public NestedRuntimeException() {
    }

    public NestedRuntimeException(Throwable cause) {
        this.cause = cause;
    }

    public NestedRuntimeException(String message) {
        super(message);
    }

    public NestedRuntimeException(Throwable cause, String message) {
        super(message);
        this.cause = cause;
    }

    public NestedRuntimeException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    public final Throwable getCause() {
        return this.cause;
    }

    public final void setCause(Throwable cause) {
        this.cause = cause;
    }

    public final void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public final void printStackTrace(PrintStream out) {
        if (this.cause == null) {
            super.printStackTrace(out);
        } else {
            PrintStream printStream = out;
            synchronized (printStream) {
                out.print(this.toFullString() + WRAPPING);
                this.cause.printStackTrace(out);
                out.println(TRACE_SEPARATOR);
                out.print(this.traceOf(this.cause));
            }
        }
    }

    public final void printStackTrace(PrintWriter out) {
        if (this.cause == null) {
            super.printStackTrace(out);
        } else {
            PrintWriter printWriter = out;
            synchronized (printWriter) {
                out.print(this.toFullString() + WRAPPING);
                this.cause.printStackTrace(out);
                out.println(TRACE_SEPARATOR);
                out.print(this.traceOf(this.cause));
            }
        }
    }

    private String traceOf(Throwable th) {
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        super.printStackTrace(pw);
        pw.flush();
        String s = w.toString();
        int p = s.indexOf("\tat");
        if (p != -1) {
            s = s.substring(p);
        }
        return s;
    }

    private final String toFullString() {
        return this.cause == null ? super.toString() : super.toString() + WRAPPING + this.cause.toString();
    }

    public String toString() {
        return this.toFullString();
    }

    public static void main(String[] args) {
        try {
            try {
                try {
                    int[] a = new int[100000000];
                }
                catch (Exception e1) {
                    throw new NestedRuntimeException("message1", e1);
                }
            }
            catch (Exception e2) {
                throw new NestedRuntimeException("message2", e2);
            }
        }
        catch (Exception e3) {
            throw new NestedRuntimeException("message3", e3);
        }
    }
}

