/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.parser.handlers;

import com.inqmy.lib.xml.parser.DocHandler;
import com.inqmy.lib.xml.parser.ParserException;
import com.inqmy.lib.xml.parser.helpers.CharArray;
import com.inqmy.lib.xml.parser.helpers.Entity;
import com.inqmy.lib.xml.parser.helpers.Reference;
import java.util.Vector;

public class TestDocHandler
implements DocHandler {
    public static final boolean DEBUG = true;
    boolean wroteDTDKv = false;

    public void D(String s) {
        System.out.println(s);
    }

    public void P(String s) {
        System.out.print(s);
    }

    public String mq(String str) {
        if (str.indexOf("\"") != -1) {
            return "'" + str + "'";
        }
        return "\"" + str + "\"";
    }

    public void onXMLDecl(String v, String e, String s) {
        if (v.length() + e.length() + s.length() > 0) {
            this.P("<?xml");
            if (v.length() > 0) {
                this.P(" version=" + this.mq(v));
            }
            if (e.length() > 0) {
                this.P(" encoding=" + this.mq(e));
            }
            if (s.length() > 0) {
                this.P(" standalone=" + this.mq(s));
            }
            this.P("?>\n");
        }
    }

    public void startElementStart(CharArray uri, CharArray localName, CharArray qname) throws Exception {
        System.out.print("<" + qname);
    }

    public void addAttribute(CharArray uri, CharArray prefix, CharArray localName, CharArray qname, String type, CharArray value) throws Exception {
        System.out.print(" " + qname + "=" + this.mq(value.getString()));
    }

    public void startElementEnd(boolean isEmpty) throws Exception {
        if (isEmpty) {
            System.out.print("/>");
        } else {
            System.out.print(">");
        }
    }

    public void endElement(CharArray uri, CharArray localName, CharArray qname, boolean isEmpty) throws Exception {
        if (!isEmpty) {
            System.out.print("</" + qname + ">");
        }
    }

    public void startDocument() throws ParserException {
    }

    public void endDocument() throws ParserException {
    }

    public void charData(CharArray data, boolean bDisableOutputEscaping) throws ParserException {
        this.P(data.toString());
    }

    public void onPI(CharArray target, CharArray data) throws ParserException {
        this.P("<?" + target + " " + data + "?>");
    }

    public void onComment(CharArray text) throws ParserException {
        this.P("<!--" + text + "-->");
    }

    public void onCDSect(CharArray text) throws ParserException {
        this.P("<![CDATA[" + text + "]]>");
    }

    public void onDTDElement(CharArray name, CharArray model) throws ParserException {
        this.P("<!ELEMENT " + name + " " + model + ">\n");
    }

    public void onDTDAttListStart(CharArray name) throws ParserException {
        this.P("<!ATTLIST " + name);
    }

    public void onDTDAttListItem(CharArray name, CharArray attName, String type, String defDecl, CharArray crValue, String note) throws ParserException {
        this.P("\n " + attName + " " + type);
        if (note.length() > 0) {
            this.P(" " + note);
        }
        this.P(" " + defDecl);
        if (crValue.getSize() > 0) {
            this.P(" " + this.mq(crValue.getString()));
        }
    }

    public void onDTDAttListEnd() throws ParserException {
        this.P(">\n");
    }

    public String getValueString(Vector value) throws ParserException {
        String a = "";
        int i = 0;
        while (i < value.size()) {
            a = a + ((Reference)value.get(i)).restore();
            ++i;
        }
        return a;
    }

    public void onDTDEntity(Entity ent) throws Exception {
        this.P("<!ENTITY ");
        if (ent.isPE()) {
            this.P("%");
        }
        this.P(ent.getName().toString());
        if (ent.getPub().getSize() + ent.getSys().getSize() == 0) {
            this.P(" " + this.mq(ent.getValue().toString()) + ">");
        } else {
            this.P(" " + this.writeExternalID(ent.getPub(), ent.getSys()));
            if (ent.getNote().getSize() > 0) {
                this.P(" NDATA " + ent.getNote());
            }
            this.P(">");
        }
        this.P("\n");
    }

    public void onDTDUnparsedEntity(String name, String pub, String sys, String note, boolean pe) throws ParserException {
    }

    public void onDTDNotation(CharArray name, CharArray pub, CharArray sys) throws ParserException {
        System.out.print("<!NOTATION " + name + this.writeExternalID(pub, sys) + ">");
    }

    public String writeExternalID(CharArray pub, CharArray sys) throws ParserException {
        if (pub.length() == 0 && sys.length() == 0) {
            return "";
        }
        if (pub.length() == 0 && sys.length() > 0) {
            return " SYSTEM " + this.mq(sys.toString());
        }
        if (pub.length() > 0 && sys.length() == 0) {
            return " PUBLIC " + this.mq(pub.toString());
        }
        return " PUBLIC " + this.mq(pub.toString()) + " " + this.mq(sys.toString());
    }

    public void startDTD(CharArray name, CharArray pub, CharArray sys) throws ParserException {
        this.P("<!DOCTYPE " + name + this.writeExternalID(pub, sys) + "[\n");
    }

    public void endDTD() throws ParserException {
        this.P("]>\n");
    }

    public void onContentReference(Reference ref) throws ParserException {
        this.P(ref.resolve());
    }

    public void startPrefixMapping(CharArray prefix, CharArray uri) {
    }

    public void endPrefixMapping(CharArray prefix) {
    }

    public void onWarning(String warning) throws Exception {
        System.out.println("=-= Repored Warning: " + warning);
    }

    public void onStartContentEntity(CharArray name, boolean isExpanding) throws Exception {
    }

    public void onEndContentEntity(CharArray name) throws Exception {
    }

    public void onCustomEvent(int eventId, Object obj) throws Exception {
    }
}

