/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.generator;

import com.inqmy.lib.schema.Schema;
import com.inqmy.lib.schema.SchemaException;
import com.inqmy.lib.schema.builtin.BuiltInManager;
import com.inqmy.lib.schema.generator.GeneratorComplexType;
import com.inqmy.lib.schema.generator.GeneratorSimpleType;
import com.inqmy.lib.schema.generator.TreeWalker;
import com.inqmy.lib.xml.parser.helpers.CharArray;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Generator {
    private Date date = null;
    public static boolean OPTION_INLINE = true;
    public static boolean OPTION_INLINE_BUILT_IN = true;
    public static boolean OPTION_SYNCHRONIZE = true;
    public static boolean OPTION_DOC = true;
    public static String HEADER = "// Generated by InQMy's Schema generator";
    private Hashtable typeMappingRegistry = new Hashtable();
    private static final String[] MONTH_NAMES = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    protected Schema owner;
    protected char[] code;
    protected TreeWalker walker;
    protected BuiltInManager manager;
    public GeneratorSimpleType gst;
    public GeneratorComplexType gct;

    public Generator(Schema s) {
        this.owner = s;
        this.date = new Date();
        this.gst = new GeneratorSimpleType(this);
        this.gct = new GeneratorComplexType(this);
    }

    public void update() {
        this.code = this.owner.getCode();
        this.walker = this.owner.getWalker();
        this.manager = this.owner.getManager();
        this.gst.update();
        this.gct.update();
    }

    public void generate(int t, File dir) {
        char h = this.code[t];
        if (h == '\u000e') {
            this.gst.generate(t, dir);
            return;
        }
        if (h == '\u000f') {
            this.gct.generate(t, dir);
            return;
        }
        throw new SchemaException("Not a TYPE.");
    }

    protected void escape(CharArray a, CharArray b) {
        char[] aData = a.getData();
        int aOffset = a.getOffset();
        int aEnd = aOffset + a.length();
        b.clear();
        int i = aOffset;
        while (i < aEnd) {
            char ch = aData[i];
            if (ch == '\\') {
                b.append('\\');
            }
            b.append(ch);
            ++i;
        }
    }

    private String getDoc(int p) {
        int a = this.walker.getPTRTo(p, 'F');
        if (a == -1) {
            return null;
        }
        String r = "";
        int x = a + 1;
        while (this.code[x] != '\u0001') {
            if (this.code[x] == '\u00c8' && this.code[this.code[x + 1]] == 'G') {
                char d = this.code[x + 1];
                int y = d + '\u0001';
                while (this.code[y] != '\u0001') {
                    if (this.code[y] == '\u00fa') {
                        r = r + this.walker.getString(this.code[y + 1]);
                    }
                    y += 2;
                }
            }
            x += 2;
        }
        return r;
    }

    private String[] split(String doc) {
        int q;
        Vector<String> v = new Vector<String>();
        doc = doc.trim();
        int p = 0;
        while ((q = doc.indexOf(13, p)) != -1) {
            v.addElement(doc.substring(p, q));
            p = q + 2;
        }
        v.addElement(doc.substring(p));
        return v.toArray(new String[0]);
    }

    protected void generateDoc(int t, PrintStream out) {
        if (OPTION_DOC) {
            out.println("/**");
            String doc = this.getDoc(t);
            if (doc != null) {
                String[] x = this.split(doc);
                int i = 0;
                while (i < x.length) {
                    out.print(" * ");
                    out.println(x[i].trim());
                    ++i;
                }
                out.println(" *");
            }
            out.println(" * @author     InQMy code generator, nick_nickolov@abv.bg");
            out.println(" * @version    " + this.date.getDay() + " " + MONTH_NAMES[this.date.getMonth()] + " " + (1900 + this.date.getYear()));
            out.println(" */");
            out.println();
        }
    }

    public boolean setOption(String nameOfOption, boolean value) {
        if (nameOfOption.equals("inline")) {
            OPTION_INLINE = value;
            return true;
        }
        if (nameOfOption.equals("inlineBuiltIn")) {
            OPTION_INLINE_BUILT_IN = value;
            return true;
        }
        if (nameOfOption.equals("synchronize")) {
            OPTION_INLINE_BUILT_IN = value;
            return true;
        }
        if (nameOfOption.equals("doc")) {
            OPTION_DOC = value;
            return true;
        }
        return false;
    }

    protected PrintStream openPrintStreamForType(int t, File dir) {
        return Generator.openPrintStreamFor(this.owner.getWalker().getNameOfType(t), dir);
    }

    private static PrintStream openPrintStreamFor(String name, File dir) {
        try {
            String s = name.replace('.', '/') + ".java";
            File file = new File(dir, s);
            file.getParentFile().mkdirs();
            return new PrintStream(new FileOutputStream(file));
        }
        catch (IOException e) {
            throw new SchemaException(e);
        }
    }

    public void clearTypeMappingRegistry() {
        this.typeMappingRegistry.clear();
    }

    public void generateTypeMappingRegistry(File dir) {
        PrintStream out = Generator.openPrintStreamFor(this.walker.withPackage("http://www.inqmy.com/soap/type-mapping-registry", "TypeMappingRegistry"), dir);
        String packageName = this.walker.getPackageOf("http://www.inqmy.com/soap/type-mapping-registry");
        out.println("// Generated by InQMy's schema-to-java generator");
        out.println();
        if (packageName != null && packageName.length() != 0) {
            out.print("package ");
            out.print(packageName);
            out.println(";");
            out.println();
        }
        out.println("import java.util.Hashtable;");
        out.println();
        out.println("public final class TypeMappingRegistry extends com.inqmy.lib.schema.generator.TypeMapping {");
        out.println("  private static final Hashtable h;");
        out.println("  static {");
        out.println("    h = new Hashtable();");
        Enumeration enumeration = this.typeMappingRegistry.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = (String)this.typeMappingRegistry.get(key);
            out.println("    h.put(\"" + Generator.escape(key) + "\", \"" + Generator.escape(value) + "\");");
        }
        out.println("  }");
        out.println();
        out.println("  public final String get(String uri, String local) {");
        out.println("    uri = (uri == null) ? \"\" : uri;");
        out.println("    return (String) h.get(uri + ' ' + local);");
        out.println("  }");
        out.println("}");
        out.close();
    }

    public void generateTypeMappingRegistry(PrintStream out) {
        this.generateTypeMappingRegistry(new PrintWriter(out));
    }

    public void generateTypeMappingRegistry(PrintWriter out) {
        out.println("  public static final class TypeMappingRegistry extends com.inqmy.lib.schema.generator.TypeMapping {");
        out.println("    private static final java.util.Hashtable h;");
        out.println("    static {");
        out.println("      h = new java.util.Hashtable();");
        Enumeration enumeration = this.typeMappingRegistry.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = (String)this.typeMappingRegistry.get(key);
            out.println("      h.put(\"" + Generator.escape(key) + "\", \"" + Generator.escape(value) + "\");");
        }
        out.println("    }");
        out.println();
        out.println("    public final java.lang.String get(java.lang.String uri, java.lang.String local) {");
        out.println("      uri = (uri == null) ? \"\" : uri;");
        out.println("      return (java.lang.String) h.get(uri + ' ' + local);");
        out.println("    }");
        out.println("  }");
        out.flush();
    }

    public static String escape(String s) {
        StringBuffer b = new StringBuffer(s);
        int i = 0;
        while (i < b.length()) {
            char ch = b.charAt(i);
            switch (ch) {
                case '\"': 
                case '\'': 
                case '\\': {
                    b.insert(i, '\\');
                    break;
                }
                case '\t': {
                    b.deleteCharAt(i);
                    b.insert(i, "\\t");
                    break;
                }
                case '\r': {
                    b.deleteCharAt(i);
                    b.insert(i, "\\t");
                    break;
                }
                case '\n': {
                    b.deleteCharAt(i);
                    b.insert(i, "\\t");
                }
            }
            ++i;
        }
        return b.toString();
    }

    protected void generateOriginals(PrintStream out, int t, String nameOfClass) {
        out.println("  // The name of the type as it was in the schema");
        out.println("  public java.lang.String originalNameOfType() {");
        int orig = this.walker.getProperty(t, '\u00cb');
        String originalName = "";
        if (orig == -1) {
            out.println("    return null;");
        } else {
            originalName = this.walker.getString(orig);
            out.println("    return \"" + originalName + "\";");
        }
        out.println("  }");
        out.println();
        String originalNS = this.walker.getTargetNamespaceOf(t);
        out.println("  // The target namespace as it was in the schema");
        out.println("  public java.lang.String originalTargetNamespace() {");
        out.println("    return \"" + originalNS + "\";");
        out.println("  }");
        out.println();
        if (originalName.length() != 0) {
            this.typeMappingRegistry.put(originalNS + ' ' + originalName, this.walker.getNameOfType(t));
        }
    }

    public Hashtable getComplexFieldInfo() {
        return this.gct.fieldInfo;
    }
}

