/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.generator;

import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ArrayIterator
implements Enumeration {
    private int[] arrayDimensions;
    private int[] currentPos;
    private int dimension_count;
    private Object arrPtr;
    private boolean hasNextPosition;

    public ArrayIterator(int[] dimensions, Object array) {
        this.dimension_count = dimensions.length;
        this.arrayDimensions = new int[this.dimension_count];
        this.currentPos = new int[this.dimension_count];
        System.arraycopy(dimensions, 0, this.arrayDimensions, 0, this.dimension_count);
        this.arrPtr = array;
        this.hasNextPosition = true;
    }

    public void reset() {
        int i = 0;
        while (i < this.dimension_count) {
            this.currentPos[i] = 0;
            ++i;
        }
        this.hasNextPosition = true;
    }

    public Object nextElement() throws NoSuchElementException {
        if (this.hasNextPosition) {
            // empty if block
        }
        int i = 0;
        Object curArr = this.arrPtr;
        while (i < this.dimension_count - 1) {
            curArr = Array.get(curArr, this.currentPos[i]);
            ++i;
        }
        Object result = Array.get(curArr, this.currentPos[i]);
        this.nextPosition();
        return result;
    }

    public void setNext(Object element) {
        int i = 0;
        Object curArr = this.arrPtr;
        while (i < this.dimension_count - 1) {
            curArr = Array.get(curArr, this.currentPos[i]);
            ++i;
        }
        Array.set(curArr, this.currentPos[i], element);
        this.nextPosition();
    }

    public void setPosition(int[] position) throws Exception {
        if (position.length != this.dimension_count) {
            throw new Exception("Invalid position passed : not enough dimension ");
        }
        int i = 0;
        while (i < this.dimension_count) {
            if (position[i] >= this.arrayDimensions[i]) {
                throw new Exception("Invalid position passed : out of array !");
            }
            ++i;
        }
        System.arraycopy(position, 0, this.currentPos, 0, this.dimension_count);
    }

    public void nextPosition() {
        int pos = this.dimension_count - 1;
        while (pos >= 0) {
            if (this.currentPos[pos] < this.arrayDimensions[pos] - 1) {
                int n = pos;
                this.currentPos[n] = this.currentPos[n] + 1;
                int i = pos + 1;
                while (i < this.dimension_count) {
                    this.currentPos[i] = 0;
                    ++i;
                }
                break;
            }
            --pos;
        }
        if (pos == -1) {
            this.hasNextPosition = false;
        }
    }

    public boolean hasMoreElements() {
        return this.hasNextPosition;
    }

    public Object getArray() {
        return this.arrPtr;
    }
}

