/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.platform.internal.metrics.ui;

import com.tssap.selena.impl.model.elements.ModelMetrics;
import com.tssap.selena.license.CommonLicense;
import com.tssap.selena.license.UnaryOperation;
import com.tssap.selena.model.platform.internal.metrics.Metrics;
import com.tssap.selena.model.platform.internal.metrics.MetricsInfo;
import com.tssap.selena.model.platform.internal.metrics.MetricsListener;
import com.tssap.selena.model.platform.internal.metrics.ui.Messages;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.model.WorkbenchViewerSorter;
import org.eclipse.ui.part.ViewPart;

public class MetricsViewPart
extends ViewPart
implements MetricsListener {
    private int currentColumnNumber = 0;
    private boolean myReverse = false;
    private boolean featureAvailable = true;
    private TableViewer myControl;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        UnaryOperation function = new UnaryOperation(){

            public String execute(String value) {
                byte[] b = value.getBytes();
                int i = 0;
                while (i < value.length()) {
                    b[i] = (byte)(b[i] ^ i & 0xFF);
                    ++i;
                }
                return new String(b);
            }
        };
        if (!CommonLicense.isFeatureAvailable((String)"TSSAP", (String)"XJ", (UnaryOperation)function)) {
            this.featureAvailable = false;
        }
    }

    public void createPartControl(Composite parent) {
        if (!this.featureAvailable) {
            CommonLicense.createLimitedPane((Composite)parent, (String)"XJ");
            return;
        }
        this.myControl = new TableViewer(parent, 0);
        this.myControl.getTable().setHeaderVisible(true);
        this.myControl.getTable().setLinesVisible(true);
        this.myControl.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        TableColumn clazz = new TableColumn(this.myControl.getTable(), 0);
        TableColumn method = new TableColumn(this.myControl.getTable(), 0);
        TableColumn time = new TableColumn(this.myControl.getTable(), 0);
        TableColumn noc = new TableColumn(this.myControl.getTable(), 0);
        clazz.setText(Messages.getString("Class_3"));
        clazz.setWidth(400);
        method.setText(Messages.getString("Method_4"));
        method.setWidth(100);
        time.setText(Messages.getString("Time_spent_(ms.)_5"));
        time.setWidth(100);
        noc.setText(Messages.getString("NOC_6"));
        noc.setWidth(100);
        Metrics.addListener(this);
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = MetricsViewPart.this.myControl.getTable().indexOf((TableColumn)e.widget);
                if (MetricsViewPart.this.currentColumnNumber == column) {
                    MetricsViewPart.this.myReverse = !MetricsViewPart.this.myReverse;
                }
                MetricsViewPart.this.currentColumnNumber = column;
                MetricsViewPart.this.statisticChanged();
            }
        };
        int i = 0;
        while (i < this.myControl.getTable().getColumnCount()) {
            this.myControl.getTable().getColumn(i).addSelectionListener((SelectionListener)headerListener);
            ++i;
        }
    }

    public void setFocus() {
        if (!this.featureAvailable) {
            return;
        }
        if (!this.myControl.getTable().isDisposed()) {
            this.myControl.getTable().setFocus();
        }
    }

    public void statisticChanged() {
        this.myControl.getTable().removeAll();
        this.fillTable(Metrics.getStatistic());
    }

    protected void fillTable(Map data) {
        Object[] strings = this.getData(data, this.currentColumnNumber);
        int i = 0;
        while (i < strings.length) {
            TableItem item = new TableItem(this.myControl.getTable(), 0);
            item.setText((String[])strings[i]);
            ++i;
        }
    }

    protected Object[] getData(Map data, final int index) {
        String time;
        ArrayList<String[]> list = new ArrayList<String[]>();
        long total = 0L;
        Iterator keys = data.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String className = key.substring(0, key.lastIndexOf(58));
            String methodName = key.substring(key.lastIndexOf(58) + 1);
            total += ((MetricsInfo)data.get(key)).getTime();
            time = ((MetricsInfo)data.get(key)).getTime() + "";
            String noc = ((MetricsInfo)data.get(key)).getNOC() + "";
            list.add(new String[]{className, methodName, time, noc});
        }
        list.add(new String[]{Messages.getString("total_in_providers_9"), "", total + "", ""});
        total = 0L;
        Iterator keys2 = ModelMetrics.getResults().keySet().iterator();
        while (keys2.hasNext()) {
            String id = (String)keys2.next();
            Long t = (Long)ModelMetrics.getResults().get(id);
            time = Messages.getString("none_13");
            if (t != null) {
                time = t.toString();
                total += t.longValue();
            }
            list.add(new String[]{"", id, time, ""});
        }
        list.add(new String[]{Messages.getString("total_16"), "", total + "", ""});
        Object[] result = list.toArray(new Object[list.size()]);
        Arrays.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((String[])o1)[index];
                String s2 = ((String[])o2)[index];
                if (MetricsViewPart.this.myReverse) {
                    return -Collator.getInstance().compare(s1, s2);
                }
                return Collator.getInstance().compare(s1, s2);
            }
        });
        return result;
    }

    private class ProviderSorter
    extends ViewerSorter {
        private ProviderSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            TableItem item1 = (TableItem)e1;
            TableItem item2 = (TableItem)e2;
            String str1 = item1.getText(MetricsViewPart.this.currentColumnNumber);
            String str2 = item2.getText(MetricsViewPart.this.currentColumnNumber);
            return Collator.getInstance().compare(str1, str2);
        }
    }
}

