/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.platform.internal.metrics.providers;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.extension.PropertySetProvider;
import com.tssap.selena.model.platform.internal.metrics.Metrics;
import com.tssap.selena.model.platform.internal.metrics.providers.MethodNames;
import com.tssap.selena.model.platform.internal.metrics.providers.ProviderWrapperImpl;

public class MetricPropertySetProvider
extends ProviderWrapperImpl
implements PropertySetProvider,
MethodNames.PropertyProvider,
MethodNames.PropertySetProvider {
    private final PropertySetProvider realProvider;

    public MetricPropertySetProvider(PropertySetProvider realProvider) {
        super(realProvider);
        this.realProvider = realProvider;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        long time = System.currentTimeMillis();
        boolean result = this.realProvider.canSetPropertyValue(element, propertyName, propertyValue);
        time = System.currentTimeMillis() - time;
        this.countMetric("PropertySetProvider.canSetPropertyValue(String)", time);
        return result;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        long time = System.currentTimeMillis();
        boolean result = this.realProvider.canAddProperty(element, propertyName, propertyValue);
        time = System.currentTimeMillis() - time;
        this.countMetric("PropertySetProvider.canAddProperty", time);
        return result;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        long time = System.currentTimeMillis();
        this.realProvider.setPropertyValue(element, propertyName, propertyValue);
        time = System.currentTimeMillis() - time;
        this.countMetric("PropertySetProvider.setPropertyValue(String)", time);
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        long time = System.currentTimeMillis();
        Property result = this.realProvider.addProperty(element, propertyName, propertyValue);
        time = System.currentTimeMillis() - time;
        this.countMetric("PropertySetProvider.addProperty", time);
        return result;
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        long time = System.currentTimeMillis();
        boolean result = this.realProvider.isPropertyProviderApplicable(element, propertyName);
        time = System.currentTimeMillis() - time;
        this.countMetric("PropertyProvider.isPropertyProviderApplicable", time);
        return result;
    }

    protected void countMetric(String methodname, long time) {
        Metrics.countMetric(this.realProvider, methodname, time);
    }
}

