/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.platform.internal.metrics.providers;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.platform.internal.metrics.Metrics;
import com.tssap.selena.model.platform.internal.metrics.providers.MethodNames;
import com.tssap.selena.model.platform.internal.metrics.providers.ProviderWrapperImpl;

public class MetricPropertyGetProvider
extends ProviderWrapperImpl
implements PropertyGetProvider,
MethodNames.PropertyProvider,
MethodNames.PropertyGetProvider {
    private final PropertyGetProvider realProvider;

    public MetricPropertyGetProvider(PropertyGetProvider realProvider) {
        super(realProvider);
        this.realProvider = realProvider;
    }

    public String getPropertyValue(Element element, String propertyName) {
        long time = System.currentTimeMillis();
        String result = null;
        int i = 0;
        while (i < Metrics.getMultiplier()) {
            result = this.realProvider.getPropertyValue(element, propertyName);
            ++i;
        }
        time = System.currentTimeMillis() - time;
        this.countMetric("PropertyGetProvider.getPropertyValue", time / (long)Metrics.getMultiplier());
        return result;
    }

    public Property getProperty(Element element, String propertyName) {
        long time = System.currentTimeMillis();
        Property result = null;
        int i = 0;
        while (i < Metrics.getMultiplier()) {
            result = this.realProvider.getProperty(element, propertyName);
            ++i;
        }
        time = System.currentTimeMillis() - time;
        this.countMetric("PropertyGetProvider.getProperty", time / (long)Metrics.getMultiplier());
        return result;
    }

    public boolean hasProperty(Element element, String propertyName) {
        long time = System.currentTimeMillis();
        boolean result = false;
        int i = 0;
        while (i < Metrics.getMultiplier()) {
            result = this.realProvider.hasProperty(element, propertyName);
            ++i;
        }
        time = System.currentTimeMillis() - time;
        this.countMetric("PropertyGetProvider.hasProperty", time / (long)Metrics.getMultiplier());
        return result;
    }

    public PropertyEnumeration properties(Element element) {
        long time = System.currentTimeMillis();
        PropertyEnumeration result = null;
        int i = 0;
        while (i < Metrics.getMultiplier()) {
            result = this.realProvider.properties(element);
            ++i;
        }
        time = System.currentTimeMillis() - time;
        this.countMetric("PropertyGetProvider.properties", time / (long)Metrics.getMultiplier());
        return result;
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        long time = System.currentTimeMillis();
        PropertyEnumeration result = null;
        int i = 0;
        while (i < Metrics.getMultiplier()) {
            result = this.realProvider.properties(element, propertyName);
            ++i;
        }
        time = System.currentTimeMillis() - time;
        this.countMetric("PropertyGetProvider.properties (String)", time / (long)Metrics.getMultiplier());
        return result;
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        long time = System.currentTimeMillis();
        boolean result = false;
        int i = 0;
        while (i < Metrics.getMultiplier()) {
            result = this.realProvider.hasPropertyValue(element, propertyName, propertyValue);
            ++i;
        }
        time = System.currentTimeMillis() - time;
        this.countMetric("PropertyGetProvider.hasPropertyValue", time / (long)Metrics.getMultiplier());
        return result;
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        long time = System.currentTimeMillis();
        boolean result = false;
        int i = 0;
        while (i < Metrics.getMultiplier()) {
            result = this.realProvider.isPropertyProviderApplicable(element, propertyName);
            ++i;
        }
        time = System.currentTimeMillis() - time;
        this.countMetric("PropertyProvider.isPropertyProviderApplicable", time / (long)Metrics.getMultiplier());
        return result;
    }

    protected void countMetric(String methodname, long time) {
        Metrics.countMetric(this.realProvider, methodname, time);
    }
}

