/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.platform.internal.metrics.providers;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.PasteProvider;
import com.tssap.selena.model.platform.internal.metrics.Metrics;
import com.tssap.selena.model.platform.internal.metrics.providers.MethodNames;
import com.tssap.selena.model.platform.internal.metrics.providers.ProviderWrapperImpl;

public class MetricPasteProvider
extends ProviderWrapperImpl
implements PasteProvider,
MethodNames.PasteProvider {
    private final PasteProvider realProvider;

    public MetricPasteProvider(PasteProvider realProvider) {
        super(realProvider);
        this.realProvider = realProvider;
    }

    public boolean isPasteProviderApplicable(Entity container) {
        long time = System.currentTimeMillis();
        boolean result = this.realProvider.isPasteProviderApplicable(container);
        time = System.currentTimeMillis() - time;
        this.countMetric("pasteProvider.isApplicable", time);
        return result;
    }

    public boolean canPaste(Entity container, Element element, Element anchor, boolean before) {
        long time = System.currentTimeMillis();
        boolean result = this.realProvider.canPaste(container, element, anchor, before);
        time = System.currentTimeMillis() - time;
        this.countMetric("pasteProvider.canPaste", time);
        return result;
    }

    public UniqueName paste(Entity container, Element element, Element createdElement, Element anchor, boolean before) {
        long time = System.currentTimeMillis();
        UniqueName result = this.realProvider.paste(container, element, createdElement, anchor, before);
        time = System.currentTimeMillis() - time;
        this.countMetric("pasteProvider.paste", time);
        return result;
    }

    protected void countMetric(String methodname, long time) {
        Metrics.countMetric(this.realProvider, methodname, time);
    }
}

