/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.platform.internal.metrics.providers;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.LinkProvider;
import com.tssap.selena.model.platform.internal.metrics.Metrics;
import com.tssap.selena.model.platform.internal.metrics.providers.MethodNames;
import com.tssap.selena.model.platform.internal.metrics.providers.ProviderWrapperImpl;

public class MetricLinkProvider
extends ProviderWrapperImpl
implements LinkProvider,
MethodNames.LinkProvider {
    private final LinkProvider realProvider;

    public MetricLinkProvider(LinkProvider realProvider) {
        super(realProvider);
        this.realProvider = realProvider;
    }

    public boolean isLinkProviderApplicable(Entity link) {
        boolean result = false;
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < Metrics.getMultiplier()) {
            result = this.realProvider.isLinkProviderApplicable(link);
            ++i;
        }
        time = System.currentTimeMillis() - time;
        this.countMetric("linkProvider.isApplicable", time / (long)Metrics.getMultiplier());
        return result;
    }

    public UniqueNameEnumeration participants(Entity link, String role) {
        UniqueNameEnumeration result = null;
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < Metrics.getMultiplier()) {
            result = this.realProvider.participants(link, role);
            ++i;
        }
        time = System.currentTimeMillis() - time;
        this.countMetric("linkProvider.participants", time / (long)Metrics.getMultiplier());
        return result;
    }

    public StringEnumeration participantRoles(Entity link) {
        StringEnumeration result = null;
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < Metrics.getMultiplier()) {
            result = this.realProvider.participantRoles(link);
            ++i;
        }
        time = System.currentTimeMillis() - time;
        this.countMetric("linkProvider.participantRoles", time / (long)Metrics.getMultiplier());
        return result;
    }

    public void setParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        long time = System.currentTimeMillis();
        this.realProvider.setParticipant(link, role, oldParticipant, newParticipant);
        time = System.currentTimeMillis() - time;
        this.countMetric("linkProvider.setParticipant", time);
    }

    public void setParticipant(Entity link, Element participant, String oldRole, String newRole) {
        long time = System.currentTimeMillis();
        this.realProvider.setParticipant(link, participant, oldRole, newRole);
        time = System.currentTimeMillis() - time;
        this.countMetric("linkProvider.setParticipant", time);
    }

    public boolean canSetParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        long time = System.currentTimeMillis();
        boolean result = this.realProvider.canSetParticipant(link, role, oldParticipant, newParticipant);
        time = System.currentTimeMillis() - time;
        this.countMetric("linkProvider.canSetParticipant(String)", time);
        return result;
    }

    public boolean canSetParticipant(Entity link, Element participant, String oldRole, String newRole) {
        long time = System.currentTimeMillis();
        boolean result = this.realProvider.canSetParticipant(link, participant, oldRole, newRole);
        time = System.currentTimeMillis() - time;
        this.countMetric("linkProvider.canSetParticipant(Element)", time);
        return result;
    }

    protected void countMetric(String methodname, long time) {
        Metrics.countMetric(this.realProvider, methodname, time);
    }
}

