/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.platform.internal.metrics.providers;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.DeleteProvider;
import com.tssap.selena.model.platform.internal.metrics.Metrics;
import com.tssap.selena.model.platform.internal.metrics.providers.MethodNames;
import com.tssap.selena.model.platform.internal.metrics.providers.ProviderWrapperImpl;

public class MetricDeleteProvider
extends ProviderWrapperImpl
implements DeleteProvider,
MethodNames.DeleteProvider {
    private final DeleteProvider realProvider;

    public MetricDeleteProvider(DeleteProvider realProvider) {
        super(realProvider);
        this.realProvider = realProvider;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        boolean result = false;
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < Metrics.getMultiplier()) {
            result = this.realProvider.isDeleteProviderApplicable(element);
            ++i;
        }
        time = System.currentTimeMillis() - time;
        this.countMetric("DeleteProvider.isApplicable", time / (long)Metrics.getMultiplier());
        return result;
    }

    public boolean canDelete(Element element) {
        long time = System.currentTimeMillis();
        boolean result = this.realProvider.canDelete(element);
        time = System.currentTimeMillis() - time;
        this.countMetric("DeleteProvider.canDelete", time);
        return result;
    }

    public void delete(Element element) {
        long time = System.currentTimeMillis();
        this.realProvider.delete(element);
        time = System.currentTimeMillis() - time;
        this.countMetric("DeleteProvider.delete", time);
    }

    public boolean isDeleted(Element element) {
        boolean result = false;
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < Metrics.getMultiplier()) {
            result = this.realProvider.isDeleted(element);
            ++i;
        }
        time = System.currentTimeMillis() - time;
        this.countMetric("DeleteProvider.isDelete", time / (long)Metrics.getMultiplier());
        return result;
    }

    public Object unwrapProvider() {
        return this.realProvider;
    }

    protected void countMetric(String methodname, long time) {
        Metrics.countMetric(this.realProvider, methodname, time);
    }
}

