/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.platform.internal.metrics;

import com.tssap.selena.model.platform.internal.metrics.MetricsInfo;
import com.tssap.selena.model.platform.internal.metrics.MetricsListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Metrics {
    private static Map myStatistic = new HashMap();
    private static Collection myListeners = new HashSet();

    public static Map getStatistic() {
        return myStatistic;
    }

    public static void countMetric(Object provider, String methodName, long time) {
        String key = provider.getClass().getName() + ":" + methodName;
        if (!myStatistic.containsKey(key)) {
            myStatistic.put(key, new MetricsInfo());
        }
        MetricsInfo info = (MetricsInfo)myStatistic.get(key);
        info.update(time);
    }

    public static void update() {
        Metrics.fireStatisticChanged();
    }

    public static void flushStatistic() {
        myStatistic.clear();
        Metrics.fireStatisticChanged();
    }

    public static int getMultiplier() {
        return 1;
    }

    public static void addListener(MetricsListener listener) {
        myListeners.add(listener);
    }

    public static void removeListener(MetricsListener listener) {
        myListeners.remove(listener);
    }

    protected static void fireStatisticChanged() {
        Iterator listeners = myListeners.iterator();
        while (listeners.hasNext()) {
            MetricsListener listener = (MetricsListener)listeners.next();
            listener.statisticChanged();
        }
    }
}

