/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.platform.internal.eclipse;

import com.tssap.selena.impl.model.elements.ModelPlugin;
import com.tssap.selena.model.platform.internal.eclipse.EclipsePlatform;
import com.tssap.selena.model.util.UndoTransparableCommand;

public class ReadWriteLock {
    private static int myNestLevel = 0;
    private static int myCommandsCount = 0;
    private static Object myLock = new Integer(13);

    private ReadWriteLock() {
    }

    public static void commandAdded(Runnable runnable) {
        Object object = myLock;
        synchronized (object) {
            ++myCommandsCount;
            if (myNestLevel == 0) {
                ReadWriteLock.setUndoMark(runnable);
            }
        }
    }

    public static void commandStarted(Runnable command) {
        if (myNestLevel == 0 && myCommandsCount == 0) {
            ReadWriteLock.setUndoMark(command);
        }
        ++myNestLevel;
    }

    public static void commandFinished() {
        --myNestLevel;
        if (ReadWriteLock.isQueueEmpty()) {
            ReadWriteLock.update();
        }
    }

    public static void commandRemoved() {
        Object object = myLock;
        synchronized (object) {
            --myCommandsCount;
        }
        if (ReadWriteLock.isQueueEmpty()) {
            ReadWriteLock.update();
        }
    }

    public static void update() {
        ++myNestLevel;
        ((EclipsePlatform)ModelPlugin.getDefault().getPlatform()).forceUpdate();
        --myNestLevel;
    }

    private static void setUndoMark(Runnable command) {
        if (!(command instanceof UndoTransparableCommand)) {
            ((EclipsePlatform)ModelPlugin.getDefault().getPlatform()).fireUndoMarkerStarted();
        }
    }

    private static boolean isQueueEmpty() {
        boolean empty = false;
        Object object = myLock;
        synchronized (object) {
            empty = myCommandsCount == 0 && myNestLevel == 0;
        }
        return empty;
    }
}

