/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.platform.internal.eclipse;

import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.platform.ProviderDescriptor;
import com.tssap.selena.model.platform.eclipse.EclipsePlatformPlugin;
import com.tssap.selena.model.platform.internal.eclipse.EclipseProjectWatcher;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ProviderDescriptorImpl
implements ProviderDescriptor {
    public static final String TYPE_ATTRIBUTE = "class";
    public static final String ID_ATTRIBUTE = "id";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ENTITY_TYPE = "entity";
    public static final String REFERENCE_COLLECTION_TYPE = "referencecollection";
    public static final String REFERENCE_TYPE = "reference";
    public static final String TYPE_TAG = "type";
    public static final String META_TAG = "meta";
    public static final String NATURE_TAG = "nature";
    public static final String OLD_NATURE_TAG = "requires";
    public static final String OLD_NATURE_ATTRIBUTE = "nature";
    public static final String DOMAIN_TAG = "domain";
    public static final String SUBDOMAIN_TAG = "subdomain";
    public static final String PROPERTY_TAG = "property";
    public static final String METACLASS_TAG = "metaclass";
    public static final String LOCATION_TAG = "location";
    public static final String SEPARATOR = ",";
    private IConfigurationElement myConfiguration;
    private List myAdditionalMetas;
    private List myConfigurations;
    private Collection myNatures;
    private Map myDomains;
    private Map mySubdomains;
    private Map myPropertyNames;
    private Map myTypes;
    private Map myLocations;

    public ProviderDescriptorImpl(IConfigurationElement configuration, List metas) {
        this.myConfiguration = configuration;
        this.myAdditionalMetas = metas;
        this.myConfigurations = new ArrayList();
        if (metas != null) {
            this.myConfigurations.addAll(metas);
        }
        this.myConfigurations.add(configuration);
    }

    public String getClassName() {
        String className = this.myConfiguration.getAttributeAsIs("class");
        if (className != null) {
            className = className.trim();
        }
        return className;
    }

    public Object instantiateProvider() {
        try {
            return this.myConfiguration.createExecutableExtension("class");
        }
        catch (Throwable superBug) {
            System.err.println("Can't instantiate class :" + this.myConfiguration.getAttributeAsIs("class"));
            System.err.println("Problem while instatiating provider declared in: " + this.myConfiguration.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier());
            superBug.printStackTrace();
            return null;
        }
    }

    public boolean isEntityProvider() {
        return ENTITY_TYPE.equals(this.myConfiguration.getAttribute("class"));
    }

    public boolean isReferenceCollectionProvider() {
        return REFERENCE_COLLECTION_TYPE.equals(this.myConfiguration.getAttribute("class"));
    }

    public boolean isReferenceProvider() {
        return REFERENCE_TYPE.equals(this.myConfiguration.getAttribute("class"));
    }

    public Iterator types() {
        if (this.myTypes == null) {
            this.myTypes = ProviderDescriptorImpl.loadTypes(this.myConfigurations);
        }
        return this.myTypes.keySet().iterator();
    }

    public boolean isProviderApplicable(Model model) {
        if (ProviderDescriptorImpl.isToBeIgnored(model)) {
            return false;
        }
        if (this.myNatures == null) {
            this.myNatures = ProviderDescriptorImpl.loadMetaInfo(this.myConfigurations, "nature", ID_ATTRIBUTE);
            this.myNatures.addAll(ProviderDescriptorImpl.loadMetaInfo(this.myConfigurations, OLD_NATURE_TAG, "nature"));
        }
        if (this.myNatures.isEmpty()) {
            return true;
        }
        IProject project = ModelUinSupport.getProject((UniqueName)model.getUniqueName());
        if (project == null || !project.exists() || !project.isOpen()) {
            return false;
        }
        String[] natures = null;
        try {
            natures = project.getDescription().getNatureIds();
        }
        catch (CoreException cantFetchNatures) {
            cantFetchNatures.printStackTrace();
        }
        if (natures != null) {
            int i = 0;
            while (i < natures.length) {
                if (this.myNatures.contains(natures[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean isToBeIgnored(Model model) {
        String modelName = model.getUniqueName().getName();
        if (modelName == null || !EclipseProjectWatcher.isToBeIgnored(modelName)) {
            return false;
        }
        ResourcesPlugin.getPlugin();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects != null) {
            int i = 0;
            while (i < projects.length) {
                if (modelName.equals(projects[i].getName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isProviderAssignableFrom(Class providerClazz) {
        if (this.myTypes == null) {
            this.myTypes = ProviderDescriptorImpl.loadTypes(this.myConfigurations);
        }
        return this.myTypes.containsKey(ProviderDescriptorImpl.getTypeName(providerClazz));
    }

    public StringEnumeration domains(Class clazz) {
        if (this.myDomains == null) {
            this.myDomains = new HashMap();
        }
        if (!this.myDomains.containsKey(clazz)) {
            Collection domains = this.loadMetaInfo(this.myConfiguration, this.myAdditionalMetas, clazz, DOMAIN_TAG, NAME_ATTRIBUTE);
            if (domains.isEmpty()) {
                domains.add("");
            }
            this.myDomains.put(clazz, domains);
        }
        return EnumerationConverter.toStringEnumeration(((Collection)this.myDomains.get(clazz)).iterator());
    }

    public StringEnumeration locations(Class clazz) {
        if (this.myLocations == null) {
            this.myLocations = new HashMap();
        }
        if (!this.myLocations.containsKey(clazz)) {
            Collection locations = this.loadMetaInfo(this.myConfiguration, this.myAdditionalMetas, clazz, LOCATION_TAG, NAME_ATTRIBUTE);
            if (locations.isEmpty()) {
                locations.add("");
            }
            this.myLocations.put(clazz, locations);
        }
        return EnumerationConverter.toStringEnumeration(((Collection)this.myLocations.get(clazz)).iterator());
    }

    public StringEnumeration subdomains(Class clazz) {
        if (this.mySubdomains == null) {
            this.mySubdomains = new HashMap();
        }
        if (!this.mySubdomains.containsKey(clazz)) {
            Collection subdomains = this.loadMetaInfo(this.myConfiguration, this.myAdditionalMetas, clazz, SUBDOMAIN_TAG, NAME_ATTRIBUTE);
            if (subdomains.isEmpty()) {
                subdomains.add("");
            }
            this.mySubdomains.put(clazz, subdomains);
        }
        return EnumerationConverter.toStringEnumeration(((Collection)this.mySubdomains.get(clazz)).iterator());
    }

    public StringEnumeration propertyNames(Class clazz) {
        if (this.myPropertyNames == null) {
            this.myPropertyNames = new HashMap();
        }
        if (!this.myPropertyNames.containsKey(clazz)) {
            Collection propertynames = this.loadMetaInfo(this.myConfiguration, this.myAdditionalMetas, clazz, PROPERTY_TAG, NAME_ATTRIBUTE);
            propertynames.addAll(this.loadMetaInfo(this.myConfiguration, this.myAdditionalMetas, clazz, METACLASS_TAG, NAME_ATTRIBUTE));
            if (propertynames.isEmpty()) {
                propertynames.add("");
            }
            this.myPropertyNames.put(clazz, propertynames);
        }
        return EnumerationConverter.toStringEnumeration(((Collection)this.myPropertyNames.get(clazz)).iterator());
    }

    protected Collection loadMetaInfo(IConfigurationElement config, List metas, Class clazz, String tag, String attribute) {
        if (this.myTypes == null) {
            this.myTypes = ProviderDescriptorImpl.loadTypes(this.myConfigurations);
        }
        List subconfigs = (List)this.myTypes.get(ProviderDescriptorImpl.getTypeName(clazz));
        return ProviderDescriptorImpl.loadMetaInfo(subconfigs, tag, attribute);
    }

    protected static Collection loadMetaInfo(List configs, String tag, String attribute) {
        Collection values = new HashSet();
        int i = 0;
        while (i < configs.size()) {
            IConfigurationElement[] toplevel = ((IConfigurationElement)configs.get(i)).getChildren(tag);
            if (toplevel != null) {
                if (((IConfigurationElement)configs.get(i)).getAttributeAsIs(tag) != null) {
                    values = ProviderDescriptorImpl.addValues(values, ((IConfigurationElement)configs.get(i)).getAttributeAsIs(tag));
                }
                int j = 0;
                while (j < toplevel.length) {
                    String value = toplevel[j].getAttributeAsIs(attribute);
                    if (value != null) {
                        values = ProviderDescriptorImpl.addValues(values, value);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return values;
    }

    protected static Collection addValues(Collection values, String sequence) {
        StringTokenizer tokens = new StringTokenizer(sequence, SEPARATOR);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            values.add(token);
        }
        return values;
    }

    protected static String getTypeName(Class clazz) {
        String name = clazz.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    protected static Map loadTypes(List myConfigs) {
        HashMap map = new HashMap();
        int j = 0;
        while (j < myConfigs.size()) {
            IConfigurationElement[] metas = ((IConfigurationElement)myConfigs.get(j)).getChildren(META_TAG);
            int i = 0;
            while (i < metas.length) {
                String value = metas[i].getAttributeAsIs("class");
                if (value != null) {
                    StringTokenizer types = new StringTokenizer(value, SEPARATOR);
                    while (types.hasMoreTokens()) {
                        String type = types.nextToken().trim();
                        if (!map.containsKey(type)) {
                            map.put(type, new ArrayList());
                        }
                        ((List)map.get(type)).add(metas[i]);
                    }
                }
                ++i;
            }
            if (map.keySet().size() == 0) {
                EclipsePlatformPlugin.getPlugin().getLog().log((IStatus)new Status(2, "com.tssap.selena.model", 0, "provider " + ((IConfigurationElement)myConfigs.get(j)).getAttribute("class") + " doesn't contain meta infromation. will be disabled.", null));
            }
            ++j;
        }
        return map;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[PD] : ");
        result.append(this.myConfiguration.getAttribute("class"));
        return result.toString();
    }

    public Object getProviderClassID() {
        if (this.myConfiguration == null || this.getClassName() == null) {
            return null;
        }
        try {
            String className = this.getClassName();
            ClassLoader classLoader = this.myConfiguration.getDeclaringExtension().getDeclaringPluginDescriptor().getPluginClassLoader();
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFound) {
            classNotFound.printStackTrace();
            return null;
        }
    }
}

