/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.platform.internal.eclipse;

import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.platform.eclipse.EclipsePlatformPlugin;
import com.tssap.selena.model.platform.internal.eclipse.INatureListener;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class EclipseProjectWatcher
implements IResourceChangeListener {
    private static final QualifiedName PREV_NATURE_IDS = new QualifiedName(EclipsePlatformPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), "prev-nature-ids");
    private HashSet myNatureListeners = new HashSet();
    private static EclipseProjectWatcher myself;

    private EclipseProjectWatcher() {
    }

    private void init() {
    }

    public static EclipseProjectWatcher getProjectWatcher() {
        if (myself == null) {
            myself = new EclipseProjectWatcher();
            myself.init();
        }
        return myself;
    }

    public static void showIncorrectModelWarning(final String projectName) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), "Incorrect project name", null, "Unable to work with the project, which name contains ( or ) symbols. Such a project names are not supported now. Please, rename your project: \"" + projectName + "\"", 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
            }
        });
    }

    public static boolean isToBeIgnored(String projectName) {
        return projectName.indexOf("(") > -1 || projectName.indexOf(")") > -1;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if ((event.getType() & 1) > 0) {
            this.processDelta(event.getDelta());
        }
    }

    private void processDelta(IResourceDelta delta) {
        if (delta == null) {
            return;
        }
        IResource resource = delta.getResource();
        if (resource == null) {
            return;
        }
        switch (resource.getType()) {
            case 8: {
                IResourceDelta[] subDeltas = delta.getAffectedChildren();
                int i = 0;
                while (i < subDeltas.length) {
                    this.processDelta(subDeltas[i]);
                    ++i;
                }
                break;
            }
            case 4: {
                this.processProjectDelta(delta);
            }
        }
    }

    private void processProjectDelta(IResourceDelta delta) {
        IProject project = (IProject)delta.getResource();
        final String projectName = project.getName();
        boolean isOpenCloseEvent = (delta.getFlags() & 0x4000) > 0;
        final Runnable[] commands = new Runnable[1];
        if (isOpenCloseEvent && project.isOpen()) {
            commands[0] = new Runnable(){

                public void run() {
                    Model model = EclipseProjectWatcher.findModel(projectName);
                    if (model == null) {
                        UniqueName modelUin = ModelUinSupport.createModelUin((String)projectName);
                        model = ModelAccess.createModel((UniqueName)modelUin);
                        if (EclipseProjectWatcher.isToBeIgnored(projectName)) {
                            EclipseProjectWatcher.showIncorrectModelWarning(projectName);
                        }
                    }
                }
            };
        } else if (isOpenCloseEvent && !project.isOpen() || (delta.getKind() & 2) > 0) {
            commands[0] = new Runnable(){

                public void run() {
                    Model model = EclipseProjectWatcher.findModel(projectName);
                    if (model != null) {
                        model.delete();
                    }
                }
            };
        } else if (project.isOpen() && (delta.getFlags() & 0x80000) > 0) {
            this.handleProjectDescriptionChange(project);
        }
        if (commands[0] != null) {
            if (!Display.getDefault().getThread().equals(Thread.currentThread())) {
                ModelAccess.runCommandLater((Runnable)new Runnable(){

                    public void run() {
                        ModelAccess.runCommand((Runnable)commands[0]);
                    }
                });
            } else {
                ModelAccess.runCommand((Runnable)commands[0]);
            }
        }
    }

    private static Model findModel(String projectId) {
        if (projectId == null) {
            return null;
        }
        Enumeration models = ModelAccess.models();
        while (models.hasMoreElements()) {
            Model model = (Model)models.nextElement();
            if (!projectId.equals(ModelUinSupport.getProjectId((UniqueName)model.getUniqueName()))) continue;
            return model;
        }
        return null;
    }

    public void addNatureListener(INatureListener listener) {
        this.myNatureListeners.add(listener);
    }

    public void removeNatureListener(INatureListener listener) {
        this.myNatureListeners.remove(listener);
    }

    protected void handleProjectDescriptionChange(IProject project) {
        try {
            Object[] prevNatures = (String[])project.getSessionProperty(PREV_NATURE_IDS);
            if (Arrays.equals(prevNatures, project.getDescription().getNatureIds())) {
                return;
            }
        }
        catch (CoreException ex) {
            EclipsePlatformPlugin.getPlugin().getLog().log(ex.getStatus());
        }
        this.fireNaturesChanged(project);
        EclipseProjectWatcher.updateStoredNatures(project);
    }

    protected void fireNaturesChanged(IProject project) {
        Iterator it = new HashSet(this.myNatureListeners).iterator();
        while (it.hasNext()) {
            ((INatureListener)it.next()).projectNaturesChanged(project);
        }
    }

    static void updateStoredNatures(IProject project) {
        try {
            project.setSessionProperty(PREV_NATURE_IDS, (Object)project.getDescription().getNatureIds());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

