/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.platform.internal.eclipse;

import com.tssap.selena.impl.model.elements.ModelPlugin;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.platform.DebugLevel;
import com.tssap.selena.model.platform.Platform;
import com.tssap.selena.model.platform.PlatformEvent;
import com.tssap.selena.model.platform.PlatformListener;
import com.tssap.selena.model.platform.eclipse.EclipsePlatformPlugin;
import com.tssap.selena.model.platform.internal.eclipse.EclipseProjectWatcher;
import com.tssap.selena.model.platform.internal.eclipse.INatureListener;
import com.tssap.selena.model.platform.internal.eclipse.ProviderDescriptorImpl;
import com.tssap.selena.model.platform.internal.eclipse.ReadWriteLock;
import com.tssap.selena.model.platform.internal.eclipse.ViewFactoryDescriptorImpl;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.ShortCommand;
import com.tssap.selena.model.util.UndoTransparableCommand;
import com.tssap.selena.model.util.UpdateCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class EclipsePlatform
extends Platform
implements INatureListener {
    private static final String METAINFO_EXTENSION_POINT = "metainfo";
    private static final String PROVIDER_EXTENSION_POINT = "provider";
    private static final String VIEW_FACTORY_EXTENSION_POINT = "viewFactory";
    private static final String PROVIDER_METAINFO_EXTENSION_POINT = "provider_metainfo";
    private static final String PROVIDER_TAG = "provider";
    private static final String PROVIDER_META_TAG = "provider_metainfo";
    private static final String VIEW_FACTORY_TAG = "viewFactory";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static boolean ourInitialModelCreation = false;
    private static final Runnable MY_EMPTY_COMMAND = new UndoTransparableCommand(){

        public void run() {
        }
    };
    private static Map myMetasMap;
    private static List myConfigsList;
    private HashSet myListeners = new HashSet();
    private Collection myProviderDescriptors;
    private Collection myViewFactoryDescriptors;
    private DebugLevel myDefaultDebugLevel = new DebugLevel(){
        private DebugLevel.LogLevel myLevel;
        private Map myLevelsMap = new HashMap();

        public boolean isMetricsEnabled() {
            return false;
        }

        public DebugLevel.LogLevel getLogLevel(String category) {
            if (!this.myLevelsMap.containsKey(category)) {
                DebugLevel.LogLevel global = this.getLogLevel();
                String key = EclipsePlatformPlugin.getPlugin().getDescriptor().getUniqueIdentifier() + "/debug/" + category;
                String level = org.eclipse.core.runtime.Platform.getDebugOption((String)key);
                if ("true".equalsIgnoreCase(level)) {
                    this.myLevelsMap.put(category, DebugLevel.ALL);
                } else if ("false".equalsIgnoreCase(level)) {
                    this.myLevelsMap.put(category, DebugLevel.NONE);
                } else {
                    this.myLevelsMap.put(category, global);
                }
            }
            return (DebugLevel.LogLevel)this.myLevelsMap.get(category);
        }

        public DebugLevel.LogLevel getLogLevel() {
            if (this.myLevel == null) {
                this.myLevel = EclipsePlatformPlugin.getPlugin().isDebugging() ? DebugLevel.ALL : DebugLevel.NONE;
            }
            return this.myLevel;
        }
    };

    public EclipsePlatform() {
        if (DebugLevel.ALL.equals(this.getDebugLevel().getLogLevel("platform"))) {
            System.err.println("[model.platform] instantiated");
        }
    }

    public void contentsChanged() {
        this.runCommandLater(MY_EMPTY_COMMAND, "");
    }

    public void modelDeleted(Model model) {
        IProject project = ModelUinSupport.getProject((UniqueName)model.getUniqueName());
        if (project != null && project.exists() && project.isOpen()) {
            try {
                project.delete(true, null);
            }
            catch (CoreException eclipseException) {
                EclipsePlatformPlugin.getPlugin().getLog().log((IStatus)new Status(4, EclipsePlatformPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "Project could not be deleted", (Throwable)eclipseException));
            }
        }
    }

    public void modelCreated(Model model) {
        IProject project = ModelUinSupport.getProject((UniqueName)model.getUniqueName());
        if (project != null && project.exists() && project.isOpen()) {
            EclipseProjectWatcher.updateStoredNatures(project);
        }
    }

    public void projectNaturesChanged(IProject project) {
        final Model model = ModelAccess.getModel((UniqueName)ModelUinSupport.createModelUin((String)project.getName()));
        if (model != null) {
            ModelAccess.runCommandLater((Runnable)new Runnable(){

                public void run() {
                    EclipsePlatform.this.fireProvidersSetChanged(model);
                }
            });
        }
    }

    public DebugLevel getDebugLevel() {
        return this.myDefaultDebugLevel;
    }

    public void removePlatformListener(PlatformListener listener) {
        this.myListeners.remove(listener);
        if (this.myListeners.size() == 0) {
            EclipseProjectWatcher.getProjectWatcher().removeNatureListener(this);
        }
    }

    public void addPlatformListener(PlatformListener listener) {
        this.myListeners.add(listener);
        if (this.myListeners.size() == 1) {
            EclipseProjectWatcher.getProjectWatcher().addNatureListener(this);
        }
    }

    public void forceUpdate() {
        Iterator it = this.myListeners.iterator();
        while (it.hasNext()) {
            PlatformListener listener = (PlatformListener)it.next();
            listener.update();
        }
    }

    public void fireProvidersSetChanged(Model model) {
        PlatformEvent event = null;
        Iterator it = this.myListeners.iterator();
        while (it.hasNext()) {
            PlatformListener listener;
            if (event == null) {
                event = new PlatformEvent((Object)this);
            }
            if (!((listener = (PlatformListener)it.next()) instanceof Model) || listener != model) continue;
            listener.providersSetChanged(event);
        }
    }

    public void fireUndoMarkerStarted() {
        Iterator it = this.myListeners.iterator();
        while (it.hasNext()) {
            ((PlatformListener)it.next()).undoMarkerStarted();
        }
    }

    public Enumeration providerDescriptors() {
        if (this.myProviderDescriptors == null) {
            this.myProviderDescriptors = new ArrayList();
            IExtensionPoint extensionPoint = ModelPlugin.getDefault().getDescriptor().getExtensionPoint("provider");
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configs = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configs.length) {
                    if ("provider".equals(configs[j].getName())) {
                        this.myProviderDescriptors.add(new ProviderDescriptorImpl(configs[j], EclipsePlatform.getMetas(configs[j])));
                    }
                    ++j;
                }
                ++i;
            }
        }
        return Collections.enumeration(this.myProviderDescriptors);
    }

    public Enumeration viewFactoryDescriptors() {
        if (this.myViewFactoryDescriptors == null) {
            this.myViewFactoryDescriptors = new ArrayList();
            IExtensionPoint extensionPoint = ModelPlugin.getDefault().getDescriptor().getExtensionPoint("viewFactory");
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configs = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configs.length) {
                    if ("viewFactory".equals(configs[j].getName())) {
                        this.myViewFactoryDescriptors.add(new ViewFactoryDescriptorImpl(configs[j]));
                    }
                    ++j;
                }
                ++i;
            }
        }
        return Collections.enumeration(this.myViewFactoryDescriptors);
    }

    public void runCommand(Runnable runnable, String name) {
        ReadWriteLock.commandStarted(runnable);
        try {
            if (runnable != MY_EMPTY_COMMAND) {
                if (runnable instanceof ShortCommand) {
                    runnable.run();
                } else {
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
                }
                if (runnable instanceof UpdateCommand) {
                    ReadWriteLock.update();
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ReadWriteLock.commandFinished();
            throw throwable;
        }
        ReadWriteLock.commandFinished();
    }

    public void runCommandLater(final Runnable runnable, String name) {
        ReadWriteLock.commandAdded(runnable);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ReadWriteLock.commandStarted(runnable);
                try {
                    if (runnable != MY_EMPTY_COMMAND) {
                        if (runnable instanceof ShortCommand) {
                            runnable.run();
                        } else {
                            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
                        }
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    ReadWriteLock.commandFinished();
                    ReadWriteLock.commandRemoved();
                    throw throwable;
                }
                ReadWriteLock.commandFinished();
                ReadWriteLock.commandRemoved();
            }
        });
    }

    private static List getConfigs() {
        if (myConfigsList != null) {
            return myConfigsList;
        }
        IExtensionPoint extensionPoint = ModelPlugin.getDefault().getDescriptor().getExtensionPoint("provider");
        IExtension[] extensions = extensionPoint.getExtensions();
        myConfigsList = new ArrayList();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configs = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configs.length) {
                if ("provider".equals(configs[j].getName())) {
                    myConfigsList.add(configs[j]);
                }
                ++j;
            }
            ++i;
        }
        return myConfigsList;
    }

    static void setInitialModelCreation(boolean mode) {
        ourInitialModelCreation = mode;
    }

    private static IConfigurationElement getConfig(String name) {
        Iterator configs = EclipsePlatform.getConfigs().iterator();
        while (configs.hasNext()) {
            IConfigurationElement config = (IConfigurationElement)configs.next();
            if (!name.equals(config.getAttributeAsIs(ID_ATTRIBUTE)) && !name.equals(config.getAttributeAsIs(CLASS_ATTRIBUTE))) continue;
            return config;
        }
        return null;
    }

    private static List getMetas(IConfigurationElement provider) {
        if (myMetasMap != null) {
            return (List)myMetasMap.get(provider);
        }
        myMetasMap = new HashMap();
        IExtensionPoint metaExtensionPoint = ModelPlugin.getDefault().getDescriptor().getExtensionPoint("provider_metainfo");
        IExtension[] metas = metaExtensionPoint.getExtensions();
        if (metas == null) {
            return Collections.EMPTY_LIST;
        }
        int i = 0;
        while (i < metas.length) {
            IConfigurationElement[] metaConfigs = metas[i].getConfigurationElements();
            if (metaConfigs != null) {
                int j = 0;
                while (j < metaConfigs.length) {
                    IConfigurationElement config = metaConfigs[j];
                    if ("provider_metainfo".equals(config.getName())) {
                        IConfigurationElement key;
                        String id = config.getAttributeAsIs(ID_ATTRIBUTE);
                        if (id == null || id.trim().length() == 0) {
                            id = config.getAttributeAsIs(CLASS_ATTRIBUTE);
                        }
                        if ((key = EclipsePlatform.getConfig(id)) != null) {
                            if (!myMetasMap.containsKey(key)) {
                                myMetasMap.put(key, new ArrayList());
                            }
                            ((List)myMetasMap.get(key)).add(config);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!myMetasMap.containsKey(provider)) {
            myMetasMap.put(provider, Collections.EMPTY_LIST);
        }
        return (List)myMetasMap.get(provider);
    }

    public Enumeration modelNames() {
        ArrayList<String> names = new ArrayList<String>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects == null) {
            return EmptyEnumeration.getEnumeration();
        }
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project.isOpen()) {
                String projectName = project.getName();
                names.add(projectName);
            }
            ++i;
        }
        return Collections.enumeration(names);
    }
}

