/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup;

import com.sap.bc.proj.jstartup.JStartupNatives;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.StringTokenizer;

public class JStartupPerfTimes {
    static /* synthetic */ Class class$com$sap$bc$proj$jstartup$JStartupPerfTimes;

    public String getMacAddress() throws IOException {
        String string = System.getProperty("os.name");
        try {
            if (string.startsWith("Windows")) {
                return this.windowsParseMacAddress(this.windowsRunIpConfigCommand());
            }
            if (string.startsWith("Linux")) {
                return this.linuxParseMacAddress(this.linuxRunIfConfigCommand());
            }
            if (string.startsWith("HP-UX")) {
                return this.hpuxParseMacAddress(this.hpuxRunIfConfigCommand());
            }
            if (string.startsWith("OS/400")) {
                return "n/a";
            }
            throw new IOException("unknown operating system: " + string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            throw new IOException(parseException.getMessage());
        }
    }

    private String condenseMacAddress(String string) {
        String string2 = "";
        for (int i = 0; i < 6; ++i) {
            string2 = string2 + string.substring(i * 3, i * 3 + 2);
        }
        return string2;
    }

    private String linuxParseMacAddress(String string) throws ParseException {
        Object object;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new ParseException(unknownHostException.getMessage(), 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4;
            boolean bl;
            object = stringTokenizer.nextToken().trim();
            boolean bl2 = bl = ((String)object).indexOf(string2) >= 0;
            if (bl && string3 != null) {
                string3 = this.condenseMacAddress(string3);
                return string3;
            }
            int n = ((String)object).indexOf("HWaddr");
            if (n <= 0 || !this.linuxIsMacAddress(string4 = ((String)object).substring(n + 6).trim())) continue;
            string3 = string4;
        }
        object = new ParseException("cannot read MAC address for " + string2 + " from [" + string + "]", 0);
        ((Throwable)object).printStackTrace();
        throw object;
    }

    private boolean linuxIsMacAddress(String string) {
        return string.length() == 17;
    }

    private String linuxRunIfConfigCommand() throws IOException {
        int n;
        Process process = Runtime.getRuntime().exec("/sbin/ifconfig");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
            stringBuffer.append((char)n);
        }
        String string = stringBuffer.toString();
        ((InputStream)bufferedInputStream).close();
        return string;
    }

    private String hpuxParseMacAddress(String string) throws ParseException {
        Object object;
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            if (string3 != null) {
                return string3;
            }
            int n = ((String)object).indexOf("0x");
            String string4 = ((String)object).substring(n + 2).trim();
            if (!this.hpuxIsMacAddress(string4) || !this.hpuxIsMacAddress(string4)) continue;
            string3 = string4;
        }
        object = new ParseException("cannot read MAC address for " + string2 + " from [" + string + "]", 0);
        ((Throwable)object).printStackTrace();
        throw object;
    }

    private boolean hpuxIsMacAddress(String string) {
        return string.length() == 12;
    }

    private String hpuxRunIfConfigCommand() throws IOException {
        int n;
        Process process = Runtime.getRuntime().exec("lanscan -a");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
            stringBuffer.append((char)n);
        }
        String string = stringBuffer.toString();
        ((InputStream)bufferedInputStream).close();
        return string;
    }

    private String windowsParseMacAddress(String string) throws ParseException {
        Object object;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new ParseException(unknownHostException.getMessage(), 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            if (((String)object).endsWith(string2) && string3 != null) {
                string3 = this.condenseMacAddress(string3);
                return string3;
            }
            int n = ((String)object).indexOf(":");
            if (n <= 0) continue;
            System.out.println("macAddressCandidate: " + (String)object);
            String string4 = ((String)object).substring(n + 1).trim();
            if (!this.windowsIsMacAddress(string4)) continue;
            string3 = string4;
        }
        object = new ParseException("cannot read MAC address from [" + string + "]", 0);
        ((Throwable)object).printStackTrace();
        throw object;
    }

    private boolean windowsIsMacAddress(String string) {
        return string.length() == 17;
    }

    private String windowsRunIpConfigCommand() throws IOException {
        int n;
        Process process = Runtime.getRuntime().exec("ipconfig /all");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
            stringBuffer.append((char)n);
        }
        String string = stringBuffer.toString();
        ((InputStream)bufferedInputStream).close();
        return string;
    }

    public static native long getStampUs();

    public static native long getDeltaUs(long var0);

    public static native long getDelta2Us(long var0, long var2);

    public static native long elapsed();

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].compareTo("-version") == 0) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].compareTo("-time") == 0) {
                bl4 = true;
                continue;
            }
            if (stringArray[i].compareTo("-mac") == 0) {
                bl3 = true;
                continue;
            }
            bl = stringArray[i].compareTo("-all") == 0 ? true : true;
        }
        try {
            JStartupPerfTimes jStartupPerfTimes = new JStartupPerfTimes();
            if (bl4) {
                int n;
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                long l6 = 0L;
                System.out.println();
                System.out.println("Time measurement: Overhead");
                System.out.println();
                l = jStartupPerfTimes.getStampUs();
                l2 = JStartupPerfTimes.getDeltaUs(l);
                System.out.println("getStampUs, getDeltaUs     : " + l2 + "us");
                l = jStartupPerfTimes.getStampUs();
                l2 = JStartupPerfTimes.getDeltaUs(l);
                System.out.println("getStampUs, getDeltaUs     : " + l2 + "us");
                l = jStartupPerfTimes.getStampUs();
                l2 = jStartupPerfTimes.getStampUs();
                l3 = JStartupPerfTimes.getDelta2Us(l, l2);
                System.out.println("getStampUs 2x, getDelta2Us : " + l3 + "us");
                l = jStartupPerfTimes.getStampUs();
                l2 = jStartupPerfTimes.getStampUs();
                l3 = JStartupPerfTimes.getDelta2Us(l, l2);
                System.out.println("getStampUs 2x, getDelta2Us : " + l3 + "us");
                l = jStartupPerfTimes.elapsed();
                l2 = jStartupPerfTimes.elapsed();
                l3 = JStartupPerfTimes.getDelta2Us(l, l2);
                System.out.println("elapsed 2x, getDelta2Us    : " + l3 + "us");
                l = jStartupPerfTimes.elapsed();
                l2 = jStartupPerfTimes.elapsed();
                l3 = JStartupPerfTimes.getDelta2Us(l, l2);
                System.out.println("elapsed 2x, getDelta2Us    : " + l3 + "us");
                l = jStartupPerfTimes.elapsed();
                l3 = System.currentTimeMillis();
                l2 = jStartupPerfTimes.elapsed();
                l3 = JStartupPerfTimes.getDelta2Us(l, l2);
                System.out.println("System.currentTimeMillis() : " + l3 + "us (elapsed())");
                l = jStartupPerfTimes.elapsed();
                l3 = System.currentTimeMillis();
                l2 = jStartupPerfTimes.elapsed();
                l3 = JStartupPerfTimes.getDelta2Us(l, l2);
                System.out.println("System.currentTimeMillis() : " + l3 + "us (elapsed())");
                l = jStartupPerfTimes.getStampUs();
                l3 = System.currentTimeMillis();
                l2 = JStartupPerfTimes.getDeltaUs(l);
                System.out.println("System.currentTimeMillis() : " + l2 + "us (getStampUs())");
                System.out.println("");
                System.out.println("Time accuracy: polling time for 100ms");
                System.out.println("");
                l3 = System.currentTimeMillis() / 100L;
                while ((l4 = System.currentTimeMillis() / 100L) == l3) {
                }
                for (n = 0; n < 3; ++n) {
                    l3 = System.currentTimeMillis() / 100L;
                    while ((l4 = System.currentTimeMillis() / 100L) == l3) {
                    }
                    l = jStartupPerfTimes.getStampUs();
                    while (System.currentTimeMillis() / 100L == l4) {
                    }
                    l2 = JStartupPerfTimes.getDeltaUs(l);
                    l4 = l2 - 100000L;
                    System.out.println("100 milliseconds, getStampUs : " + l2 + "us" + " (" + l4 + "us)");
                }
                for (n = 0; n < 3; ++n) {
                    l3 = System.currentTimeMillis() / 100L;
                    while ((l4 = System.currentTimeMillis() / 100L) == l3) {
                    }
                    l = jStartupPerfTimes.elapsed();
                    while (System.currentTimeMillis() / 100L == l4) {
                    }
                    l2 = jStartupPerfTimes.elapsed();
                    l3 = JStartupPerfTimes.getDelta2Us(l, l2);
                    l4 = l3 - 100000L;
                    System.out.println("100 milliseconds, elapsed    : " + l3 + "us" + " (" + l4 + "us)");
                }
                System.out.println("");
                System.out.println("Time accuracy: sleep(100ms");
                System.out.println("");
                for (n = 0; n < 3; ++n) {
                    l = jStartupPerfTimes.getStampUs();
                    Thread.sleep(100L);
                    l2 = JStartupPerfTimes.getDeltaUs(l);
                    l3 = l2 - 100000L;
                    System.out.println("Thread.sleep(100), getStampUs : " + l2 + "us" + " (" + l3 + "us)");
                }
                for (n = 0; n < 3; ++n) {
                    l = jStartupPerfTimes.elapsed();
                    Thread.sleep(100L);
                    l2 = jStartupPerfTimes.elapsed();
                    l3 = JStartupPerfTimes.getDelta2Us(l, l2);
                    l4 = l3 - 100000L;
                    System.out.println("Thread.sleep(100), elapsed    : " + l3 + "us" + " (" + l4 + "us)");
                }
                System.out.println("");
                l = jStartupPerfTimes.getStampUs();
                l2 = jStartupPerfTimes.elapsed();
                l3 = System.currentTimeMillis() * 1000L;
                System.out.println("Time via perfTimes.getStampUs()     : " + l + "us");
                System.out.println("Time via perfTimes.elapsed()        : " + l2 + "us");
                System.out.println("Time via System.currentTimeMillis() : " + l3 + "us");
            }
            if (bl3 || bl) {
                try {
                    System.out.println();
                    System.out.println("Network infos");
                    System.out.println("  Operating System: " + System.getProperty("os.name"));
                    System.out.println("  IP/Localhost: " + InetAddress.getLocalHost().getHostAddress());
                    System.out.println("  MAC Address: " + jStartupPerfTimes.getMacAddress());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        JStartupNatives.registerNatives(class$com$sap$bc$proj$jstartup$JStartupPerfTimes == null ? (class$com$sap$bc$proj$jstartup$JStartupPerfTimes = JStartupPerfTimes.class$("com.sap.bc.proj.jstartup.JStartupPerfTimes")) : class$com$sap$bc$proj$jstartup$JStartupPerfTimes);
    }
}

