/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup;

import com.sap.bc.proj.jstartup.FCAConnection;
import com.sap.bc.proj.jstartup.FCAException;
import com.sap.bc.proj.jstartup.FCAInputStream;
import com.sap.bc.proj.jstartup.FCAOutputStream;
import com.sap.bc.proj.jstartup.FCAProperties;
import com.sap.bc.proj.jstartup.FCAServer;
import com.sap.bc.proj.jstartup.JStartupNatives;
import com.sap.bc.proj.jstartup.JStartupPerfTimes;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;

public class JStartupFastChannel {
    static boolean isServer;
    static int numberOfThreads;
    static int remoteDbg;
    static int clientsRunning;
    static int serversRunning;
    PrintWriter out;
    int[] bytes = new int[]{1024, 4096, 16384, 65536, 262144, 0x100000, 0x400000, 0x1000000};
    Object[] data;
    static /* synthetic */ Class class$com$sap$bc$proj$jstartup$JStartupFastChannel;

    private static final native int native_fcaInit();

    private static final native int native_fcaCreateServer(String var0);

    private static final native int native_fcaCreateServerConnection(int var0);

    private static final native void native_fcaCloseServerQueue(int var0);

    private static final native int native_fcaCreateClientConnection(String var0);

    private static final native void native_fcaSendMessage(int var0, byte[] var1);

    private static final native byte[] native_fcaReceiveMessage(int var0, boolean var1);

    private static final native byte[] native_fcaPeekBuffer(int var0, int var1, boolean var2);

    private static final native void native_fcaCloseConnection(int var0);

    private static final native int native_fcaGetBufferSize();

    private static final native int native_fcaGetServersOpen();

    private static final native int native_fcaGetConnsOpen();

    public static final int fcaCreateServer(String string) throws FCAException, Error {
        return JStartupFastChannel.native_fcaCreateServer(string);
    }

    public static final int fcaCreateServerConnection(int n) throws FCAException, Error {
        return JStartupFastChannel.native_fcaCreateServerConnection(n);
    }

    public static final void fcaCloseServerQueue(int n) throws FCAException, Error {
        JStartupFastChannel.native_fcaCloseServerQueue(n);
    }

    public static final int fcaCreateClientConnection(String string) throws FCAException, Error {
        return JStartupFastChannel.native_fcaCreateClientConnection(string);
    }

    public static final void fcaSendMessage(int n, byte[] byArray) throws FCAException, Error {
        JStartupFastChannel.native_fcaSendMessage(n, byArray);
    }

    public static final byte[] fcaReceiveMessage(int n, boolean bl) throws FCAException, Error {
        return JStartupFastChannel.native_fcaReceiveMessage(n, bl);
    }

    public static final byte[] fcaPeekBuffer(int n, int n2, boolean bl) throws FCAException, Error {
        return JStartupFastChannel.native_fcaPeekBuffer(n, n2, bl);
    }

    public static final void fcaCloseConnection(int n) throws FCAException, Error {
        JStartupFastChannel.native_fcaCloseConnection(n);
    }

    public static final int fcaGetBufferSize() throws FCAException, Error {
        return JStartupFastChannel.native_fcaGetBufferSize();
    }

    public static final int fcaGetServersOpen() throws FCAException, Error {
        return JStartupFastChannel.native_fcaGetServersOpen();
    }

    public static final int fcaGetConnsOpen() throws FCAException, Error {
        return JStartupFastChannel.native_fcaGetConnsOpen();
    }

    JStartupFastChannel() {
        try {
            this.out = new PrintWriter(new BufferedWriter(new FileWriter("results.txt")));
            this.out.println("Performance Tests using Fast Channel Architecture");
            this.out.println();
            this.out.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void runServer() {
        for (int i = 1; i <= numberOfThreads; ++i) {
            ServerThread serverThread = new ServerThread(i);
            serverThread.start();
            ++serversRunning;
        }
        while (serversRunning > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        System.exit(-1);
    }

    public void runClient() {
        for (int i = 1; i <= numberOfThreads; ++i) {
            ClientThread clientThread = new ClientThread(i);
            clientThread.start();
            ++clientsRunning;
        }
        while (clientsRunning > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        System.exit(0);
    }

    public void initialize() {
        int n;
        this.data = new Object[7];
        int n2 = 0;
        System.out.println("initializing test data ...");
        for (n = 0; n < 7; ++n) {
            this.data[n] = new byte[this.bytes[n]];
        }
        for (n = 0; n < 7; ++n) {
            while (n2 < this.bytes[n]) {
                for (int i = 6; i >= n; --i) {
                    byte[] byArray = (byte[])this.data[i];
                    byArray[n2] = (byte)(n2 % 256);
                }
                ++n2;
            }
            System.out.println(this.bytes[n] + " bytes of data written");
        }
        System.out.println("starting servers");
        new SocketServer().start();
        new FCAServerMessage().start();
        new FCAServerStream().start();
    }

    public void runSockets() {
        System.out.println("starting performance tests with sockets");
        this.out.println("transfering data using Java sockets");
        this.out.println("-----------------------------------");
        try {
            Socket socket = new Socket("localhost", 2312);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            for (int i = 0; i < 7; ++i) {
                System.out.println("sending 100 * " + this.bytes[i] + " bytes");
                byte[] byArray = (byte[])this.data[i];
                long l = this.getTime();
                for (int j = 0; j < 100; ++j) {
                    byte[] byArray2 = new byte[this.bytes[i]];
                    byte[] byArray3 = new byte[this.bytes[i]];
                    int n = 0;
                    outputStream.write(byArray);
                    for (int k = 0; k < this.bytes[i]; k += n) {
                        n = inputStream.read(byArray3, k, this.bytes[i] - k);
                        System.arraycopy(byArray3, 0, byArray2, k, n);
                    }
                }
                long l2 = this.getTime();
                this.out.println("100 Pakete mit jeweils " + this.bytes[i]);
                this.out.println("Gesamtzeit: " + (l2 - l) + "\u00c2\u00b5s");
                this.out.println("Zeit pro Paket: " + (l2 - l) / 100L + "\u00c2\u00b5s");
                this.out.println();
                this.out.flush();
            }
            inputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void runMessages() {
        System.out.println("starting performance tests with FCA messages");
        this.out.println("transfering data using FCA messages");
        this.out.println("-----------------------------------");
        try {
            FCAConnection fCAConnection = new FCAConnection("queueMsg");
            for (int i = 0; i < 7; ++i) {
                System.out.println("sending 100 * " + this.bytes[i] + " bytes");
                byte[] byArray = (byte[])this.data[i];
                long l = this.getTime();
                for (int j = 0; j < 100; ++j) {
                    fCAConnection.sendMessage(byArray);
                    fCAConnection.receiveMessage(true);
                }
                long l2 = this.getTime();
                this.out.println("100 Pakete mit jeweils " + this.bytes[i]);
                this.out.println("Gesamtzeit: " + (l2 - l) + "\u00c2\u00b5s");
                this.out.println("Zeit pro Paket: " + (l2 - l) / 100L + "\u00c2\u00b5s");
                this.out.println();
                this.out.flush();
            }
            fCAConnection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void runStreams() {
        System.out.println("starting performance tests with FCA streams");
        this.out.println("transfering data using FCA streams");
        this.out.println("-----------------------------------");
        try {
            FCAConnection fCAConnection = new FCAConnection("queueStream");
            FCAInputStream fCAInputStream = fCAConnection.getInputStream();
            FCAOutputStream fCAOutputStream = fCAConnection.getOutputStream();
            for (int i = 0; i < 7; ++i) {
                System.out.println("sending 100 * " + this.bytes[i] + " bytes");
                byte[] byArray = (byte[])this.data[i];
                long l = this.getTime();
                for (int j = 0; j < 100; ++j) {
                    byte[] byArray2 = new byte[this.bytes[i]];
                    byte[] byArray3 = new byte[this.bytes[i]];
                    int n = 0;
                    fCAOutputStream.write(byArray);
                    fCAOutputStream.flush();
                    for (int k = 0; k < this.bytes[i]; k += n) {
                        n = fCAInputStream.read(byArray3, k, this.bytes[i] - k);
                        System.arraycopy(byArray3, 0, byArray2, k, n);
                    }
                }
                long l2 = this.getTime();
                this.out.println("100 Pakete mit jeweils " + this.bytes[i]);
                this.out.println("Gesamtzeit: " + (l2 - l) + "\u00c2\u00b5s");
                this.out.println("Zeit pro Paket: " + (l2 - l) / 100L + "\u00c2\u00b5s");
                this.out.println();
                this.out.flush();
            }
            fCAInputStream.close();
            fCAOutputStream.close();
            fCAConnection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void finish() {
        this.out.flush();
        this.out.close();
        System.out.println("test results saved in file results.txt");
        System.exit(0);
    }

    public long getTime() {
        return JStartupPerfTimes.getStampUs();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 1 && stringArray[1].equals("-p")) {
            JStartupFastChannel jStartupFastChannel = new JStartupFastChannel();
            jStartupFastChannel.initialize();
            jStartupFastChannel.runSockets();
            jStartupFastChannel.runMessages();
            jStartupFastChannel.runStreams();
            jStartupFastChannel.finish();
        } else {
            try {
                if (stringArray[0].equals("-c")) {
                    isServer = false;
                } else if (stringArray[0].equals("-s")) {
                    isServer = true;
                } else {
                    throw new Exception();
                }
                for (int i = 1; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("-th")) {
                        numberOfThreads = Integer.parseInt(stringArray[++i]);
                        continue;
                    }
                    if (stringArray[i].equals("-rdbg")) {
                        remoteDbg = Integer.parseInt(stringArray[++i]);
                        continue;
                    }
                    throw new Exception();
                }
                Thread.sleep(1000 * remoteDbg);
                if (isServer) {
                    new JStartupFastChannel().runServer();
                } else {
                    new JStartupFastChannel().runClient();
                }
            }
            catch (Exception exception) {
                System.out.println("parameters: mode [options]");
                System.out.println("");
                System.out.println("mode:   -c          client");
                System.out.println("        -s          server");
                System.out.println("options:");
                System.out.println("        -p          performance");
                System.out.println("        -th num     number of threads");
                System.out.println("        -rdbg secs  waits for <secs> seconds");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        numberOfThreads = 1;
        remoteDbg = 1;
        clientsRunning = 0;
        serversRunning = 0;
        JStartupNatives.registerNatives(class$com$sap$bc$proj$jstartup$JStartupFastChannel == null ? (class$com$sap$bc$proj$jstartup$JStartupFastChannel = JStartupFastChannel.class$("com.sap.bc.proj.jstartup.JStartupFastChannel")) : class$com$sap$bc$proj$jstartup$JStartupFastChannel);
        JStartupFastChannel.native_fcaInit();
    }

    class FCAServerStream
    extends Thread {
        FCAServer server;
        FCAConnection conn;
        FCAInputStream in;
        FCAOutputStream out;
        byte[] buf1;
        byte[] buf2;
        int num;
        int off;

        FCAServerStream() {
            try {
                this.server = new FCAServer("queueStream");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void run() {
            try {
                this.conn = this.server.accept();
                this.in = this.conn.getInputStream();
                this.out = this.conn.getOutputStream();
                for (int i = 0; i < 7; ++i) {
                    for (int j = 0; j < 100; ++j) {
                        this.buf1 = new byte[JStartupFastChannel.this.bytes[i]];
                        this.buf2 = new byte[JStartupFastChannel.this.bytes[i]];
                        this.num = 0;
                        this.off = 0;
                        while (this.off < JStartupFastChannel.this.bytes[i]) {
                            this.num = this.in.read(this.buf2, this.off, JStartupFastChannel.this.bytes[i] - this.off);
                            System.arraycopy(this.buf2, this.off, this.buf1, this.off, this.num);
                            this.off += this.num;
                        }
                        this.out.write(this.buf1);
                        this.out.flush();
                        this.buf1 = null;
                        this.buf2 = null;
                    }
                }
                this.out.close();
                this.in.close();
                this.conn.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class FCAServerMessage
    extends Thread {
        FCAServer server;
        FCAConnection conn;
        byte[] buf;

        FCAServerMessage() {
            try {
                this.server = new FCAServer("queueMsg");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void run() {
            try {
                this.conn = this.server.accept();
                for (int i = 0; i < 7; ++i) {
                    for (int j = 0; j < 100; ++j) {
                        this.buf = this.conn.receiveMessage(true);
                        this.conn.sendMessage(this.buf);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class SocketServer
    extends Thread {
        ServerSocket server;
        Socket socket;
        InputStream in;
        OutputStream out;
        byte[] buf1;
        byte[] buf2;
        int num;
        int off;

        SocketServer() {
            try {
                this.server = new ServerSocket(2312);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void run() {
            try {
                this.socket = this.server.accept();
                this.in = this.socket.getInputStream();
                this.out = this.socket.getOutputStream();
                for (int i = 0; i < 7; ++i) {
                    for (int j = 0; j < 100; ++j) {
                        this.buf1 = new byte[JStartupFastChannel.this.bytes[i]];
                        this.buf2 = new byte[JStartupFastChannel.this.bytes[i]];
                        this.num = 0;
                        this.off = 0;
                        while (this.off < JStartupFastChannel.this.bytes[i]) {
                            this.num = this.in.read(this.buf2, this.off, JStartupFastChannel.this.bytes[i] - this.off);
                            System.arraycopy(this.buf2, this.off, this.buf1, this.off, this.num);
                            this.off += this.num;
                        }
                        this.out.write(this.buf1);
                        this.out.flush();
                        this.buf1 = null;
                        this.buf2 = null;
                    }
                }
                this.out.close();
                this.in.close();
                this.socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    class ServerThread
    extends Thread {
        private int num;
        File tf;
        PrintWriter writer;

        ServerThread(int n) {
            this.num = n;
        }

        public void run() {
            FCAServer fCAServer = null;
            FCAConnection fCAConnection = null;
            try {
                this.tf = new File("fcaserver" + this.num + ".trace");
                this.writer = new PrintWriter(new FileOutputStream(this.tf));
                this.writer.println(new Date().toString());
                this.writer.flush();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            try {
                fCAServer = new FCAServer("FCA_QUEUE_1");
                this.print("waiting for incoming messages");
                while (true) {
                    fCAConnection = fCAServer.accept();
                    byte[] byArray = fCAConnection.receiveMessage(true);
                    this.print("received message - length: " + byArray.length);
                    fCAConnection.sendMessage(byArray);
                    fCAConnection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(this.writer);
                this.writer.flush();
                try {
                    fCAServer.close();
                }
                catch (FCAException fCAException) {
                    fCAException.printStackTrace(this.writer);
                    this.writer.flush();
                    --serversRunning;
                }
                this.writer.flush();
                this.writer.close();
                --serversRunning;
                return;
            }
        }

        private void print(String string) {
            System.out.println("Thread " + this.num + ": " + string);
            this.writer.println("Thread " + this.num + ": " + string);
            this.writer.flush();
        }
    }

    class ClientThread
    extends Thread {
        private int num;
        File tf;
        PrintWriter writer;

        ClientThread(int n) {
            this.num = n;
        }

        public void run() {
            try {
                this.tf = new File("fcaconn" + this.num + ".trace");
                this.writer = new PrintWriter(new FileOutputStream(this.tf));
                this.writer.println(new Date().toString());
                this.writer.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                long l;
                byte[] byArray;
                long l2;
                FCAConnection fCAConnection;
                int n;
                byte[] byArray2 = this.getBuffer(1024);
                for (n = 1; n <= 1000; ++n) {
                    fCAConnection = new FCAConnection("FCA_QUEUE_1");
                    l2 = new Date().getTime();
                    fCAConnection.sendMessage(byArray2);
                    byArray = fCAConnection.receiveMessage(true);
                    l = new Date().getTime();
                    if (this.compareByteArray(byArray, byArray2)) {
                        this.print("  1KB " + n + " - ok  ping-pong time " + (l - l2));
                    } else {
                        this.print("  1KB " + n + " - error  ping-pong time " + (l - l2));
                    }
                    this.writer.flush();
                    fCAConnection.close();
                }
                this.print("conns open: " + FCAProperties.getConnsOpen());
                byArray2 = this.getBuffer(102400);
                for (n = 1; n <= 20; ++n) {
                    fCAConnection = new FCAConnection("FCA_QUEUE_1");
                    l2 = new Date().getTime();
                    fCAConnection.sendMessage(byArray2);
                    byArray = fCAConnection.receiveMessage(true);
                    l = new Date().getTime();
                    if (this.compareByteArray(byArray, byArray2)) {
                        this.print("100KB " + n + " - ok  ping-pong time " + (l - l2));
                    } else {
                        this.print("100KB " + n + " - error  ping-pong time " + (l - l2));
                    }
                    this.writer.flush();
                    fCAConnection.close();
                }
                this.print("conns open: " + FCAProperties.getConnsOpen());
                byArray2 = this.getBuffer(0x500000);
                for (n = 1; n <= 5; ++n) {
                    fCAConnection = new FCAConnection("FCA_QUEUE_1");
                    l2 = new Date().getTime();
                    fCAConnection.sendMessage(byArray2);
                    byArray = fCAConnection.receiveMessage(true);
                    l = new Date().getTime();
                    if (this.compareByteArray(byArray, byArray2)) {
                        this.print("  5MB " + n + " - ok  ping-pong time " + (l - l2));
                    } else {
                        this.print("  5MB " + n + " - error  ping-pong time " + (l - l2));
                    }
                    fCAConnection.close();
                    this.writer.flush();
                }
                this.print("conns open: " + FCAProperties.getConnsOpen());
            }
            catch (Exception exception) {
                exception.printStackTrace(this.writer);
                this.writer.flush();
                --clientsRunning;
            }
            this.writer.close();
            --clientsRunning;
        }

        private void print(String string) {
            System.out.println("Thread " + this.num + ": " + string);
            this.writer.println("Thread " + this.num + ": " + string);
        }

        private byte[] getBuffer(int n) {
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = new Integer(i % 256).byteValue();
            }
            return byArray;
        }

        private boolean compareByteArray(byte[] byArray, byte[] byArray2) {
            if (byArray.length != byArray2.length) {
                return false;
            }
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
            return true;
        }
    }
}

