/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup;

import com.sap.bc.proj.jstartup.FCAConnection;
import com.sap.bc.proj.jstartup.FCAException;
import java.io.IOException;
import java.io.OutputStream;

public class FCAOutputStream
extends OutputStream {
    private FCAConnection conn;
    private byte[] buf;
    private int pos;
    private static final int bufferSize = 16384;

    public FCAOutputStream(FCAConnection fCAConnection) {
        this.conn = fCAConnection;
        this.pos = 0;
        this.buf = new byte[16384];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) throws IOException {
        byte[] byArray = this.buf;
        synchronized (this.buf) {
            this.buf[this.pos] = (byte)n;
            ++this.pos;
            if (this.pos >= 16384) {
                this.flush();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        byte[] byArray = this.buf;
        synchronized (this.buf) {
            try {
                this.conn.sendMessage(this.buf, 0, this.pos);
                this.pos = 0;
            }
            catch (FCAException fCAException) {
                throw new IOException(fCAException.getMessage());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        byte[] byArray2 = this.buf;
        synchronized (this.buf) {
            try {
                if (n2 > 16384 - this.pos) {
                    this.flush();
                    this.conn.sendMessage(byArray, n, n2);
                } else {
                    System.arraycopy(byArray, n, this.buf, this.pos, n2);
                    this.pos += n2;
                }
            }
            catch (FCAException fCAException) {
                throw new IOException(fCAException.getMessage());
            }
            return;
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }
}

