/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.proj.jstartup;

import com.sap.bc.proj.jstartup.FCAException;
import com.sap.bc.proj.jstartup.FCAInputStream;
import com.sap.bc.proj.jstartup.FCAOutputStream;
import com.sap.bc.proj.jstartup.JStartupFastChannel;

public class FCAConnection {
    private int key;

    public FCAConnection(String string) throws FCAException {
        try {
            this.key = JStartupFastChannel.fcaCreateClientConnection(string);
        }
        catch (Error error) {
            throw new FCAException("Fast Channel Architecture not initialized correctly", error);
        }
    }

    public FCAConnection(int n) throws FCAException {
        try {
            this.key = JStartupFastChannel.fcaCreateServerConnection(n);
        }
        catch (Error error) {
            throw new FCAException("Fast Channel Architecture not initialized correctly", error);
        }
    }

    public void sendMessage(byte[] byArray) throws FCAException {
        try {
            JStartupFastChannel.fcaSendMessage(this.key, byArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new FCAException("Internal FCA error", arrayIndexOutOfBoundsException);
        }
        catch (Error error) {
            throw new FCAException("Fast Channel Architecture not initialized correctly", error);
        }
    }

    public void sendMessage(byte[] byArray, int n, int n2) throws FCAException {
        try {
            if (n + n2 > byArray.length || n < 0) {
                throw new FCAException("array index out of bounds");
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            JStartupFastChannel.fcaSendMessage(this.key, byArray2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new FCAException("Internal FCA error", arrayIndexOutOfBoundsException);
        }
        catch (Error error) {
            throw new FCAException("Fast Channel Architecture not initialized correctly", error);
        }
    }

    public byte[] receiveMessage(boolean bl) throws FCAException {
        byte[] byArray;
        try {
            byArray = JStartupFastChannel.fcaReceiveMessage(this.key, bl);
        }
        catch (Error error) {
            throw new FCAException("Fast Channel Architecture not initialized correctly", error);
        }
        return byArray;
    }

    public FCAInputStream getInputStream() throws FCAException {
        FCAInputStream fCAInputStream;
        try {
            fCAInputStream = new FCAInputStream(this);
        }
        catch (Error error) {
            throw new FCAException("Fast Channel Architecture not initialized correctly", error);
        }
        return fCAInputStream;
    }

    public FCAOutputStream getOutputStream() throws FCAException {
        FCAOutputStream fCAOutputStream;
        try {
            fCAOutputStream = new FCAOutputStream(this);
        }
        catch (Error error) {
            throw new FCAException("Fast Channel Architecture not initialized correctly", error);
        }
        return fCAOutputStream;
    }

    public byte[] peek(int n, boolean bl) throws FCAException {
        byte[] byArray;
        try {
            byArray = JStartupFastChannel.fcaPeekBuffer(this.key, n, bl);
        }
        catch (Error error) {
            throw new FCAException("Fast Channel Architecture not initialized correctly", error);
        }
        return byArray;
    }

    public void close() throws FCAException {
        try {
            JStartupFastChannel.fcaCloseConnection(this.key);
        }
        catch (Error error) {
            throw new FCAException("Fast Channel Architecture not initialized correctly", error);
        }
    }
}

