/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IMessage;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;

public class TestStandardChanges
extends Test {
    IServiceFacade sf;
    IServiceModule serviceModule;
    IAspect sourceAspect;
    IAspect aspectToChange;
    private int initialNoOfRows;
    private IKeyList flightKeyList;
    private IKey testKey = null;

    public void prepare() {
        this.sf = TestUtils.prepare(this);
        this.serviceModule = this.sf.getServiceModule("CL_SCOOL_SFLIGHT");
        this.testKey = TestUtils.getFlightTestKey(this.sf, this.serviceModule);
        this.flightKeyList = this.serviceModule.createKeyList("SCOL_FLIGHTS_KEY");
        this.flightKeyList.add(this.testKey);
        this.sourceAspect = this.serviceModule.getAspect("SCOL_FLIGHTS_KEY", this.flightKeyList);
        if (this.sourceAspect != null) {
            this.aspectToChange = this.sourceAspect.getRelatedAspect("BOOKINGS");
            this.initialNoOfRows = this.aspectToChange.size();
        }
    }

    public void cleanUp() {
        this.sf.closeConnection();
    }

    public static void adjustTestAttributes(IJverTestAttributes attributes) {
        attributes.setTestSet(new String[]{"testPreconditions", "testSimpleUpdate", "testSimpleInsert", "testInsertRelation", "testSimpleDelete", "testInsertEmptyAspect", "testFailedInsert", "testUpdateWithErrors1", "testUpdateWithErrors2", "testInsertDelete"});
        TestUtils.adjustTestAttributes(attributes);
    }

    public void testPreconditions() {
        this.verify(this.testKey != null, "No test Key found for tests");
        this.verify(this.serviceModule != null, "ServiceModule creation failed");
        this.verify(this.sourceAspect != null, "Source Aspect for Relation is null");
        this.verify(this.aspectToChange != null, "Aspect to change is null");
        this.verify(this.initialNoOfRows > 0, "Aspect to change has no AspectRows");
    }

    public void testSimpleUpdate() {
        IAspectRow rowToChange = this.aspectToChange.getAspectRow(this.initialNoOfRows - 1);
        String[] changedFields = new String[2];
        IKey keyOfRowToChange = this.changeAspectRow(rowToChange, changedFields);
        String changedSmoker = changedFields[0];
        String changedAgencyNum = changedFields[1];
        this.verify(rowToChange.getAttributeAsString("SMOKER").equals(changedSmoker), "Changed field SMOKER is '" + rowToChange.getAttributeAsString("SMOKER") + "' expected: " + changedSmoker);
        this.verify(rowToChange.getAttributeAsString("AGENCYNUM").equals(changedAgencyNum), "Changed field AGENCYNUM is '" + rowToChange.getAttributeAsString("AGENCYNUM") + "' expected: " + changedAgencyNum);
        this.aspectToChange.sendChanges();
        rowToChange = this.aspectToChange.getAspectRow(keyOfRowToChange);
        this.verify(rowToChange.getAttributeAsString("SMOKER").equals(changedSmoker), "Changed field SMOKER is '" + rowToChange.getAttributeAsString("SMOKER") + "' expected: " + changedSmoker);
        this.verify(rowToChange.getAttributeAsString("AGENCYNUM").equals(changedAgencyNum), "Changed field AGENCYNUM is '" + rowToChange.getAttributeAsString("AGENCYNUM") + "' expected: " + changedAgencyNum);
        this.sf.save();
        rowToChange = this.aspectToChange.getAspectRow(keyOfRowToChange, LockStrategy.EXCLUSIVE);
        this.verify(rowToChange.getAttributeAsString("SMOKER").equals(changedSmoker), "Changed field SMOKER is '" + rowToChange.getAttributeAsString("SMOKER") + "' expected: " + changedSmoker);
        this.verify(rowToChange.getAttributeAsString("AGENCYNUM").equals(changedAgencyNum), "Changed field AGENCYNUM is '" + rowToChange.getAttributeAsString("AGENCYNUM") + "' expected: " + changedAgencyNum);
    }

    public void testSimpleInsert() {
        IAspectRow rowToInsert = this.aspectToChange.createAspectRow();
        IKey keyToInsert = rowToInsert.getKey();
        rowToInsert.setAttributeValue("CARRID", this.sourceAspect.getAspectRow(0).getAttributeValue("CARRID"));
        rowToInsert.setAttributeValue("CONNID", this.sourceAspect.getAspectRow(0).getAttributeValue("CONNID"));
        rowToInsert.setAttributeValue("FLDATE", this.sourceAspect.getAspectRow(0).getAttributeValue("FLDATE"));
        rowToInsert.setAttributeValue("AGENCYNUM", (Object)"0");
        rowToInsert.setAttributeValue("CUSTOMID", (Object)"00000003");
        rowToInsert.setAttributeValue("COUNTER", (Object)"3");
        this.verify(this.aspectToChange.size() == this.initialNoOfRows + 1, "Size of changed Aspect is not correct size:" + this.aspectToChange.size() + " expected:" + (this.initialNoOfRows + 1));
        this.verify(keyToInsert.isLocalKey(), "Key of inserted Row is no local Key:" + keyToInsert);
        this.aspectToChange.sendChanges();
        this.verify(this.aspectToChange.size() == this.initialNoOfRows + 1, "Size of changed Aspect is not correct size:" + this.aspectToChange.size() + " expected:" + (this.initialNoOfRows + 1));
        TestUtils.dumpMessageList("Messages after Insert:", this.sf.getAllMessages());
        this.verify(!keyToInsert.isLocalKey(), "Key of inserted Row after rounddrip is no complete Key:" + keyToInsert);
        this.sf.save();
        String bookId = (String)rowToInsert.getAttributeValue("SCOL_BOOKID");
        IAspectRow insertedRow = this.aspectToChange.getAspectRow(keyToInsert);
        this.verify(rowToInsert == insertedRow, "Inconsistence between Key and inserted Row " + keyToInsert);
        this.verify(!bookId.equals("00000000"), "Key Field BookId of inserted Row is not created new BOOKID:" + bookId);
        IAspect flight = this.serviceModule.getAspect("SCOL_FLIGHTS_KEY", this.flightKeyList);
        IAspect aspectWithInsert = flight.getRelatedAspect("BOOKINGS");
        this.verify(aspectWithInsert.size() == this.initialNoOfRows + 1, "Size of changed Aspect after insert is not correct size:" + aspectWithInsert.size() + " expected:" + (this.initialNoOfRows + 1));
    }

    public void testInsertRelation() {
        IMessageList messages;
        this.sf.getAllMessages().clear();
        IKey planeKey = this.serviceModule.createKey("SCOL_PLANETYPE_KEY", new String[]{"DC-10-10"});
        IKeyList planeKeyList = this.serviceModule.createKeyList("SCOL_PLANETYPE_KEY");
        planeKeyList.add(planeKey);
        IAspect planes = this.serviceModule.getAspect("SCOL_PLANETYPE_TECH", planeKeyList);
        this.verify(planes.size() > 0, "number of planes must be > 0 to do the test");
        IAspectRow flightPlane = planes.getAspectRow(0);
        this.verify(flightPlane.isValid(), " flight plane in not valid!");
        IAspect addOns = flightPlane.getRelatedAspect("SCOL_PLANETYPE_TECH_ADDON");
        if (addOns.size() > 0) {
            addOns.remove(0);
            this.sf.flush();
            this.sf.save();
        }
        this.verify(!TestUtils.isErrorMessages(messages = this.sf.getAllMessages()), "there are errors in remove");
        IAspectRow planAddon = addOns.createAspectRow(null);
        planAddon.setAttributeValue("PLANETYPE", flightPlane.getAttributeValue("PLANETYPE"));
        planAddon.setAttributeValue("COLOR", (Object)"RED");
        planAddon.setAttributeValue("NICKNAME", (Object)"XXX");
        planAddon.setAttributeValue("MACH2", (Object)Boolean.TRUE);
        planAddon.setAttributeValue("HIGHSPEED", (Object)new Integer(1111));
        this.sf.flush();
        messages = addOns.getMessages();
        this.verify(!TestUtils.isErrorMessages(messages), "there are errors in insert with relation");
        IAspectRow flightPlaneAddon = flightPlane.getRelatedAspectRow("SCOL_PLANETYPE_TECH_ADDON");
        this.sf.save();
    }

    public void testSimpleDelete() {
        this.verify(this.initialNoOfRows > 3, "Number '" + this.initialNoOfRows + "' of AspectRows to delete is to low to do this test");
        IKey deletedKey1 = this.aspectToChange.getAspectRow(0).getKey();
        IAspectRow rowToDelete1 = this.aspectToChange.getAspectRow(0);
        this.aspectToChange.removeAspectRow(rowToDelete1);
        IKey deletedKey2 = this.aspectToChange.getAspectRow(2).getKey();
        this.aspectToChange.remove(2);
        IKey deletedKey3 = this.aspectToChange.getAspectRow(this.initialNoOfRows - 3).getKey();
        this.aspectToChange.remove(this.initialNoOfRows - 3);
        this.verify(this.aspectToChange.size() == this.initialNoOfRows - 3, "Size of changed Aspect is not correct size:" + this.aspectToChange.size() + " expected:" + (this.initialNoOfRows - 3));
        this.verify(this.aspectToChange.getAspectRow(deletedKey1) == null, "Expected deleted Row exists Key: " + deletedKey1);
        this.verify(this.aspectToChange.getAspectRow(deletedKey2) == null, "Expected deleted Row exists Key: " + deletedKey2);
        this.verify(this.aspectToChange.getAspectRow(deletedKey3) == null, "Expected deleted Row exists Key: " + deletedKey3);
        this.sf.flush();
        this.verify(this.aspectToChange.size() == this.initialNoOfRows - 3, "Size of changed Aspect is not correct size:" + this.aspectToChange.size() + " expected:" + (this.initialNoOfRows - 3));
        this.verify(this.aspectToChange.getAspectRow(deletedKey1) == null, "Expected deleted Row exists Key: " + deletedKey1);
        this.verify(this.aspectToChange.getAspectRow(deletedKey2) == null, "Expected deleted Row exists Key: " + deletedKey2);
        this.verify(this.aspectToChange.getAspectRow(deletedKey3) == null, "Expected deleted Row exists Key: " + deletedKey3);
        this.sf.save();
    }

    public void testInsertEmptyAspect() {
        String maxBookid = "00000000";
        Object carrId = null;
        Object connId = null;
        Object flDate = null;
        int i = 0;
        while (i < this.aspectToChange.size()) {
            String bookid;
            if (i == 0) {
                carrId = this.aspectToChange.getAspectRow(i).getAttributeValue("CARRID");
                connId = this.aspectToChange.getAspectRow(i).getAttributeValue("CONNID");
                flDate = this.aspectToChange.getAspectRow(i).getAttributeValue("FLDATE");
            }
            if ((bookid = this.aspectToChange.getAspectRow(i).getAttributeAsString("SCOL_BOOKID")).compareTo(maxBookid) > 0) {
                maxBookid = bookid;
            }
            ++i;
        }
        int maxBookidAsInt = Integer.parseInt(maxBookid) + 1;
        IAspect emptyAspect = this.serviceModule.createAspect("SCOL_FLIGHT_BOOKING_LIST");
        IAspectRow newRow = emptyAspect.createAspectRow();
        newRow.setAttributeValue("CARRID", carrId);
        newRow.setAttributeValue("CONNID", connId);
        newRow.setAttributeValue("FLDATE", flDate);
        newRow.setAttributeValue("SCOL_BOOKID", (Object)("" + maxBookidAsInt++));
        newRow.setAttributeValue("AGENCYNUM", (Object)"0");
        newRow.setAttributeValue("SMOKER", (Object)"X");
        newRow.setAttributeValue("CUSTOMID", (Object)"00000003");
        newRow.setAttributeValue("COUNTER", (Object)"3");
        IKey key1 = newRow.getKey();
        newRow = emptyAspect.createAspectRow();
        newRow.setAttributeValue("CARRID", carrId);
        newRow.setAttributeValue("CONNID", connId);
        newRow.setAttributeValue("FLDATE", flDate);
        newRow.setAttributeValue("SCOL_BOOKID", (Object)"00000000");
        newRow.setAttributeValue("AGENCYNUM", (Object)"0");
        newRow.setAttributeValue("CUSTOMID", (Object)"00000003");
        newRow.setAttributeValue("COUNTER", (Object)"3");
        IKey key2 = newRow.getKey();
        this.sf.flush();
        IMessageList messages = emptyAspect.getMessages();
        this.verify(!TestUtils.isErrorMessages(messages), "Error Messages exist during insert: " + messages);
        this.sf.save();
        this.verify(emptyAspect.size() == 2, "Aspect has size " + emptyAspect.size() + " expected 2");
        this.verify(!key1.isLocalKey(), "Key of first inserted Row after rounddrip is no complete Key:" + key1);
        this.verify(!key2.isLocalKey(), "Key of first inserted Row after rounddrip is no complete Key:" + key2);
        IAspectRow row1 = emptyAspect.getAspectRow(0);
        int bookid = Integer.parseInt(row1.getAttributeAsString("BOOKID"));
    }

    public void testFailedInsert() {
        IAspect emptyAspect = this.serviceModule.createAspect("SCOL_FLIGHT_BOOKING_LIST");
        IAspectRow baseRow = this.aspectToChange.getAspectRow(0);
        IAspectRow newRow = emptyAspect.createAspectRow();
        newRow.setAttributeValue("CARRID", baseRow.getAttributeValue("CARRID"));
        newRow.setAttributeValue("CONNID", baseRow.getAttributeValue("CONNID"));
        newRow.setAttributeValue("FLDATE", baseRow.getAttributeValue("FLDATE"));
        newRow.setAttributeValue("AGENCYNUM", (Object)"0");
        newRow.setAttributeValue("CUSTOMID", (Object)"0000????");
        newRow.setAttributeValue("COUNTER", (Object)"3");
        this.sf.flush();
        IMessageList messages = emptyAspect.getMessages();
        int noOfFailedMessages = TestUtils.noOfFailedMessages(messages);
        this.verify(noOfFailedMessages >= 1, "number of messages should be 1 but is:" + noOfFailedMessages);
        IMessage message = messages.getMessage(0);
        this.verify(message.isError(), "Message is no ERROR message!");
        this.verify(message.isAspectRowMessage(), "Message doesn't originate to a specific ServiceManger call");
        messages.clear();
        this.sf.flush();
        messages = emptyAspect.getMessages();
        noOfFailedMessages = TestUtils.noOfFailedMessages(messages);
        this.verify(noOfFailedMessages >= 1, "number of messages should be 1 but is:" + noOfFailedMessages);
        messages.clear();
        newRow.setAttributeValue("CUSTOMID", (Object)"00000003");
        this.sf.flush();
        messages = emptyAspect.getMessages();
        noOfFailedMessages = TestUtils.noOfFailedMessages(messages);
        this.verify(noOfFailedMessages == 0, "number of messages should be 0 but is:" + noOfFailedMessages);
        emptyAspect.removeAspectRow(newRow);
        this.sf.flush();
    }

    public void testUpdateWithErrors1() {
        this.verify(this.initialNoOfRows > 4, "Number '" + this.initialNoOfRows + "' of AspectRows to change is to low to do this complex test");
        String[] changedFields1 = new String[2];
        IKey key1 = this.changeAspectRow(this.aspectToChange.getAspectRow(1), changedFields1);
        String[] changedFields = new String[2];
        IKey key2 = this.changeAspectRow(this.aspectToChange.getAspectRow(2), changedFields);
        IKey key0 = this.changeAspectRowWithError(this.aspectToChange.getAspectRow(0));
        IKey keyLast = this.changeAspectRowWithError(this.aspectToChange.getAspectRow(this.initialNoOfRows - 1));
        this.aspectToChange.getAspectRow(this.initialNoOfRows - 1).setAttributeValue("CARRID", (Object)"??");
        this.aspectToChange.sendChanges();
        this.verify(this.aspectToChange.size() == this.initialNoOfRows, "Size of changed Aspect has changed new size:" + this.aspectToChange.size() + " original:" + this.initialNoOfRows);
        IMessageList rowMessages = this.aspectToChange.getAspectRow(key2).getMessages();
        IMessageList messages = this.aspectToChange.getMessages();
        this.verify(messages.size() >= 2, "At least two error messages expected, but there are only:" + messages.size());
        IAspectRow rowToCheck = this.aspectToChange.getAspectRow(key2);
        this.verify(rowToCheck.getAttributeAsString("SMOKER").equals(changedFields[0]), "Changed field SMOKER is '" + rowToCheck.getAttributeAsString("SMOKER") + "' expected: " + changedFields[0]);
        this.verify(rowToCheck.getAttributeAsString("AGENCYNUM").equals(changedFields[1]), "Changed field AGENCYNUM is '" + rowToCheck.getAttributeAsString("AGENCYNUM") + "' expected: " + changedFields[1]);
        IAspect changedAspect = this.sourceAspect.getRelatedAspect("BOOKINGS");
        this.verify(changedAspect.size() == this.initialNoOfRows, "Size of changed Aspect has changed new size:" + this.aspectToChange.size() + " original:" + this.initialNoOfRows);
        rowToCheck = changedAspect.getAspectRow(key1);
        this.verify(rowToCheck.getAttributeAsString("SMOKER").equals(changedFields1[0]), "Changed field SMOKER is '" + rowToCheck.getAttributeAsString("SMOKER") + "' expected: " + changedFields1[0]);
        this.verify(rowToCheck.getAttributeAsString("AGENCYNUM").equals(changedFields1[1]), "Changed field AGENCYNUM is '" + rowToCheck.getAttributeAsString("AGENCYNUM") + "' expected: " + changedFields1[1]);
    }

    public void testUpdateWithErrors2() {
        this.verify(this.initialNoOfRows > 4, "Number '" + this.initialNoOfRows + "' of AspectRows to change is to low to do this complex test");
        this.aspectToChange.setInvalidationHint("UPDATE", 1);
        String[] changedFields1 = new String[2];
        IKey key1 = this.changeAspectRow(this.aspectToChange.getAspectRow(1), changedFields1);
        String[] changedFields = new String[2];
        IKey key2 = this.changeAspectRow(this.aspectToChange.getAspectRow(2), changedFields);
        IKey key0 = this.changeAspectRowWithError(this.aspectToChange.getAspectRow(0));
        IKey keyLast = this.changeAspectRowWithError(this.aspectToChange.getAspectRow(this.initialNoOfRows - 1));
        this.sf.flush();
        IMessageList messages = this.aspectToChange.getMessages();
        int noOfFailedMessages = TestUtils.noOfFailedMessages(messages);
        this.verify(noOfFailedMessages == 2, "Two error messages expected, but there are:" + noOfFailedMessages);
        messages.clear();
        this.sf.flush();
        messages = this.aspectToChange.getMessages();
        noOfFailedMessages = TestUtils.noOfFailedMessages(messages);
        this.verify(noOfFailedMessages == 2, "Two error messages expected, but there are:" + noOfFailedMessages);
        messages.clear();
        this.aspectToChange.getAspectRow(key0).setAttributeValue("CARRID", this.sourceAspect.getAspectRow(0).getAttributeValue("CARRID"));
        this.aspectToChange.getAspectRow(keyLast).setAttributeValue("CARRID", this.sourceAspect.getAspectRow(0).getAttributeValue("CARRID"));
        this.sf.flush();
        messages = this.aspectToChange.getMessages();
        noOfFailedMessages = TestUtils.noOfFailedMessages(messages);
        this.verify(noOfFailedMessages == 0, "After correction no failed messages should exist but are:" + noOfFailedMessages);
        messages.clear();
    }

    public void testInsertDelete() {
        IAspectRow row = this.aspectToChange.createAspectRow();
        row.setAttributeValue(0, (Object)"XX");
        this.verify(this.aspectToChange.removeAspectRow(row), "AspectRow is not correctly removed");
        this.verify(!this.sf.isDirty(), "insert --> delete doesn't lead to nop!");
    }

    private IKey changeAspectRowWithError(IAspectRow rowToChange) {
        IKey keyOfRowToChange = rowToChange.getKey();
        rowToChange.setAttributeValue("CARRID", (Object)"XX");
        return keyOfRowToChange;
    }

    private IKey changeAspectRow(IAspectRow rowToChange, String[] changedFields) {
        IKey keyOfRowToChange = rowToChange.getKey();
        if (rowToChange.getAttributeAsString("SMOKER").equals("X")) {
            changedFields[0] = "";
            rowToChange.setAttributeValue("SMOKER", (Object)"");
        } else {
            changedFields[0] = "X";
            rowToChange.setAttributeValue("SMOKER", (Object)"X");
        }
        if (rowToChange.getAttributeAsString("AGENCYNUM").equals("123")) {
            changedFields[1] = "00000321";
            rowToChange.setAttributeValue("AGENCYNUM", (Object)"00000321");
        } else {
            changedFields[1] = "00000123";
            rowToChange.setAttributeValue("AGENCYNUM", (Object)"00000123");
        }
        return keyOfRowToChange;
    }
}

