/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.generic.api.SortingCriteria;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;
import java.util.HashMap;
import java.util.Iterator;

public class TestRelations
extends Test {
    IServiceFacade sf;
    IServiceModule refServiceModule;
    IAspect refScolDetail;
    IAspect refListKey;
    private int noOfQueryResults;

    public void prepare() {
        this.sf = TestUtils.prepare(this);
        this.refServiceModule = this.sf.getServiceModule("COL_REF_IMPLEMENTATION");
        IQuery refQuery = this.refServiceModule.createQuery("REF_QUERY_1");
        IStructure parms = refQuery.getInputParameterStructure();
        parms.setAttributeValue("DATA3", (Object)"*13");
        refQuery.execute();
        this.refScolDetail = refQuery.getResultAspect();
        this.refListKey = this.refScolDetail.getKeyAspect();
        this.noOfQueryResults = this.refListKey.size();
    }

    public void cleanUp() {
        this.sf.closeConnection();
    }

    public static void adjustTestAttributes(IJverTestAttributes attributes) {
        TestUtils.adjustTestAttributes(attributes);
    }

    public void testPreconditions() {
        this.verify(this.refServiceModule != null, "ServiceModule creation failed");
        this.verify(this.noOfQueryResults == 10, "Number of query result records should be 10 but is:" + this.noOfQueryResults);
    }

    public void testAspectRelatedAspect() {
        IAspect scolRefRelationDetail = this.refListKey.getRelatedAspect("REF_RELATION_1", (LockStrategy)null, null);
        this.verify(scolRefRelationDetail.size() == this.noOfQueryResults * 10, "Number of related Aspect Rows: " + scolRefRelationDetail.size() + " expected: " + this.noOfQueryResults * 10);
        IAspect cachedAspect = this.refListKey.getRelatedAspect("REF_RELATION_1");
        this.verify(scolRefRelationDetail == cachedAspect, "Cache is not used, when relation is executed a second time");
        cachedAspect = this.refListKey.getRelatedAspect("REF_RELATION_1", LockStrategy.SHARED_WITH_EXCLUSIVE_LOCK_ON_UPDATE);
        this.verify(scolRefRelationDetail == cachedAspect, "there is no reference stability , when relation is executed a second time with LockMode");
        this.sf.cleanup();
    }

    public void testAspectRelatedAspectSorting() {
        SortingCriteria sortingCriteria = new SortingCriteria();
        sortingCriteria.addCriterion("REF_DATA3", false);
        sortingCriteria.addCriterion("REF_DATA4");
        this.verify(sortingCriteria.size() == 2, "size of SortingCriteria should be 2 but is: " + sortingCriteria.size());
        this.verify(sortingCriteria.getDirection(1), "Sorting Order should be ascending but is descending!");
        this.verify(!sortingCriteria.getDirection(0), "Sorting Order should be descending but is ascending!");
        this.verify(sortingCriteria.getFieldName(0).equals("REF_DATA3"), "Sorting Field should be DATA3 but is: " + sortingCriteria.getFieldName(0));
        this.verify(sortingCriteria.getFieldName(1).equals("REF_DATA4"), "Sorting Field should be DATA4 but is: " + sortingCriteria.getFieldName(1));
        IAspect scolRefRelationDetail = this.refListKey.getRelatedAspect("REF_RELATION_1", (LockStrategy)null, sortingCriteria);
        this.verify(scolRefRelationDetail.size() == this.noOfQueryResults * 10, "Number of related Aspect Rows: " + scolRefRelationDetail.size() + " expected: " + this.noOfQueryResults * 10);
    }

    public void testAspectRelatedAspectWithTarget() {
        IAspect scolRefRelationDetail = this.refScolDetail.getRelatedAspect("REF_RELATION_1", "SCOL_REF_RELATION_DETAIL", (LockStrategy)null);
        this.verify(scolRefRelationDetail.size() == this.noOfQueryResults * 10, "Number of related Aspect Rows: " + scolRefRelationDetail.size() + " expected: " + this.noOfQueryResults * 10);
        this.verify("SCOL_REF_RELATION_DETAIL".equals(scolRefRelationDetail.getDescriptor().getName()), "Name of target Aspect '" + scolRefRelationDetail.getDescriptor().getName() + "' expected: " + "SCOL_REF_RELATION_DETAIL");
        IAspect detailsInCache = this.refScolDetail.getRelatedAspect("REF_RELATION_1", "SCOL_REF_RELATION_DETAIL", (LockStrategy)null);
        this.verify(scolRefRelationDetail == detailsInCache, "scolRefRelationDetail are not correctly cached");
        IAspect keysOfResult = this.refScolDetail.getKeyAspect();
        this.verify(keysOfResult.size() == this.refScolDetail.size(), "Number of Keys of Query result(" + keysOfResult.size() + ") doesn't correspond to number of result records!" + this.refScolDetail.size());
        IAspect relationsDetail = keysOfResult.getRelatedAspect("REF_RELATION_1");
        this.verify(scolRefRelationDetail == relationsDetail, "Relation details are not correctly cached");
        this.sf.cleanup();
    }

    public void testAspectRowRelatedAspectWithTarget() {
        IKey key = this.refScolDetail.getAspectRow(5).getKey();
        IAspect relationDetails = this.refScolDetail.getAspectRow(key).getRelatedAspect("REF_RELATION_1", "SCOL_REF_RELATION_DETAIL");
        this.verify(relationDetails.size() == 10, "Number of related Aspect Rows: " + relationDetails.size() + " expected: 10");
        this.verify("SCOL_REF_RELATION_DETAIL".equals(relationDetails.getDescriptor().getName()), "Name of target Aspect '" + relationDetails.getDescriptor().getName() + "' expected: " + "SCOL_REF_RELATION_DETAIL");
        IAspect detailsInCache = this.refScolDetail.getAspectRow(key).getRelatedAspect("REF_RELATION_1", "SCOL_REF_RELATION_DETAIL", (LockStrategy)null);
        this.verify(relationDetails == detailsInCache, "Relation details are not correctly cached");
        IAspect keysOfResult = this.refScolDetail.getKeyAspect();
        this.verify(keysOfResult.size() == this.refScolDetail.size(), "Number of Keys of Query result(" + keysOfResult.size() + ") doesn't correspond to number of result records!" + this.refScolDetail.size());
        detailsInCache = keysOfResult.getAspectRow(key).getRelatedAspect("REF_RELATION_1");
        this.verify(relationDetails == detailsInCache, "Relation details are not correctly cached");
        this.sf.cleanup();
    }

    public void testAspectRelatedAspectFromKey() {
        IAspect relationDetails = this.refScolDetail.getRelatedAspect("REF_RELATION_1");
        this.verify(relationDetails.size() == this.noOfQueryResults * 10, "Number of related Aspect Rows: " + relationDetails.size() + " expected: " + this.noOfQueryResults * 10);
        IAspect relationListInCache = this.refScolDetail.getRelatedAspect("REF_RELATION_1", (LockStrategy)null);
        this.verify(relationDetails == relationListInCache, "Relations list is not correctly cached");
    }

    public void testAspectRowRelatedAspect1() {
        int totalNoOfRelations = 0;
        IAspect relations = null;
        String key = null;
        int i = 0;
        while (i < this.refListKey.size()) {
            relations = this.refListKey.getAspectRow(i).getRelatedAspect("REF_RELATION_1", (LockStrategy)null);
            key = this.refListKey.getAspectRow(i).getKey().toString();
            totalNoOfRelations += relations.size();
            ++i;
        }
        this.verify(relations != null, "Aspect with Relations for detail test should not be null");
        this.verify(totalNoOfRelations == this.noOfQueryResults * 10, "Number of related Aspect Rows: " + totalNoOfRelations + " expected: " + this.noOfQueryResults * 10);
        String diffKeyString = key.substring(0, key.length() - 1);
        int i2 = 0;
        while (i2 < relations.size()) {
            this.verify(relations.getAspectRow(i2).getKey().toString().startsWith(diffKeyString), "Inconsistent Booking Key: " + relations.getAspectRow(i2).getKey() + " Source Key: " + diffKeyString);
            ++i2;
        }
        IAspect cachedRelations = this.refListKey.getAspectRow(this.refListKey.size() - 1).getRelatedAspect("REF_RELATION_1");
        this.verify(relations == cachedRelations, "Cache is not used, when relation is executed a second time");
        cachedRelations = this.refListKey.getAspectRow(this.refListKey.size() - 1).getRelatedAspect("REF_RELATION_1", LockStrategy.EXCLUSIVE);
        this.verify(relations == cachedRelations, "No reference stability, when relation is executed a second time with LockMode");
    }

    public void testAspectRowRelatedAspect2() {
        IAspect greatRelations = this.refListKey.getRelatedAspect("REF_RELATION_1");
        this.verify(greatRelations.size() == this.noOfQueryResults * 10, "Number of related Aspect Rows: " + greatRelations.size() + " expected: " + this.noOfQueryResults * 10);
        int totalNoOfRelations = 0;
        IAspect relations = null;
        String key = null;
        int i = 0;
        while (i < this.refListKey.size()) {
            relations = this.refListKey.getAspectRow(i).getRelatedAspect("REF_RELATION_1", (LockStrategy)null);
            key = this.refListKey.getAspectRow(i).getKey().toString();
            totalNoOfRelations += relations.size();
            ++i;
        }
        this.verify(relations != null, "Aspect with Bookings for detail test should not be null");
        this.verify(totalNoOfRelations == this.noOfQueryResults * 10, "Number of related Aspect Rows: " + totalNoOfRelations + " expected: " + this.noOfQueryResults * 10);
        String diffKeyString = key.substring(0, key.length() - 1);
        int i2 = 0;
        while (i2 < relations.size()) {
            this.verify(relations.getAspectRow(i2).getKey().toString().startsWith(diffKeyString), "Inconsistent Booking Key: " + relations.getAspectRow(i2).getKey() + " Source Key: " + diffKeyString);
            ++i2;
        }
        IAspect cachedBookings = this.refListKey.getAspectRow(this.refListKey.size() - 1).getRelatedAspect("REF_RELATION_1");
        this.verify(relations == cachedBookings, "Cache is not used, when relation is executed a second time");
        cachedBookings = this.refListKey.getAspectRow(this.refListKey.size() - 1).getRelatedAspect("REF_RELATION_1", LockStrategy.EXCLUSIVE);
        this.verify(relations == cachedBookings, "Cache is not used, when relation is executed a second time with LockMode");
    }

    public void testAspectRowRelatedAspectSorting() {
        SortingCriteria sortingCriteria = new SortingCriteria();
        sortingCriteria.addCriterion("REF_DATA3", false);
        sortingCriteria.addCriterion("REF_DATA4");
        this.verify(sortingCriteria.size() == 2, "size of SortingCriteria should be 2 but is: " + sortingCriteria.size());
        this.verify(sortingCriteria.getDirection(1), "Sorting Order should be ascending but is descending!");
        this.verify(!sortingCriteria.getDirection(0), "Sorting Order should be descending but is ascending!");
        this.verify(sortingCriteria.getFieldName(0).equals("REF_DATA3"), "Sorting Field should be DATA3 but is: " + sortingCriteria.getFieldName(0));
        this.verify(sortingCriteria.getFieldName(1).equals("REF_DATA4"), "Sorting Field should be DATA4 but is: " + sortingCriteria.getFieldName(1));
        IAspect related = this.refListKey.getAspectRow(0).getRelatedAspect("REF_RELATION_1", (LockStrategy)null, sortingCriteria);
        this.verify(related.size() == 10, "Number of related Aspect Rows: " + related.size() + " expected: 10");
    }

    public void testPerformanceBooster() {
        IAspect refScolKey = this.refScolDetail.getKeyAspect();
        IAspect refRelationDetails = refScolKey.getRelatedAspect("REF_RELATION_1");
        this.sf.flush();
        this.verify(this.refScolDetail.size() == this.noOfQueryResults, "Number of AspectRows should be " + this.noOfQueryResults + " but is: " + this.refScolDetail.size());
        this.verify(refScolKey.size() == this.noOfQueryResults, "Number of AspectRows should be " + this.noOfQueryResults + " but is: " + refScolKey.size());
        this.verify(refRelationDetails.size() == this.noOfQueryResults * 10, "Number of AspectRows should be " + this.noOfQueryResults * 10 + " but is: " + refRelationDetails.size());
    }

    public void testCardinality01Relations() {
        IAspectRow plane;
        IServiceModule smFlights = this.sf.getServiceModule("CL_SCOOL_SFLIGHT");
        this.verify(smFlights != null && smFlights.getDescriptor() != null, " error when getting ServiceModule 'CL_SCOOL_SFLIGHT'");
        IQuery flightQuery = smFlights.createQuery("FLIGHT_LIST");
        flightQuery.getInputParameterStructure().setAttributeValue("CITYFROM", (Object)"F*");
        flightQuery.execute();
        IAspect fligthDetails = flightQuery.getResultAspect().getAspect("SCOL_FLIGHTS_DETAIL");
        this.verify(fligthDetails.size() > 0, "precondition for test not fulfilled, size of flights is 0!");
        HashMap<IKey, IAspectRow> planes = new HashMap<IKey, IAspectRow>();
        int i = 0;
        while (i < fligthDetails.size()) {
            IAspectRow plane2 = fligthDetails.getAspectRow(i).getRelatedAspectRow("SCOL_FLIGHT_PLANETYPE");
            this.verify(plane2 != null, "relation of cardinality 1 should not return null!");
            if (!planes.containsKey(plane2.getKey())) {
                planes.put(plane2.getKey(), plane2);
                TestUtils.dump(plane2);
            }
            ++i;
        }
        Iterator it = planes.values().iterator();
        while (it.hasNext()) {
            plane = (IAspectRow)it.next();
            IAspectRow planeAddon = plane.getRelatedAspectRow("SCOL_PLANETYPE_TECH_ADDON");
            this.verify(planeAddon == null || planeAddon.getKey().equals(plane.getKey()), "incorrect related plane addon!");
            if (planeAddon == null) continue;
            TestUtils.dump(planeAddon);
        }
        it = planes.values().iterator();
        while (it.hasNext()) {
            plane = (IAspectRow)it.next();
            IAspectRow planeSeats = plane.getRelatedAspectRow("SCOL_PLANETYPE_TECH_SEATS");
            this.verify(planeSeats != null, "relation of cardinality 1 should not return null!");
            TestUtils.dump(planeSeats);
        }
    }

    public void testAspectRowRelationErrors() {
        String testString;
        IllegalArgumentException exc;
        IAspect bookings;
        try {
            bookings = this.refListKey.getRelatedAspect("C");
            this.flop("IllegalArgumentException expected");
        }
        catch (Throwable e) {
            this.verify(e instanceof IllegalArgumentException, "Caught Throwable is of type:" + e.getClass() + " Expected: IllegalArgumentException");
            exc = (IllegalArgumentException)e;
            testString = "or its Key has no relation with name 'C'";
            this.verify(exc.getMessage().endsWith(testString), "Exception should look like '" + testString + "', but is:" + exc.getMessage());
        }
        try {
            bookings = this.refScolDetail.getRelatedAspect("NO_RELATION", "SCOL_REF_RELATION_DETAIL", (LockStrategy)null);
            this.flop("IllegalArgumentException expected");
        }
        catch (Throwable e) {
            this.verify(e instanceof IllegalArgumentException, "Caught Throwable is of type:" + e.getClass() + " Expected: IllegalArgumentException");
            exc = (IllegalArgumentException)e;
            testString = "or its Key has no relation with name 'NO_RELATION'";
            this.verify(exc.getMessage().endsWith(testString), "Exception should look like '" + testString + "', but is:" + exc.getMessage());
        }
        try {
            bookings = this.refScolDetail.getRelatedAspect("REF_RELATION_1", "XXXXX", (LockStrategy)null);
            this.flop("IllegalArgumentException expected");
        }
        catch (Throwable e) {
            this.verify(e instanceof IllegalArgumentException, "Caught Throwable is of type:" + e.getClass() + " Expected: IllegalArgumentException");
            exc = (IllegalArgumentException)e;
            testString = "to Aspect with name 'XXXXX'";
            this.verify(exc.getMessage().endsWith(testString), "Exception should look like '" + testString + "', but is:" + exc.getMessage());
        }
        try {
            IAspectRow booking = this.refListKey.getAspectRow(0).getRelatedAspectRow("REF_RELATION_1");
            this.flop("IllegalArgumentException expected");
        }
        catch (Throwable e) {
            this.verify(e instanceof IllegalArgumentException, "Caught Throwable is of type:" + e.getClass() + " Expected: IllegalArgumentException");
            exc = (IllegalArgumentException)e;
            testString = "Cardinality of relation REF_RELATION_1 has to be 1:0..1 but is 1..n";
            this.verify(exc.getMessage().endsWith(testString), "Exception should look like '" + testString + "', but is:" + exc.getMessage());
        }
        try {
            bookings = this.refListKey.getAspectRow(0).getRelatedAspect("NO_RELATION", (LockStrategy)null);
            this.flop("IllegalArgumentException expected");
        }
        catch (Throwable e) {
            this.verify(e instanceof IllegalArgumentException, "Caught Throwable is of type:" + e.getClass() + " Expected: IllegalArgumentException");
            exc = (IllegalArgumentException)e;
            testString = "or its Key has no relation with name 'NO_RELATION'";
            this.verify(exc.getMessage().endsWith(testString), "Exception should look like '" + testString + "', but is:" + exc.getMessage());
        }
    }
}

