/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;

public class TestRefresh
extends Test {
    IServiceFacade sf;
    IServiceModule serviceModule;
    IAspect queryResult;
    IQuery query;
    boolean resetDB = false;

    public void prepare() {
        this.sf = TestUtils.prepare(this);
        this.serviceModule = this.sf.getServiceModule("COL_REF_IMPLEMENTATION");
        this.query = this.serviceModule.createQuery("REF_QUERY_1");
        IStructure parms = this.query.getInputParameterStructure();
        parms.setAttributeValue("DATA3", (Object)"*78");
        this.query.execute();
        this.queryResult = this.query.getResultAspect();
    }

    public void cleanUp() {
        if (this.resetDB) {
            TestUtils.resetDBRefServiceModule(this.sf);
            this.resetDB = false;
        }
        this.sf.closeConnection();
    }

    public static void adjustTestAttributes(IJverTestAttributes attributes) {
        attributes.setTestSet(new String[]{"testPreconditions", "testQueryRefresh", "testSimpleRefresh", "testSimpleRefreshAspectRow1", "testSimpleRefreshAspectRow2", "testSimpleRefreshAspectRowWithLocalKeys", "testRefreshAspectAfterDelete", "testSimpleRefreshWithLocalKeys1", "testSimpleRefreshWithLocalKeys2", "testRefreshAfterDelete", "testComplexRefreshWithRelations", "testLocalAspectWithKeys", "testLocalKeysAspectWithKeys", "testEmptyAspectWithKeys", "testWithDirtyAspect", "testDirtyRootAspectWithKeys", "testEmptyRootAspectWithLocalKey", "testFlightsRefresh"});
        TestUtils.adjustTestAttributes(attributes);
    }

    public void testPreconditions() {
        this.verify(this.serviceModule != null, "ServiceModule creation failed");
        this.verify(this.queryResult != null && this.queryResult.size() == 10, "Query result size should be 10 but is: " + this.queryResult.size());
    }

    public void testQueryRefresh() {
        IAspectRow oldResultRow = this.queryResult.getAspectRow(0);
        this.query.getInputParameterStructure().setAttributeValue("DATA3", (Object)"*98");
        this.query.execute();
        this.sf.flush();
        this.verify(this.queryResult == this.query.getResultAspect(), "result of Query is not reference stable!");
        this.verify(!oldResultRow.isValid(), "old result AspectRow should be invalid after refresh of Query");
        this.verify(this.queryResult.size() == 10, "size of Query result should be 10 but is " + this.queryResult.size());
    }

    public void testSimpleRefresh() {
        IAspect keyOfSiblings = this.queryResult.getRelatedAspect("REF_RELATION_SIB");
        IAspect sibling1 = keyOfSiblings.getAspect("SCOL_REF_SIB_DETAIL_1");
        IAspect sibling2 = sibling1.getAspect("SCOL_REF_SIB_DETAIL_2");
        IKey testKey = sibling2.getAspectRow(0).getKey();
        this.sf.flush();
        int sizeOfSibling = sibling2.size();
        keyOfSiblings.refresh();
        int newSize = sibling2.size();
        this.verify(sizeOfSibling == newSize, "new size: " + newSize + " but expected size is: " + sizeOfSibling);
        this.verify(sibling2.getAspectRow(testKey).isValid(), "AspectRow of sibling2 with Key " + testKey + " is no more valid after refresh");
    }

    public void testSimpleRefreshAspectRow1() {
        IAspect keyOfSiblings = this.queryResult.getRelatedAspect("REF_RELATION_SIB");
        IAspectRow sibling1Row1 = keyOfSiblings.getAspectRow(0).getAspectRow("SCOL_REF_SIB_DETAIL_1");
        IAspectRow sibling1Row2 = keyOfSiblings.getAspectRow(1).getAspectRow("SCOL_REF_SIB_DETAIL_1");
        IAspectRow sibling2Row1 = sibling1Row1.getAspectRow("SCOL_REF_SIB_DETAIL_2");
        IAspectRow sibling2Row2 = sibling1Row1.getAspectRow("SCOL_REF_SIB_DETAIL_2");
        this.sf.flush();
        keyOfSiblings.refresh();
        this.verify(sibling1Row1.getKey().equals(sibling2Row1.getKey()), "Key of Siblings are different!");
        this.verify(sibling2Row2.isValid(), "sibling2Row2 is no more valid after refresh");
        this.verify(sibling1Row2.isValid(), "sibling1Row2 is no more valid after refresh");
    }

    public void testSimpleRefreshAspectRow2() {
        IAspect siblingRow1 = this.queryResult.getAspectRow(0).getRelatedAspect("REF_RELATION_SIB");
        int noOfRows = siblingRow1.size();
        TestUtils.dump(siblingRow1);
        IAspectRow sibling1Row1 = siblingRow1.getAspectRow(0).getAspectRow("SCOL_REF_SIB_DETAIL_1");
        IAspectRow sibling1Row2 = siblingRow1.getAspectRow(1).getAspectRow("SCOL_REF_SIB_DETAIL_1");
        IAspectRow sibling2Row1 = sibling1Row1.getAspectRow("SCOL_REF_SIB_DETAIL_2");
        IAspectRow sibling2Row2 = sibling1Row1.getAspectRow("SCOL_REF_SIB_DETAIL_2");
        this.sf.flush();
        siblingRow1.refresh();
        this.verify(sibling1Row1.getKey().equals(sibling2Row1.getKey()), "Key of Siblings are different!");
        this.verify(siblingRow1.size() == noOfRows, "Size of siblingRow1 should be " + noOfRows + " but is " + siblingRow1.size());
    }

    public void testSimpleRefreshAspectRowWithLocalKeys() {
        IAspect siblingRow1 = this.queryResult.getAspectRow(0).getRelatedAspect("REF_RELATION_SIB");
        int noOfRows = siblingRow1.size();
        TestUtils.dump(siblingRow1);
        IAspectRow sibling1Row1 = siblingRow1.getAspectRow(0).getAspectRow("SCOL_REF_SIB_DETAIL_1");
        IAspectRow sibling1Row2 = siblingRow1.getAspectRow(1).getAspectRow("SCOL_REF_SIB_DETAIL_1");
        IAspectRow sibling1Key1 = sibling1Row1.getAspectRow("SCOL_REF_SIB_KEY");
        IAspectRow sibling1Key2 = sibling1Row1.getAspectRow("SCOL_REF_SIB_KEY");
        IAspectRow sibling2Row1 = sibling1Row1.getAspectRow("SCOL_REF_SIB_DETAIL_2");
        IAspectRow sibling2Row2 = sibling1Row1.getAspectRow("SCOL_REF_SIB_DETAIL_2");
        this.sf.flush();
        siblingRow1.refresh();
        this.verify(sibling1Key1.getKey().equals(sibling1Row1.getKey()), "Key of Siblings are different!");
        this.verify(siblingRow1.size() == noOfRows, "Size of siblingRow1 should be " + noOfRows + " but is " + siblingRow1.size());
        this.verify(sibling2Row1.isValid(), "sibling2Row1 is no more valid after refresh");
        this.verify(sibling2Row2.isValid(), "sibling2Row2 is no more valid after refresh");
    }

    public void testRefreshAspectAfterDelete() {
        this.sf.getAllMessages().clear();
        IAspect siblingRow1 = this.queryResult.getAspectRow(0).getRelatedAspect("REF_RELATION_SIB");
        int noOfRows = siblingRow1.size();
        TestUtils.dump(siblingRow1);
        IAspectRow sibling1Row1 = siblingRow1.getAspectRow(0).getAspectRow("SCOL_REF_SIB_DETAIL_1");
        IAspectRow sibling1Row2 = siblingRow1.getAspectRow(1).getAspectRow("SCOL_REF_SIB_DETAIL_1");
        IAspectRow sibling1Key1 = sibling1Row1.getAspectRow("SCOL_REF_SIB_KEY");
        IAspectRow sibling1Key2 = sibling1Row2.getAspectRow("SCOL_REF_SIB_KEY");
        IAspectRow sibling2Row1 = sibling1Row1.getAspectRow("SCOL_REF_SIB_DETAIL_2");
        IAspectRow sibling2Row2 = sibling1Row2.getAspectRow("SCOL_REF_SIB_DETAIL_2");
        this.sf.flush();
        IAspect aspectForRemove = this.serviceModule.getAspect(siblingRow1.getDescriptor().getName(), siblingRow1.getKeyList());
        aspectForRemove.removeAspectRow(aspectForRemove.getAspectRow(0));
        this.sf.flush();
        this.verify(!TestUtils.isErrorMessages(this.sf.getAllMessages()), "errors in delete of AspectRow");
        this.sf.save();
        this.resetDB = true;
        siblingRow1.refresh();
        this.sf.flush();
        this.verify(!sibling1Row1.isValid(), "AspectRow sibling1Row1 should be invalid");
        this.verify(!sibling2Row1.isValid(), "AspectRow sibling2Row1 should be invalid");
        this.verify(!sibling1Key1.isValid(), "AspectRow sibling1Key1 should be invalid");
        this.verify(sibling1Row2.isValid(), "AspectRow sibling1Row2 should be valid");
        this.verify(sibling1Key2.isValid(), "AspectRow sibling1Key2 should be valid");
        this.verify(sibling2Row2.isValid(), "AspectRow sibling2Row2 should be valid");
    }

    public void testSimpleRefreshWithLocalKeys1() {
        IAspect keyOfSiblings = this.queryResult.getRelatedAspect("REF_RELATION_SIB");
        IAspect sibling1 = keyOfSiblings.getAspect("SCOL_REF_SIB_DETAIL_1");
        IAspect sibling2 = sibling1.getAspect("SCOL_REF_SIB_DETAIL_2");
        IAspect keys = sibling1.getKeyAspect();
        this.sf.flush();
        int sizeOfSibling = keys.size();
        keyOfSiblings.refresh();
        int newSize = keys.size();
        this.verify(sizeOfSibling == newSize, "new size: " + newSize + " but expected size is: " + sizeOfSibling);
    }

    public void testSimpleRefreshWithLocalKeys2() {
        IAspect keyOfSiblings = this.queryResult.getRelatedAspect("REF_RELATION_SIB");
        IAspect sibling1 = keyOfSiblings.getAspect("SCOL_REF_SIB_DETAIL_1");
        IAspect sibling2 = sibling1.getAspect("SCOL_REF_SIB_DETAIL_2");
        this.sf.flush();
        IAspect keys = sibling1.getKeyAspect();
        int sizeOfSibling = keys.size();
        keyOfSiblings.refresh();
        int newSize = keys.size();
        this.verify(sizeOfSibling == newSize, "new size: " + newSize + " but expected size is: " + sizeOfSibling);
    }

    public void testRefreshAfterDelete() {
        this.sf.getAllMessages().clear();
        IAspect keyOfSiblings = this.queryResult.getRelatedAspect("REF_RELATION_SIB");
        IAspect sibling1 = keyOfSiblings.getAspect("SCOL_REF_SIB_DETAIL_1");
        IAspect sibling2 = sibling1.getAspect("SCOL_REF_SIB_DETAIL_2");
        IAspect keys = sibling1.getKeyAspect();
        IAspect aspectForRemove = this.serviceModule.getAspect(sibling1.getDescriptor().getName(), sibling1.getKeyList());
        int noAfterRefresh = sibling1.size();
        int i = 0;
        while (i < aspectForRemove.size()) {
            if (i % 3 == 0) {
                aspectForRemove.remove(i);
                --noAfterRefresh;
            }
            ++i;
        }
        this.verify(noAfterRefresh < keys.size(), "preconditions not fulfilled removed AspectRows = 0");
        this.sf.flush();
        this.verify(!TestUtils.isErrorMessages(this.sf.getAllMessages()), "errors in delete of AspectRow");
        this.sf.save();
        this.resetDB = true;
        TestUtils.dumpMessageList("Errors when delete: ", this.sf.getAllMessages());
        this.verify(!TestUtils.isErrorMessages(this.sf.getAllMessages()), "preconditions not fulfilled errors when delete:");
        keyOfSiblings.refresh();
        this.verify(noAfterRefresh == sibling1.size(), "new size: " + sibling1.size() + " but expected size is: " + noAfterRefresh);
        this.verify(noAfterRefresh == keys.size(), "new size: " + keys.size() + " but expected size is: " + noAfterRefresh);
    }

    public void testComplexRefreshWithRelations() {
        IAspect keyOfSiblings = this.queryResult.getRelatedAspect("REF_RELATION_SIB");
        IAspect rowSibling1 = this.queryResult.getAspectRow(0).getRelatedAspect("REF_RELATION_SIB");
        IKeyList keyListBefore = rowSibling1.getKeyList();
        IAspect rowSibling2 = this.queryResult.getAspectRow(1).getRelatedAspect("REF_RELATION_SIB");
        this.sf.flush();
        int noOfRows = rowSibling2.size();
        this.queryResult.refresh();
        this.verify(rowSibling2.size() == noOfRows, "size is not correct after refresh!");
        IKeyList keyListAfter = rowSibling1.getKeyList();
        this.verify(keyListBefore.size() == keyListAfter.size(), "size of Keylists inconsistent before = " + keyListBefore.size() + " after =" + keyListAfter.size());
        int i = 0;
        while (i < keyListBefore.size()) {
            this.verify(keyListAfter.contains(keyListBefore.get(i)), " Key " + keyListBefore.get(i) + " no more exists");
            ++i;
        }
    }

    public void testLocalAspectWithKeys() {
        IKeyList keyList = this.queryResult.getKeyList();
        IAspect rootAspect = this.serviceModule.getAspect("SCOL_REF_DETAIL", keyList);
        this.verify(rootAspect.size() == this.queryResult.size(), "size of root Aspect " + rootAspect.size() + " should be equal to size of query result " + this.queryResult.size());
        rootAspect.refresh();
        this.verify(rootAspect.size() == this.queryResult.size(), "size of root Aspect " + rootAspect.size() + " should be equal to size of query result " + this.queryResult.size());
    }

    public void testEmptyAspectWithKeys() {
        this.sf.getAllMessages().clear();
        IAspect rootAspect = this.serviceModule.createAspect("SCOL_REF_DETAIL");
        IAspectRow rowToInsert = rootAspect.createAspectRow();
        IKey keyToInsert = rowToInsert.getKey();
        rowToInsert.setAttributeValue("KEY1", (Object)"0000000002");
        rowToInsert.setAttributeValue("KEY2", (Object)"0000000001");
        rowToInsert.setAttributeValue("KEY3", (Object)"0000000011");
        this.sf.flush();
        TestUtils.dumpMessageList("Messages after insert", this.sf.getAllMessages());
        this.verify(!TestUtils.isErrorMessages(this.sf.getAllMessages()), "no errors expected after insert");
        this.sf.save();
        this.verify(rootAspect.size() == 1, "size of root Aspect " + rootAspect.size() + " should be 1 ");
        rootAspect.refresh();
        this.verify(rootAspect.size() == 1, "size of root Aspect " + rootAspect.size() + " should be 1 ");
    }

    public void testLocalKeysAspectWithKeys() {
        IKeyList keyList = this.queryResult.getKeyList();
        IAspect rootAspect = this.serviceModule.getAspect("SCOL_REF_KEY", keyList);
        this.verify(rootAspect.size() == this.queryResult.size(), "size of root Aspect " + rootAspect.size() + " should be equal to size of query result " + this.queryResult.size());
        rootAspect.refresh();
        this.verify(rootAspect.size() == this.queryResult.size(), "size of root Aspect " + rootAspect.size() + " should be equal to size of query result " + this.queryResult.size());
    }

    public void testWithDirtyAspect() {
        this.sf.getAllMessages().clear();
        IKeyList keyList = this.queryResult.getKeyList();
        IAspect rootAspect = this.serviceModule.getAspect("SCOL_REF_KEY", keyList);
        IAspect sibling = rootAspect.getRelatedAspect("REF_RELATION_SIB");
        keyList = sibling.getKeyList();
        sibling.removeAspectRow(sibling.getAspectRow(0));
        this.verify(sibling.size() == keyList.size() - 1, "size of root Aspect after one row removed should be " + (keyList.size() - 1) + " but is " + sibling.size());
        rootAspect.refresh();
        this.verify(sibling.size() == keyList.size(), "size of root Aspect after refresh should be " + keyList.size() + " but is " + sibling.size());
        sibling.removeAspectRow(sibling.getAspectRow(0));
        sibling.sendChanges();
        try {
            rootAspect.refresh();
            this.verify(false, "Expected Exception IllegalStateException wasn't thrown");
        }
        catch (Throwable e) {
            this.verify(e instanceof IllegalStateException, "Caught Exception is not of type IllegalStateException but:" + e.getClass().getName());
        }
    }

    public void testDirtyRootAspectWithKeys() {
        IKeyList keyList = this.queryResult.getKeyList();
        IAspect rootAspect = this.serviceModule.getAspect("SCOL_REF_DETAIL", keyList);
        this.verify(rootAspect.size() == this.queryResult.size(), "size of root Aspect " + rootAspect.size() + " should be equal to size of query result " + this.queryResult.size());
        rootAspect.remove(0);
        rootAspect.remove(rootAspect.size() - 1);
        rootAspect.refresh();
        this.verify(rootAspect.size() == keyList.size(), "size of refreshed root Aspect " + rootAspect.size() + " should be equal to size of query result " + keyList.size());
        int i = 0;
        while (i < keyList.size()) {
            this.verify(rootAspect.getAspectRow(keyList.getKey(i)) != null, " AspectRow for Key " + keyList.getKey(i) + " doesn' t exist after refersh");
            ++i;
        }
    }

    public void testEmptyRootAspectWithLocalKey() {
        this.sf.getAllMessages().clear();
        IAspect rootAspect = this.serviceModule.createAspect("SCOL_REF_DETAIL");
        IAspectRow rowToInsert = rootAspect.createAspectRow();
        IKey keyToInsert = rowToInsert.getKey();
        long modCount = rowToInsert.modCount();
        this.verify(modCount == 0L, "modification counter should be 0 but is: " + modCount);
        rowToInsert.setAttributeValue("KEY1", (Object)"0000000002");
        modCount = rowToInsert.modCount();
        this.verify(modCount == 1L, "modification counter should be 1 but is: " + modCount);
        rowToInsert.setAttributeValue(1, (Object)"0000000001");
        modCount = rowToInsert.modCount();
        this.verify(modCount == 2L, "modification counter should be 2 but is: " + modCount);
        rowToInsert.setAttributeValue("KEY3", (Object)"0000000011");
        this.verify(rootAspect.size() == 1, "size of root Aspect " + rootAspect.size() + " should be 1 ");
        rootAspect.refresh();
        this.verify(rootAspect.size() == 0, "size of root Aspect after refresh should be 0, but is " + rootAspect.size());
    }

    public void testFlightsRefresh() {
        IServiceModule flServiceModule = this.sf.getServiceModule("CL_SCOOL_SFLIGHT");
        this.sf.getAllMessages().clear();
        IQuery query = flServiceModule.createQuery("FLIGHT_LIST");
        IStructure search = query.getInputParameterStructure();
        search.setAttributeValue("CITYFROM", (Object)"F*");
        search.setAttributeValue("CITYTO", (Object)"B*");
        query.execute();
        IAspect queryResult = query.getResultAspect();
        IAspect bookings1 = queryResult.getAspectRow(0).getRelatedAspect("BOOKINGS");
        this.sf.flush();
        int resultSize = queryResult.size();
        int bookingsSize = bookings1.size();
        queryResult.refresh();
        this.verify(queryResult.size() == resultSize, "result size is not correct after refresh!");
        this.verify(bookings1.size() == bookingsSize, "bookings size is not correct after refresh!");
    }
}

