/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;

public class TestLocking
extends Test {
    IServiceFacade sf;
    IServiceModule refServiceModule;
    IAspect refScolDetail;

    public void prepare() {
        this.sf = TestUtils.prepare(this);
        this.refServiceModule = this.sf.getServiceModule("COL_REF_IMPLEMENTATION");
        IQuery refQuery = this.refServiceModule.createQuery("REF_QUERY_1");
        IStructure parms = refQuery.getInputParameterStructure();
        parms.setAttributeValue("DATA3", (Object)"*13");
        refQuery.execute();
        this.refScolDetail = refQuery.getResultAspect();
        this.sf.flush();
    }

    public void cleanUp() {
        this.sf.cleanup();
        this.sf.closeConnection();
    }

    public static void adjustTestAttributes(IJverTestAttributes attributes) {
        attributes.setTestSet(new String[]{"testPreconditions", "testInitialStates", "testlockAndRefresh", "testlockInSelectCall", "testlockInRelationCall1", "testlockInRelationCall2", "testlockInSelectAndRelation", "testUnLock"});
        TestUtils.adjustTestAttributes(attributes);
    }

    public void testPreconditions() {
        this.verify(this.refServiceModule != null, "COL_REF_IMPLEMENTATION ServiceModule could not be created!");
        this.verify(this.refScolDetail.size() > 0, "Size of test Aspect should be > 0");
    }

    public void testInitialStates() {
        int i = 0;
        while (i < this.refScolDetail.size()) {
            this.verify(!this.refScolDetail.getAspectRow(i).getLockState().hasLock(), "AspectRow '" + this.refScolDetail.getAspectRow(i).getKey() + "' holds not expected locks!");
            ++i;
        }
    }

    public void testlockAndRefresh() {
        int i = 0;
        while (i < this.refScolDetail.size()) {
            IAspectRow row = this.refScolDetail.getAspectRow(i, LockStrategy.EXCLUSIVE);
            this.sf.flush();
            this.verify(row.getLockState().hasExclusiveLock(), "AspectRow '" + this.refScolDetail.getAspectRow(i).getKey() + "' doesn't holds expected E locks!");
            ++i;
        }
        this.refScolDetail.unlock();
        this.verify(!TestUtils.isErrorMessages(this.refScolDetail.getMessages()), "Error messages exist after unlock!" + this.refScolDetail.getMessages());
        int i2 = 0;
        while (i2 < this.refScolDetail.size()) {
            this.verify(!this.refScolDetail.getAspectRow(i2).getLockState().hasLock(), "AspectRow '" + this.refScolDetail.getAspectRow(i2).getKey() + "' holds not expected locks!");
            ++i2;
        }
        IAspectRow testRow = this.refScolDetail.getAspectRow(0, LockStrategy.SHARED_PROMOTABLE_WITH_LOCK_PROMOTION_ON_UPDATE);
        this.sf.flush();
        this.verify(testRow.getLockState().isEditable(), "AspectRow '" + testRow.getKey() + "' not holds expected lock!");
        this.verify(!TestUtils.isErrorMessages(this.refScolDetail.getMessages()), "Error messages exist after promoteLock!" + this.refScolDetail.getMessages());
        if (this.refScolDetail.getDescriptor().getAttributeLockmodeSharedPromotable()) {
            this.verify(testRow.getLockState().hasSharedPromotableLock(), "AspectRow '" + testRow.getKey() + "' not holds expected SP lock!");
        } else {
            this.verify(testRow.getLockState().hasExclusiveLock(), "AspectRow '" + testRow.getKey() + "' not holds expected EXCLUSIVE lock!");
        }
        this.sf.cleanup();
        this.verify(!testRow.getLockState().hasLock(), "AspectRow '" + testRow.getKey() + "' holds not expected locks!");
    }

    public void testlockInSelectCall() {
        IAspect refScolDetailLocked = this.refServiceModule.getAspect(this.refScolDetail.getDescriptor().getName(), this.refScolDetail.getKeyList(), LockStrategy.EXCLUSIVE);
        int i = 0;
        while (i < refScolDetailLocked.size()) {
            this.verify(refScolDetailLocked.getAspectRow(i).getLockState().hasExclusiveLock(), "AspectRow '" + refScolDetailLocked.getAspectRow(i).getKey() + "' doesn't holds expected EXCLUSIVE locks!");
            ++i;
        }
        int i2 = 0;
        while (i2 < refScolDetailLocked.size()) {
            refScolDetailLocked.getAspectRow(i2).unlock();
            ++i2;
        }
        this.sf.flush();
        int i3 = 0;
        while (i3 < refScolDetailLocked.size()) {
            this.verify(!refScolDetailLocked.getAspectRow(i3).getLockState().hasLock(), "AspectRow '" + refScolDetailLocked.getAspectRow(i3).getKey() + "' holds not expected locks!");
            ++i3;
        }
        refScolDetailLocked = this.refServiceModule.getAspect(this.refScolDetail.getDescriptor().getName(), this.refScolDetail.getKeyList(), LockStrategy.SHARED_PROMOTABLE_WITH_LOCK_PROMOTION_ON_UPDATE);
        int i4 = 0;
        while (i4 < refScolDetailLocked.size()) {
            if (refScolDetailLocked.getDescriptor().getAttributeLockmodeSharedPromotable()) {
                this.verify(refScolDetailLocked.getAspectRow(i4).getLockState().hasSharedPromotableLock(), "AspectRow '" + refScolDetailLocked.getAspectRow(i4).getKey() + "' doesn't holds expected SP locks!");
            } else {
                this.verify(refScolDetailLocked.getAspectRow(i4).getLockState().hasExclusiveLock(), "AspectRow '" + refScolDetailLocked.getAspectRow(i4).getKey() + "' doesn't holds expected EXCLUSIVE locks!");
            }
            ++i4;
        }
    }

    public void testlockInRelationCall1() {
        IAspect scolRefRelationDetail = this.refScolDetail.getRelatedAspect("REF_RELATION_1", LockStrategy.SHARED_PROMOTABLE_WITH_LOCK_PROMOTION_ON_UPDATE);
        int i = 0;
        while (i < scolRefRelationDetail.size()) {
            this.verify(scolRefRelationDetail.getAspectRow(i).getLockState().isEditable(), "AspectRow '" + scolRefRelationDetail.getAspectRow(i).getKey() + "' doesn't holds expected locks!");
            ++i;
        }
        int i2 = 0;
        while (i2 < scolRefRelationDetail.size()) {
            scolRefRelationDetail.getAspectRow(i2).promoteLock();
            ++i2;
        }
        int i3 = 0;
        while (i3 < scolRefRelationDetail.size()) {
            this.verify(scolRefRelationDetail.getAspectRow(i3).getLockState().hasExclusiveLock(), "AspectRow '" + scolRefRelationDetail.getAspectRow(i3).getKey() + "' doesn't holds expected EXCLUSIVE locks!");
            ++i3;
        }
    }

    public void testlockInRelationCall2() {
        IAspect scolRefRelationDetail = this.refScolDetail.getAspectRow(0).getRelatedAspect("REF_RELATION_1", LockStrategy.EXCLUSIVE);
        int i = 0;
        while (i < scolRefRelationDetail.size()) {
            this.verify(scolRefRelationDetail.getAspectRow(i).getLockState().hasExclusiveLock(), "AspectRow '" + scolRefRelationDetail.getAspectRow(i).getKey() + "' doesn't holds expected E locks!");
            ++i;
        }
    }

    public void testlockInSelectAndRelation() {
        IAspect sibling = this.refScolDetail.getAspectRow(0).getRelatedAspect("REF_RELATION_SIB", LockStrategy.EXCLUSIVE);
        int i = 0;
        while (i < sibling.size()) {
            this.verify(sibling.getAspectRow(i).getLockState().hasExclusiveLock(), "AspectRow '" + sibling.getAspectRow(i).getKey() + "' doesn't holds expected EXCLUSIVE locks!");
            ++i;
        }
        IAspectRow siblingRow = sibling.getAspectRow(0).getAspectRow("SCOL_REF_SIB_DETAIL_2", LockStrategy.EXCLUSIVE);
        this.verify(!siblingRow.getLockState().hasSharedLock(), "AspectRow '" + siblingRow.getKey() + "' holds not expected SHARED lock!");
        this.verify(siblingRow.getLockState().hasExclusiveLock(), "AspectRow '" + siblingRow.getKey() + "' doesn't hold expected EXCLUSIVE lock!");
    }

    public void testUnLock() {
        IAspect siblingKey = this.refScolDetail.getAspectRow(0).getRelatedAspect("REF_RELATION_SIB", LockStrategy.EXCLUSIVE);
        int i = 0;
        while (i < siblingKey.size()) {
            this.verify(siblingKey.getAspectRow(i).getLockState().hasExclusiveLock(), "AspectRow '" + siblingKey.getAspectRow(i).getKey() + "' doesn't holds expected Exclusive lock!");
            this.verify(!siblingKey.getAspectRow(i).getLockState().hasExclusiveLockFailed(), "AspectRow '" + siblingKey.getAspectRow(i).getKey() + "': hasExclusiveLockFailed() is not set correctly");
            ++i;
        }
        IAspect sibling = siblingKey.getAspect("SCOL_REF_SIB_DETAIL_2", LockStrategy.EXCLUSIVE);
        int i2 = 0;
        while (i2 < sibling.size()) {
            this.verify(sibling.getAspectRow(i2).getLockState().hasExclusiveLock(), "AspectRow '" + sibling.getAspectRow(i2).getKey() + "' doesn't holds expected Exclusive lock!");
            ++i2;
        }
        IAspect sameSibling = this.refServiceModule.getAspect(sibling.getDescriptor().getName(), sibling.getKeyList(), LockStrategy.SHARED_PROMOTABLE_WITH_LOCK_PROMOTION_ON_UPDATE);
        int i3 = 0;
        while (i3 < sameSibling.size()) {
            this.verify(sameSibling.getAspectRow(i3).getLockState().isEditable(), "AspectRow '" + sameSibling.getAspectRow(i3).getKey() + "' doesn't holds expected EXCLUSIVE lock!");
            ++i3;
        }
        sameSibling.unlock();
        int i4 = 0;
        while (i4 < sameSibling.size()) {
            this.verify(!sameSibling.getAspectRow(i4).getLockState().hasLock(), "AspectRow '" + sameSibling.getAspectRow(i4).getKey() + "' holds not expected locks!");
            this.verify(!sibling.getAspectRow(i4).getLockState().hasLock(), "AspectRow '" + sibling.getAspectRow(i4).getKey() + "' holds not expected locks!");
            ++i4;
        }
    }
}

