/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;

public class TestInvalidation
extends Test {
    IServiceFacade sf;
    IServiceModule serviceModule;
    IAspect result;
    IAspect flightsDetail;
    IAspect flightKeys;
    IAspect bookings1;
    IAspect bookings2;
    IAspect flightsDetail1;
    IAspect flightKeys1;
    IAspect bookings11;
    IAspect bookings12;
    IQuery query;

    public void prepare() {
        this.sf = TestUtils.prepare(this);
        this.serviceModule = this.sf.getServiceModule("CL_SCOOL_SFLIGHT");
        this.query = this.serviceModule.createQuery("FLIGHT_LIST");
        IStructure parms = this.query.getInputParameterStructure();
        parms.setAttributeValue("CITYFROM", (Object)"F*");
        parms.setAttributeValue("CITYTO", (Object)"*");
        this.query.execute();
        this.query.execute();
        this.sf.flush();
        this.result = this.query.getResultAspect();
        this.flightsDetail = this.result.getAspect("SCOL_FLIGHTS_DETAIL");
        this.flightKeys = this.result.getKeyAspect();
        if (this.flightKeys.size() > 1) {
            this.bookings1 = this.flightKeys.getAspectRow(0).getRelatedAspect("BOOKINGS");
            this.bookings2 = this.flightKeys.getAspectRow(1).getRelatedAspect("BOOKINGS");
        }
        this.sf.flush();
        IKeyList keyList = this.result.getKeyList();
        this.flightKeys1 = this.serviceModule.getAspect("SCOL_FLIGHTS_KEY", keyList);
        this.flightsDetail1 = this.flightKeys1.getAspect("SCOL_FLIGHTS_DETAIL");
        this.sf.flush();
        if (this.flightKeys1.size() > 1) {
            this.bookings11 = this.flightKeys1.getAspectRow(0).getRelatedAspect("BOOKINGS");
            this.bookings12 = this.flightKeys1.getAspectRow(1).getRelatedAspect("BOOKINGS");
        }
        this.sf.flush();
    }

    public void cleanUp() {
        this.sf.closeConnection();
    }

    public static void adjustTestAttributes(IJverTestAttributes attributes) {
        TestUtils.adjustTestAttributes(attributes);
    }

    public void testPreconditions() {
        this.verify(this.serviceModule != null, "ServiceModule creation failed");
        this.verify(this.result != null && this.result.size() > 0, "Result Aspect is null or has no AspectRows");
        this.verify(this.flightKeys != null && this.flightKeys.size() > 0, "Key Aspect of Result is null or has no AspectRows");
        this.verify(this.flightsDetail != null && this.flightsDetail.size() > 0, "Details Aspect of Result is null or has no AspectRows");
        this.verify(this.bookings1 != null && this.bookings1.size() > 0, "First Bookings Aspect is null");
        this.verify(this.bookings2 != null, "Second Bookings Aspect is null");
        this.verify(this.flightKeys1 != null && this.flightKeys1.size() > 0, "Key Aspect of Result is null or has no AspectRows");
        this.verify(this.flightsDetail1 != null && this.flightsDetail1.size() > 0, "Details Aspect of Result is null or has no AspectRows");
        this.verify(this.bookings11 != null && this.bookings11.size() > 0, "First Bookings Aspect is null");
        this.verify(this.bookings12 != null, "Second Bookings Aspect is null");
    }

    public void testInvalidationDefaults() {
        this.bookings1.getAspectRow(0).setAttributeValue("SMOKER", (Object)"X");
        this.verify(this.sf.isDirty(), "No pending changes!");
        this.verify(this.bookings1.isValid(), "bookings1 is no more valid!");
        this.verify(this.flightsDetail.isValid(), "flightsDetail is no more valid!");
        this.verify(this.bookings1.getAspectRow(0).getAttributeAsString("SMOKER").equals("X"), "Field SMOKER is not changed to 'X'");
        this.verify(this.bookings2.size() >= 0, "Second Bookings Aspect is inconsistent");
        this.verify(this.flightKeys.size() > 0, "Key Aspect of Result has no Aspect Rows");
        this.verify(this.flightsDetail.size() > 0, "Details Aspect of Result has no Aspect Rows");
        this.verify(this.result.size() > 0, "Result Aspect has no Aspect Rows");
    }

    public void testInvalidationWithHints2() {
        this.bookings1.setInvalidationHint("INSERT", 3);
        this.bookings1.getAspectRow(0).setAttributeValue("SMOKER", (Object)"X");
        this.verify(this.sf.isDirty(), "No pending changes!");
        this.verify(this.bookings1.getAspectRow(0).getAttributeAsString("SMOKER").equals("X"), "Field SMOKER is not changed to 'X'");
        this.verify(this.bookings2.size() >= 0, "Second Bookings Aspect is inconsistent");
        this.verify(this.flightKeys.size() > 0, "Key Aspect of Result has no Aspect Rows");
        this.verify(this.flightsDetail.size() > 0, "Details Aspect of Result has no Aspect Rows");
        this.verify(this.result.size() > 0, "Result Aspect has no Aspect Rows");
    }

    public void testExplicitInvalidationOfQuery() {
        IAspectRow rowBookings1 = this.bookings1.getAspectRow(0);
        IAspectRow rowflight = this.result.getAspectRow(this.result.size() - 1);
        IAspectRow rowDetails = this.flightsDetail.getAspectRow(0);
        this.query.invalidate();
        this.testInvalidation(this.bookings1, "First Booking");
        this.testInvalidation(this.bookings2, "Second Booking");
        this.testInvalidation(this.result, "Result Aspect");
        this.testInvalidation(this.flightKeys, "Key Aspect of Result");
        this.testInvalidation(this.flightsDetail, "Details of result");
        this.testInvalidation(rowBookings1, "First Booking");
        this.testInvalidation(rowflight, "result Aspect");
        this.testInvalidation(rowDetails, "details of result");
        this.verify(this.query.getResult() == null, "Query result after invalidation should be null");
    }

    public void testExplicitInvalidationOfRootAspect() {
        IAspectRow rowBookings1 = this.bookings11.getAspectRow(0);
        IAspectRow rowflight = this.flightKeys1.getAspectRow(this.flightKeys1.size() - 1);
        IAspectRow rowDetails = this.flightsDetail1.getAspectRow(0);
        this.flightKeys1.invalidate();
        this.testInvalidation(this.bookings11, "First Booking");
        this.testInvalidation(this.bookings12, "Second Booking");
        this.testInvalidation(this.flightKeys1, "Key Aspect (root of cache)");
        this.testInvalidation(this.flightsDetail1, "Details of flights");
        this.testInvalidation(rowBookings1, "First Booking");
        this.testInvalidation(rowflight, "Key Aspect (root of cache)");
        this.testInvalidation(rowDetails, "details of flights");
    }

    public void testExplicitInvalidationOfAspect() {
        this.flightsDetail.invalidate();
        this.testInvalidation(this.flightsDetail, "Flights Detail");
        this.flightKeys.invalidate();
        this.testInvalidation(this.bookings1, "Bookings1");
        this.testInvalidation(this.bookings2, "Bookings2");
        this.result.invalidate();
        this.testInvalidation(this.result, "query result");
    }

    public void testSimpleRefresh() {
        int noOfRows = this.flightsDetail.size();
        this.flightsDetail.refresh();
        this.verify(this.flightsDetail.size() == noOfRows, "Number of Rows should be " + noOfRows + " but is " + this.flightsDetail.size());
    }

    private void testInvalidation(IAspect aspect, String flopString) {
        this.verify(!aspect.isValid(), flopString + " is not invalidated");
        try {
            this.verify(!aspect.isEmpty(), flopString + " is an empty Aspect");
            this.flop(flopString + " is not invalidated");
        }
        catch (Throwable e) {
            this.verify(e instanceof IllegalStateException, "Expected Throwable is not of type 'IllegalAccessException' but:" + e.getClass());
        }
    }

    private void testInvalidation(IAspectRow aspectRow, String flopString) {
        this.verify(!aspectRow.isValid(), "AspectRow of " + flopString + " is not invalidated");
        try {
            this.verify(aspectRow.getAttributeValue(0) != null, "Field with index 0 of AspectRow of " + flopString + " is null");
            this.flop("AspectRow of " + flopString + " is not invalidated");
        }
        catch (Throwable e) {
            this.verify(e instanceof IllegalStateException, "Expected Throwable is not of type 'IllegalAccessException' but:" + e.getClass());
        }
    }
}

