/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.col.client.generic.api.IAction;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;

public class TestCrossAspectAction
extends Test {
    IServiceFacade sf;
    IServiceModule refServiceModule2;
    IAspect testAspect;
    IAspect result;

    public void prepare() {
        this.sf = TestUtils.prepare(this);
        this.refServiceModule2 = this.sf.getServiceModule("COL_REF_IMPLEMENTATION_2");
        IQuery query = this.refServiceModule2.createQuery("START");
        query.execute();
        this.result = query.getResultAspect();
        this.testAspect = this.result.getAspectRow(0).getRelatedAspect("SAME_DATA1");
        this.sf.flush();
    }

    public void cleanUp() {
        this.sf.closeConnection();
    }

    public static void adjustTestAttributes(IJverTestAttributes attributes) {
        TestUtils.adjustTestAttributes(attributes);
    }

    public void testPreconditions() {
        this.verify(this.refServiceModule2 != null, "COL_REF_IMPLEMENTATION_2 ServiceModule could not be created!");
        this.verify(this.testAspect.size() > 0, "Size of testAspect must not be 0!");
    }

    public void testCrossAspectAction1() {
        IAction crossAspectAction = this.testAspect.createAction("DUMMY_AKTION");
        crossAspectAction.getInputKeyList().add(this.testAspect.getAspectRow(0).getKey());
        crossAspectAction.execute();
        this.sf.flush();
    }

    public void testCrossAspectAction2() {
        IAction crossAspectAction = this.testAspect.createAction("DUMMY_AKTION");
        crossAspectAction.getInputKeyList().add(this.testAspect.getAspectRow(0).getKey());
        crossAspectAction.setRelationTargetKey(this.result.getAspectRow(0).getKey());
        crossAspectAction.execute();
        this.sf.flush();
    }
}

