/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.col.client.generic.api.IAction;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;

public class TestAction
extends Test {
    IServiceFacade sf;
    IServiceModule refServiceModule;
    private static final String QUERY_ACTIONS = "REF_QUERY_ACTIONS";
    static boolean resetDB = true;

    public void prepare() {
        this.sf = TestUtils.prepare(this);
        if (resetDB) {
            TestUtils.resetDBRefServiceModule(this.sf);
            resetDB = false;
        }
        this.refServiceModule = this.sf.getServiceModule("COL_REF_IMPLEMENTATION");
    }

    public void cleanUp() {
        this.sf.closeConnection();
    }

    public static void adjustTestAttributes(IJverTestAttributes attributes) {
        TestUtils.adjustTestAttributes(attributes);
    }

    public void testPreconditions() {
        this.verify(this.refServiceModule != null, "COL_REF_IMPLEMENTATION ServiceModule could not be created!");
    }

    public void testSimpleAction() {
        IAspect refAspect = this.refServiceModule.createAspect("SCOL_REF_DETAIL");
        IQuery queryActions = this.refServiceModule.createQuery(QUERY_ACTIONS);
        queryActions.execute();
        int noOfActionsBefore = queryActions.getResult().size();
        this.verify(noOfActionsBefore >= 0, "Action Database should be greater or equal 0, but has size: " + queryActions.getResult().size());
        IAction actionRefDetail = refAspect.createAction("COL_REF_DETAIL");
        actionRefDetail.execute();
        this.sf.flush();
        queryActions.execute();
        this.verify(queryActions.getResult().size() == noOfActionsBefore + 1, "Action Database should have size " + (noOfActionsBefore + 1) + " but has size: " + queryActions.getResult().size());
    }

    public void testCreateAction() {
        IAspect refAspect = this.refServiceModule.createAspect("SCOL_REF_DETAIL");
        IAction actionCreate = refAspect.createAction("COL_REF_CREATE");
        IStructure inputStructure = actionCreate.getInputParameterStructure();
        String[] keyFields = new String[]{"0000000200", "0000000200", "0000000200"};
        IKey insertedKey = this.refServiceModule.createKey("SCOL_REF_KEY", keyFields);
        int i = 0;
        while (i < keyFields.length) {
            inputStructure.setAttributeValue(i, (Object)keyFields[i]);
            ++i;
        }
        actionCreate.execute();
        this.sf.flush();
        this.sf.save();
        IKey key = this.refServiceModule.createKey("SCOL_REF_KEY", keyFields);
        IAspectRow newRow = refAspect.getAspectRow(key);
        this.verify(newRow != null, "no new Row created with Key: " + key);
        IKeyList keyList = this.refServiceModule.createKeyList("SCOL_REF_KEY");
        keyList.add(key);
        IAspect aspectForNewRow = this.refServiceModule.getAspect("SCOL_REF_DETAIL", keyList);
        this.verify(aspectForNewRow.size() == 1, "Selected Aspect with new Row should have size 1, but has: " + aspectForNewRow.size());
        this.verify(insertedKey.equals(aspectForNewRow.getAspectRow(0).getKey()), "Key of inserted row: " + aspectForNewRow.getAspectRow(0).getKey() + "differs from expected Key: " + insertedKey);
    }

    public void testCreateCopyAction() {
        IAspect refAspect = this.refServiceModule.createAspect("SCOL_REF_DETAIL");
        IAction actionCreate = refAspect.createAction("COL_REF_CREATE_COPY");
        IStructure inputStructure = actionCreate.getInputParameterStructure();
        int i = 0;
        while (i < 3) {
            inputStructure.setAttributeValue(i, (Object)"0000000400");
            ++i;
        }
        String[] keyFields = new String[]{"0000000004", "0000000004", "0000000004"};
        IKey keyOfOriginalRow = this.refServiceModule.createKey("SCOL_REF_KEY", keyFields);
        IKeyList keyList = actionCreate.getInputKeyList();
        keyList.add(keyOfOriginalRow);
        actionCreate.execute();
        this.sf.flush();
        this.sf.save();
        IKey newKey = this.refServiceModule.createKey("SCOL_REF_KEY", new String[]{"0000000400", "0000000400", "0000000400"});
        IAspectRow newRow = refAspect.getAspectRow(newKey);
        this.verify(newRow != null, "no new Row created with Key: " + newKey);
        IKeyList newKeyList = this.refServiceModule.createKeyList("SCOL_REF_KEY");
        newKeyList.add(newKey);
        newKeyList.add(keyOfOriginalRow);
        IAspect aspectForNewRow = this.refServiceModule.getAspect("SCOL_REF_DETAIL", newKeyList);
        this.verify(aspectForNewRow.size() == 2, "Selected Aspect with new Row should have size 2, but has: " + aspectForNewRow.size());
        IAspectRow originalRow = aspectForNewRow.getAspectRow(keyOfOriginalRow);
        IAspectRow copiedRow = aspectForNewRow.getAspectRow(newKey);
        int i2 = 3;
        while (i2 < aspectForNewRow.getDescriptor().getStructure().size()) {
            this.verify(originalRow.getAttributeAsString(i2).equals(copiedRow.getAttributeAsString(i2)), "Attribute value '" + copiedRow.getAttributeAsString(i2) + "' of copied AspectRow doesn't correspond to value '" + originalRow.getAttributeAsString(i2) + "' of original AspectRow");
            ++i2;
        }
    }

    public void testCrossAspectActionError() {
        IAspect refAspect = this.refServiceModule.createAspect("SCOL_REF_DETAIL");
        IAction actionCreate = refAspect.createAction("COL_REF_CREATE");
        IStructure inputStructure = actionCreate.getInputParameterStructure();
        String[] keyFields = new String[]{"0000000200", "0000000200", "0000000200"};
        IKey insertedKey = this.refServiceModule.createKey("SCOL_REF_KEY", keyFields);
        int i = 0;
        while (i < keyFields.length) {
            inputStructure.setAttributeValue(i, (Object)keyFields[i]);
            ++i;
        }
        try {
            actionCreate.setRelationTargetKey(insertedKey);
            this.verify(false, "Expected Exception IllegalArgumentException wasn't thrown");
        }
        catch (Throwable e) {
            this.verify(e instanceof IllegalArgumentException, "Caught Exception is not of type IllegalArgumentException but:" + e.getClass().getName());
        }
    }
}

