/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.api.IValueSetDescriptor;

public class ShowMetaData {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: ShowMetaData <systemname> <serviceModule>");
            System.out.println("Example: ShowMetaData B3U CL_SCOOL_SFLIGHT");
        }
        System.out.println("=> Displaying Meta data starting");
        System.out.println("Used Backend: " + args[0]);
        IServiceFacade sf = TestUtils.createServiceFacade(args[0]);
        sf.initLocalLogging();
        IServiceModuleDescriptor serviceModuleDescriptor = sf.getServiceModuleDescriptor(args[1]);
        System.out.println("Service Module found: " + serviceModuleDescriptor.getName());
        System.out.println("Overview of Meta Data: ");
        IAspectDescriptor[] aspectDescr = serviceModuleDescriptor.getAspectDescriptors();
        System.out.println("-----------------------------Aspects---------------------------------------");
        int i = 0;
        while (i < aspectDescr.length) {
            TestUtils.dump(aspectDescr[i]);
            IRelationDescriptor[] relations = aspectDescr[i].getRelationDescriptors();
            System.out.println("Number of Relations for Aspect " + relations.length);
            int j = 0;
            while (j < relations.length) {
                System.out.println("<Relation name = " + relations[j].getName() + " cardinality = " + relations[j].getAttributeTargetCardinality() + ">");
                ++j;
            }
            IAspectActionDescriptor[] actions = aspectDescr[i].getAspectActionDescriptors();
            System.out.println("Number of Actions for Aspect " + actions.length);
            int j2 = 0;
            while (j2 < actions.length) {
                System.out.println("<Action name = " + actions[j2].getName() + ">");
                ++j2;
            }
            int noOfValueSets = 0;
            IStructureDescriptor structureDescriptor = aspectDescr[i].getStructure();
            int j3 = 0;
            while (j3 < structureDescriptor.size()) {
                IValueSetDescriptor valueSetDescriptor = aspectDescr[i].getValueSetDescriptor(structureDescriptor.getFieldDescriptor(j3).getName());
                if (valueSetDescriptor != null) {
                    ++noOfValueSets;
                    System.out.println("ValueSet for Field: " + structureDescriptor.getFieldDescriptor(j3).getName());
                }
                ++j3;
            }
            System.out.println("Existing Insert Relation for Aspect " + aspectDescr[i].getAttributeInsertRelation());
            System.out.println("Existing ValueSets for Aspect " + noOfValueSets);
            System.out.println("-----------------------------------------------------------------------------");
            ++i;
        }
        IQueryDescriptor[] queryDescr = serviceModuleDescriptor.getQueryDescriptors();
        System.out.println("-----------------------------Queries-----------------------------------------");
        int i2 = 0;
        while (i2 < queryDescr.length) {
            TestUtils.dump(queryDescr[i2]);
            System.out.println("-----------------------------------------------------------------------------");
            ++i2;
        }
        IKeyAspectDescriptor[] keyDescrs = serviceModuleDescriptor.getKeyAspectDescriptors();
        System.out.println("-----------------------------Keys-----------------------------------------");
        int i3 = 0;
        while (i3 < keyDescrs.length) {
            TestUtils.dump(keyDescrs[i3]);
            IAspectDescriptor[] aspects = keyDescrs[i3].getAspectDescriptors();
            System.out.println("Number of related Aspects " + aspects.length);
            int j = 0;
            while (j < aspects.length) {
                System.out.println("<Aspect name = " + aspects[j].getName() + ">");
                ++j;
            }
            IRelationDescriptor[] relations = keyDescrs[i3].getRelationDescriptors();
            System.out.println("Number of Relations for Key " + relations.length);
            int j4 = 0;
            while (j4 < relations.length) {
                System.out.println("<Relation name = " + relations[j4].getName() + ">");
                ++j4;
            }
            System.out.println("-----------------------------------------------------------------------------");
            ++i3;
        }
    }
}

