/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.col.cds.ConnectionData;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.core.GCPRuntimeException;
import com.sap.tc.col.client.generic.core.LockCache;
import com.sap.tc.col.client.generic.core.MessageList;
import com.sap.tc.col.client.generic.core.ServiceModule;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.servicemanager.api.ISrvMgrCallbackOnFlush;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessageProvider;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.ServiceManagerFactory;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.PropertiesConfigurator;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class ServiceFacade
implements IServiceFacade,
ISrvMgrCallbackOnFlush {
    private static final Location logger = Location.getLocation((Class)(class$com$sap$tc$col$client$generic$core$ServiceFacade == null ? (class$com$sap$tc$col$client$generic$core$ServiceFacade = ServiceFacade.class$("com.sap.tc.col.client.generic.core.ServiceFacade")) : class$com$sap$tc$col$client$generic$core$ServiceFacade));
    private ISrvMgrServiceManager serviceManager;
    private final LockCache lockCache = new LockCache();
    private HashMap serviceModules = new HashMap();
    private Map serviceModuleImplementations = new HashMap();
    private static Class[] SERVICE_MODULE_CTOR_SIGNATURE;
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$core$ServiceFacade;
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$core$ServiceModule;
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$api$IServiceFacade;
    static /* synthetic */ Class class$com$sap$tc$col$servicemanager$api$ISrvMgrServiceModule;

    public ServiceFacade(ConnectionData connectionData, Locale locale) {
        this.defineServiceModuleDefaultImpl(class$com$sap$tc$col$client$generic$core$ServiceModule == null ? (class$com$sap$tc$col$client$generic$core$ServiceModule = ServiceFacade.class$("com.sap.tc.col.client.generic.core.ServiceModule")) : class$com$sap$tc$col$client$generic$core$ServiceModule);
        this.init(connectionData, locale);
    }

    private ISrvMgrServiceManager getServiceManager() {
        if (this.serviceManager == null) {
            throw new IllegalStateException("Connection to backend could not be built or is closed");
        }
        return this.serviceManager;
    }

    protected LockCache getLockCache() {
        return this.lockCache;
    }

    protected void init(ConnectionData connectionData, Locale locale) {
        try {
            this.serviceManager = locale != null ? ServiceManagerFactory.createServiceManager((ConnectionData)connectionData, (Locale)locale) : ServiceManagerFactory.createServiceManager((ConnectionData)connectionData);
            this.getServiceManager().registerCallbackOnFlush((ISrvMgrCallbackOnFlush)this);
        }
        catch (Exception e) {
            logger.fatalT("service manager initialization failed");
            throw new GCPRuntimeException("service manager initialization failed", e);
        }
    }

    public String[] getServiceModuleNames() {
        if (logger.bePath()) {
            logger.pathT("entering: getServiceModuleNames");
        }
        return this.getServiceManager().getServiceModuleNames();
    }

    public IServiceModule getServiceModule(String serviceModuleName) {
        return this.getServiceModule(serviceModuleName, "");
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor(String serviceModuleName) {
        if (logger.bePath()) {
            logger.pathT("entering: getServiceModuleDescriptor", "ServiceModule name: " + serviceModuleName);
        }
        return this.getServiceManager().getServiceModule(serviceModuleName).getDescriptor();
    }

    public void flush() {
        if (logger.bePath()) {
            logger.pathT("entering: flush");
        }
        this.getServiceManager().flush("APP", "");
    }

    public boolean isDirty() {
        if (logger.bePath()) {
            logger.pathT("entering: isDirty");
        }
        Iterator it = this.serviceModules.values().iterator();
        while (it.hasNext()) {
            ((ServiceModule)it.next()).sendChanges();
        }
        return this.getServiceManager().isToSave();
    }

    public IMessageList getAllMessages() {
        return new MessageList((ISrvMgrMessageProvider)this.serviceManager, this, true);
    }

    public IMessageList getMessages() {
        return new MessageList((ISrvMgrMessageProvider)this.serviceManager, this, false);
    }

    public IMessageList getAndClearSystemMessages() {
        return new MessageList((ISrvMgrMessageProvider)this.serviceManager, this, false);
    }

    public void cleanup() {
        if (logger.bePath()) {
            logger.pathT("entering: cleanup");
        }
        this.getServiceManager().cleanup();
        this.lockCache.removeAllLocks();
        this.lockCache.clearChangedAspectRows();
    }

    public boolean save() {
        if (logger.bePath()) {
            logger.pathT("entering: save");
        }
        if (this.getServiceManager().save()) {
            this.lockCache.removeAllLocks();
            this.lockCache.clearChangedAspectRows();
            return true;
        }
        return false;
    }

    public boolean check() {
        if (logger.bePath()) {
            logger.pathT("entering: check");
        }
        return this.getServiceManager().check();
    }

    public void initLocalLogging() {
        Properties loggingProperties = new Properties();
        try {
            loggingProperties.load((class$com$sap$tc$col$client$generic$core$ServiceFacade == null ? (class$com$sap$tc$col$client$generic$core$ServiceFacade = ServiceFacade.class$("com.sap.tc.col.client.generic.core.ServiceFacade")) : class$com$sap$tc$col$client$generic$core$ServiceFacade).getResourceAsStream("logging.properties"));
            new PropertiesConfigurator(loggingProperties).configure();
        }
        catch (Exception ex) {
            System.err.println("ServiceFacade: Could not load default logging configuration for GCP.");
            ex.printStackTrace(System.err);
        }
    }

    public void setDebug(boolean enabled, String serviceModuleName, String guiHost) {
        if (logger.bePath()) {
            logger.pathT("entering: setDebug");
        }
        this.getServiceManager().setDebug(enabled, serviceModuleName, guiHost);
    }

    public void defineServiceModuleDefaultImpl(Class clazz) {
        if (clazz == null) {
            throw new GCPRuntimeException("default implementation class must not be null");
        }
        this.defineServiceModuleImpl0(null, clazz);
    }

    public void defineServiceModuleImpl(String serviceModuleName, Class clazz) {
        if (serviceModuleName == null || serviceModuleName.length() == 0) {
            throw new IllegalArgumentException("service modul name must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("implementation class must not be null");
        }
        this.defineServiceModuleImpl0(serviceModuleName, clazz);
    }

    private void defineServiceModuleImpl0(String serviceModuleName, Class clazz) {
        if (!(class$com$sap$tc$col$client$generic$core$ServiceModule == null ? (class$com$sap$tc$col$client$generic$core$ServiceModule = ServiceFacade.class$("com.sap.tc.col.client.generic.core.ServiceModule")) : class$com$sap$tc$col$client$generic$core$ServiceModule).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("class " + clazz.getName() + " doesn't fulfill the contract for ServiceModule implementations");
        }
        try {
            Constructor ctor = clazz.getDeclaredConstructor(SERVICE_MODULE_CTOR_SIGNATURE);
            this.serviceModuleImplementations.put(serviceModuleName, ctor);
            logger.infoT("service module implementation " + serviceModuleName + " registered");
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("class " + clazz.getName() + " doesn't fulfill the contract for ServiceModule implementations");
        }
    }

    protected ServiceModule createServiceModule(String serviceModuleName, ISrvMgrServiceModule svrMgrServiceModule) {
        Constructor ctor = (Constructor)this.serviceModuleImplementations.get(serviceModuleName);
        if (ctor == null) {
            ctor = (Constructor)this.serviceModuleImplementations.get(null);
        }
        try {
            ServiceModule smod = (ServiceModule)ctor.newInstance(this, svrMgrServiceModule);
            logger.infoT("service module " + serviceModuleName + " created with class " + smod.getClass().getName());
            return smod;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GCPRuntimeException("failed to create service module " + serviceModuleName, e);
        }
    }

    public void afterFlush(ISrvMgrCall[] callList) {
        Iterator it = this.serviceModules.values().iterator();
        while (it.hasNext()) {
            ServiceModule serviceModule = (ServiceModule)it.next();
            serviceModule.onServiceQueueFlushed();
        }
    }

    public boolean beforeFlush(String callingLayer, String callingMethod) {
        if (logger.bePath()) {
            logger.pathT("entering: beforeFlush", "Calling Layer: {0} Calling Method: {1}", new Object[]{callingLayer, callingMethod});
        }
        if ("SMP".equals(callingLayer) && ("ISrvMgrServiceManager.cleanup()".equals(callingMethod) || "ISrvMgrServiceManager.save()".equals(callingMethod)) || "ISrvMgrServiceManager.check()".equals(callingMethod)) {
            return true;
        }
        if ("GCP".equals(callingLayer) && "ValueSet.execute".equals(callingMethod)) {
            return true;
        }
        Iterator it = this.serviceModules.values().iterator();
        while (it.hasNext()) {
            ServiceModule serviceModule = (ServiceModule)it.next();
            serviceModule.onServiceQueueWillBeFlushed();
        }
        return true;
    }

    public void closeConnection() {
        if (logger.bePath()) {
            logger.pathT("entering: closeConnection");
        }
        if (this.serviceManager != null) {
            this.serviceManager.cleanup();
            this.serviceManager.closeConnection();
            this.serviceManager = null;
        }
    }

    public IServiceModule getServiceModule(String serviceModuleName, String configuration) {
        ServiceModule serviceModule;
        if (logger.bePath()) {
            logger.pathT("entering: getServiceModule", "ServiceModule name: " + serviceModuleName + " configuration: " + configuration);
        }
        if ((serviceModule = (ServiceModule)this.serviceModules.get(serviceModuleName + configuration)) == null) {
            serviceModule = "".equals(configuration) ? this.createServiceModule(serviceModuleName, this.getServiceManager().getServiceModule(serviceModuleName)) : this.createServiceModule(serviceModuleName, this.getServiceManager().getServiceModule(serviceModuleName, configuration));
            this.serviceModules.put(serviceModuleName + configuration, serviceModule);
        }
        return serviceModule;
    }

    public String[] getServiceModuleConfigurationNames(String serviceModuleName) {
        if (logger.bePath()) {
            logger.pathT("entering: getServiceModuleConfigurationNames", "ServiceModule name: " + serviceModuleName);
        }
        return this.getServiceManager().getServiceModuleConfigurationNames(serviceModuleName);
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor(String serviceModuleName, String configuration) {
        if (logger.bePath()) {
            logger.pathT("entering: getServiceModuleDescriptor", "ServiceModule name: " + serviceModuleName + " configuration: " + configuration);
        }
        return this.getServiceManager().getServiceModule(serviceModuleName, configuration).getDescriptor();
    }

    IServiceModule getServiceModuleForAspect(String aspectName) {
        Iterator it = this.serviceModules.values().iterator();
        if (it.hasNext()) {
            IServiceModule sm = (IServiceModule)it.next();
            if (sm.getDescriptor().getAspectDescriptor(aspectName) != null) {
                // empty if block
            }
            return sm;
        }
        return null;
    }

    public void resetLockCache() {
        this.lockCache.removeAllLocks();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.client.generic.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_client_generic/java/com/sap/tc/col/client/generic/core/ServiceFacade.java#2 $");
        SERVICE_MODULE_CTOR_SIGNATURE = new Class[]{class$com$sap$tc$col$client$generic$api$IServiceFacade == null ? (class$com$sap$tc$col$client$generic$api$IServiceFacade = ServiceFacade.class$("com.sap.tc.col.client.generic.api.IServiceFacade")) : class$com$sap$tc$col$client$generic$api$IServiceFacade, class$com$sap$tc$col$servicemanager$api$ISrvMgrServiceModule == null ? (class$com$sap$tc$col$servicemanager$api$ISrvMgrServiceModule = ServiceFacade.class$("com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule")) : class$com$sap$tc$col$servicemanager$api$ISrvMgrServiceModule};
    }
}

