/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IMessage;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;

class Message
implements IMessage {
    private ISrvMgrMessage msg;
    private IServiceModule serviceModule;

    Message(ISrvMgrMessage msg, IServiceModule sm) {
        this.msg = msg;
        this.serviceModule = sm;
    }

    public int getType() {
        return this.msg.getType();
    }

    public boolean isInfo() {
        return this.msg.isInfo();
    }

    public boolean isWarning() {
        return this.msg.isWarning();
    }

    public boolean isError() {
        return this.msg.isError();
    }

    public boolean isFailed() {
        return this.msg.isFailed();
    }

    public String getCode() {
        return this.msg.getCode();
    }

    public String getText() {
        return this.msg.getText();
    }

    public Object getExtension() {
        return this.msg.getExtension();
    }

    public IAspectRow getAspectRow() {
        return null;
    }

    public String getAspectFieldName() {
        return this.msg.getAspectField();
    }

    public IKey getAspectRowKey() {
        if (this.serviceModule != null && this.msg.getCategory() == 1) {
            return this.serviceModule.createKey(this.msg.getCoolObjectKey().getAspect(), this.msg.getCoolObjectKey().getFieldValues());
        }
        return null;
    }

    public String[] getVars() {
        return this.msg.getVarsAsArray();
    }

    private String typeToString() {
        switch (this.getType()) {
            case 0: {
                return "Info";
            }
            case 1: {
                return "Warning";
            }
            case 2: {
                return "Error";
            }
        }
        return "???Undefined???";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("<Message");
        buf.append(" type=\"").append(this.typeToString()).append("\"");
        buf.append(" aspectRowKey=\"");
        if (this.getAspectRowKey() != null) {
            buf.append(this.getAspectRowKey());
        }
        buf.append("\"");
        buf.append(" text=\"").append(this.getText()).append("\"");
        buf.append(" field=\"").append(this.getAspectFieldName()).append("\"");
        buf.append(" />");
        return buf.toString();
    }

    ISrvMgrMessage getMsg() {
        return this.msg;
    }

    public String getAspectName() {
        return this.msg.getAspectName();
    }

    public boolean isAspectRowMessage() {
        return this.msg.getCategory() == 1;
    }

    public boolean isSystemMessage() {
        return this.msg.getCategory() == 2;
    }

    public boolean isSystemMessageConfirm() {
        return this.msg.getCategory() == 3;
    }
}

