/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.core.AspectRow;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.logging.Location;
import java.util.Arrays;

public class Key
implements IKey {
    private static final Location logger = Location.getLocation((Class)(class$com$sap$tc$col$client$generic$core$Key == null ? (class$com$sap$tc$col$client$generic$core$Key = Key.class$("com.sap.tc.col.client.generic.core.Key")) : class$com$sap$tc$col$client$generic$core$Key));
    private IKeyAspectDescriptor keyDescriptor;
    private String[] keyFields;
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$core$Key;

    protected Key(IKeyAspectDescriptor keyDescriptor) {
        this(keyDescriptor, null);
    }

    protected Key(IKeyAspectDescriptor keyDescriptor, String[] keyFields) {
        if (keyDescriptor == null) {
            throw new IllegalArgumentException("keyDescriptor must not be null");
        }
        int lenKey = keyDescriptor.getStructure().size();
        if (keyFields != null && keyFields.length != lenKey) {
            throw new IllegalArgumentException("number of key fields doesn't match structure of key");
        }
        this.keyDescriptor = keyDescriptor;
        if (keyFields != null) {
            this.keyFields = new String[lenKey];
            System.arraycopy(keyFields, 0, this.keyFields, 0, lenKey);
        }
    }

    protected IKeyAspectDescriptor getKeyDescriptor() {
        return this.keyDescriptor;
    }

    public boolean isLocalKey() {
        return this.keyFields == null;
    }

    public String[] getFields() {
        if (this.isLocalKey()) {
            return null;
        }
        int lenKey = this.keyFields.length;
        String[] keyFieldsCopy = new String[lenKey];
        System.arraycopy(this.keyFields, 0, keyFieldsCopy, 0, lenKey);
        return keyFieldsCopy;
    }

    protected void takeFieldsFromRow(AspectRow row) {
        if (!this.isLocalKey()) {
            throw new IllegalStateException("You can only set the fields one time!");
        }
        IStructureDescriptor structureDescriptor = this.keyDescriptor.getStructure();
        int noOfFields = structureDescriptor.size();
        this.keyFields = new String[noOfFields];
        int i = 0;
        while (i < noOfFields) {
            String fieldName = structureDescriptor.getFieldDescriptor(i).getName();
            this.keyFields[i] = row.getAttributeAsString(fieldName);
            ++i;
        }
    }

    protected String[] getKeyFields() {
        return this.keyFields;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Key)) {
            return false;
        }
        if (this.isLocalKey()) {
            return this == other;
        }
        return Arrays.equals(this.keyFields, ((Key)other).getKeyFields());
    }

    public int hashCode() {
        if (this.isLocalKey()) {
            return super.hashCode();
        }
        int hash = 1;
        int i = 0;
        while (i < this.keyFields.length) {
            hash = 31 * hash + (this.keyFields[i] == null ? 0 : this.keyFields[i].hashCode());
            ++i;
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        if (this.isLocalKey()) {
            buf.append("localKey@").append(Integer.toHexString(System.identityHashCode(this)));
        } else {
            int i = 0;
            while (i < this.keyFields.length) {
                buf.append(this.keyFields[i]);
                if (i < this.keyFields.length - 1) {
                    buf.append(", ");
                }
                ++i;
            }
        }
        buf.append("]");
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.client.generic.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_client_generic/java/com/sap/tc/col/client/generic/core/Key.java#2 $");
    }
}

