/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.core.Aspect;
import com.sap.tc.col.edo.IEdoIndexTable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class DependantAspectCache {
    private Aspect aspect;
    private IKey key;
    private Map relations;
    private Map siblingAspects;

    DependantAspectCache(Aspect aspect) {
        this.aspect = aspect;
    }

    DependantAspectCache(Aspect aspect, IKey key) {
        this.aspect = aspect;
        this.key = key;
    }

    private Map getRelations() {
        if (this.relations == null) {
            this.relations = new HashMap();
        }
        return this.relations;
    }

    protected void addRelatedAspect(String relationName, Aspect targetAspect, IEdoIndexTable indexTable) {
        Relation relation = new Relation(relationName, targetAspect, indexTable);
        this.getRelations().put(relationName, relation);
        targetAspect.setCallingAspect(this.aspect);
        if (this.key != null) {
            targetAspect.setCallingAspectRowKey(this.key);
        }
    }

    protected void removeRelatedAspect(String relationName) {
        this.getRelations().remove(relationName);
    }

    protected Aspect getRelatedAspect(String relationName) {
        Relation relation = (Relation)this.getRelations().get(relationName);
        if (relation != null) {
            return relation.targetAspect;
        }
        return null;
    }

    protected IEdoIndexTable getIndexTable(String relationName) {
        Relation relation = (Relation)this.getRelations().get(relationName);
        if (relation != null) {
            return relation.indexTable;
        }
        return null;
    }

    protected void setIndexTable(String relationName, IEdoIndexTable indexTable) {
        Relation relation = (Relation)this.getRelations().get(relationName);
        if (relation != null) {
            relation.indexTable = indexTable;
        }
    }

    private Map getSiblingAspects() {
        if (this.siblingAspects == null) {
            this.siblingAspects = new HashMap();
        }
        return this.siblingAspects;
    }

    protected void addSiblingAspect(String aspectName, Aspect sibling) {
        this.getSiblingAspects().put(aspectName, sibling);
        sibling.setCallingAspect(this.aspect);
        if (this.key != null) {
            sibling.setCallingAspectRowKey(this.key);
        }
    }

    protected void removeSiblingAspect(Aspect sibling) {
        this.getSiblingAspects().remove(sibling.getName());
    }

    protected Aspect getSiblingAspect(String aspectName) {
        return (Aspect)this.getSiblingAspects().get(aspectName);
    }

    void invalidate() {
        Iterator it = this.getRelations().values().iterator();
        while (it.hasNext()) {
            Relation relation = (Relation)it.next();
            relation.targetAspect.invalidateInternal();
        }
        this.getRelations().clear();
        it = this.getSiblingAspects().values().iterator();
        while (it.hasNext()) {
            Aspect siblingAspect = (Aspect)it.next();
            siblingAspect.invalidateInternal();
        }
        this.getSiblingAspects().clear();
    }

    void refresh() {
        Aspect[] aspectsToRefresh = this.getRelatedAspects();
        int i = 0;
        while (i < aspectsToRefresh.length) {
            if (aspectsToRefresh[i].getState() != 4 && aspectsToRefresh[i].getState() != 6) {
                aspectsToRefresh[i].refresh();
            }
            ++i;
        }
    }

    Aspect[] getRelatedAspects() {
        Map.Entry entry;
        Aspect[] aspects = new Aspect[this.getRelations().size() + this.getSiblingAspects().size()];
        Iterator it = this.getRelations().entrySet().iterator();
        int counter = 0;
        while (it.hasNext()) {
            entry = it.next();
            Relation relation = (Relation)entry.getValue();
            aspects[counter++] = relation.targetAspect;
        }
        it = this.getSiblingAspects().entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            aspects[counter++] = (Aspect)entry.getValue();
        }
        return aspects;
    }

    private class Relation {
        private String roleName;
        private Aspect targetAspect;
        private IEdoIndexTable indexTable;

        private Relation(String roleName, Aspect targetAspect, IEdoIndexTable indexTable) {
            this.roleName = roleName;
            this.targetAspect = targetAspect;
            this.indexTable = indexTable;
        }
    }
}

