/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.generic.core.Aspect;
import com.sap.tc.col.client.generic.core.AspectRow;
import com.sap.tc.col.client.generic.core.GenericClientUtils;
import com.sap.tc.col.client.generic.core.Key;
import com.sap.tc.col.client.generic.core.KeyList;
import com.sap.tc.col.client.generic.core.ServiceModule;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrAction;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrAspectCall;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrDelete;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrInsert;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrLock;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrUnlock;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrUpdateField;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrUpdateRow;
import com.sap.tc.logging.Location;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class AspectChanges {
    private static final Location logger = Location.getLocation((Class)(class$com$sap$tc$col$client$generic$core$AspectChanges == null ? (class$com$sap$tc$col$client$generic$core$AspectChanges = AspectChanges.class$("com.sap.tc.col.client.generic.core.AspectChanges")) : class$com$sap$tc$col$client$generic$core$AspectChanges));
    private final Aspect aspect;
    private ISrvMgrInsert[] insertCall;
    private int[] insertedRowIndices;
    private ISrvMgrAspectCall updateCall;
    private int[] updatedRowIndices;
    private ISrvMgrDelete deleteCall;
    private ArrayList actionCalls;
    private KeyList deletedKeyList;
    private Map updatedRows = new HashMap();
    private ArrayList insertedRows = new ArrayList();
    private Map insertedRelatedRows = new HashMap();
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$core$AspectChanges;

    AspectChanges(Aspect aspect) {
        this.aspect = aspect;
    }

    void registerAction(ISrvMgrAction actionCall, IKeyList inputKeyList) {
        if (this.actionCalls == null) {
            this.actionCalls = new ArrayList();
        }
        if (this.aspect.getAffectsParameter(actionCall.getAspectActionDescriptor().getName()) != 0 && inputKeyList != null) {
            int i = 0;
            while (i < inputKeyList.size()) {
                AspectRow row = (AspectRow)this.aspect.getAspectRow(inputKeyList.getKey(i));
                if (row != null) {
                    row.setState(2);
                }
                ++i;
            }
            this.aspect.setState(3);
        }
        this.actionCalls.add(actionCall);
    }

    void registerInsert(AspectRow aspectRow) {
        if (logger.bePath()) {
            logger.pathT("entering: registerInsert");
        }
        if (aspectRow == null) {
            throw new IllegalArgumentException("Key of AspectRow '" + this.aspect.getName() + "' is null!");
        }
        aspectRow.setState(2);
        this.insertedRows.add(aspectRow.getKey());
    }

    void registerInsertRelation(AspectRow aspectRow, IKey sourceKey) {
        if (logger.bePath()) {
            logger.pathT("entering: registerInsertRelation", "relatedKey: " + sourceKey);
        }
        if (aspectRow == null || sourceKey == null) {
            throw new IllegalArgumentException("Key of AspectRow '" + this.aspect.getName() + "' is null or Key of sourceAspect!");
        }
        aspectRow.setState(2);
        this.insertedRelatedRows.put(aspectRow.getKey(), sourceKey);
    }

    void registerUpdate(IKey key, String fieldName) {
        if (logger.bePath()) {
            logger.pathT("entering: registerUpdate", "Key: " + key);
        }
        if (key == null) {
            throw new IllegalArgumentException("Key of AspectRow '" + this.aspect.getName() + "' is null!");
        }
        IStructureDescriptor structureDescriptor = this.aspect.getDescriptor().getStructure();
        if (this.insertedRows.contains(key)) {
            return;
        }
        int index = structureDescriptor.getFieldIndex(fieldName);
        if (index < 0) {
            throw new IllegalArgumentException("Illegal field name '" + fieldName + "'");
        }
        BitSet changedFields = (BitSet)this.updatedRows.get(key);
        if (changedFields == null) {
            changedFields = new BitSet(structureDescriptor.size());
            this.updatedRows.put(key, changedFields);
        }
        changedFields.set(index);
    }

    void reset() {
        this.deletedKeyList = null;
        this.updatedRows.clear();
        this.insertedRows.clear();
        this.insertedRelatedRows.clear();
        this.actionCalls = null;
    }

    private void resetUpdates(int[] rows) {
        int i = 0;
        while (i < rows.length) {
            AspectRow row = (AspectRow)this.aspect.getAspectRow(rows[i]);
            row.setState(0);
            row.setFlushedChangesInTransaction(true);
            this.updatedRows.remove(row.getKey());
            ++i;
        }
    }

    private void resetInsert(IKey key) {
        AspectRow row = (AspectRow)this.aspect.getAspectRow(key);
        row.setState(0);
        row.setFlushedChangesInTransaction(true);
        ((AbstractCollection)this.insertedRows).remove(key);
        this.insertedRelatedRows.remove(key);
    }

    void registerDelete(AspectRow row) {
        Key key;
        if (logger.bePath()) {
            logger.pathT("entering: registerDelete", "relatedKey: " + row.getKey());
        }
        if (this.insertedRows.contains(key = (Key)row.getKey())) {
            ((AbstractCollection)this.insertedRows).remove(key);
            if (this.isEmpty()) {
                this.aspect.setState(0);
            }
            return;
        }
        BitSet fields = (BitSet)this.updatedRows.get(key);
        if (fields != null) {
            this.updatedRows.remove(key);
        }
        if (this.deletedKeyList == null) {
            this.deletedKeyList = new KeyList(key.getKeyDescriptor());
        }
        if (!this.deletedKeyList.contains(key)) {
            this.deletedKeyList.add(key);
            row.setFlushedChangesInTransaction(true);
        }
        this.aspect.setState(2);
    }

    private int[] getInsertedAspectRows() {
        Iterator it = ((AbstractList)this.insertedRows).iterator();
        int[] indexArray = new int[this.insertedRows.size()];
        int i = 0;
        while (it.hasNext()) {
            AspectRow row = (AspectRow)this.aspect.getAspectRow((IKey)it.next());
            indexArray[i++] = row.getIndex();
        }
        return indexArray;
    }

    private IKey getRelatedInsertedKey(int index) {
        if (this.insertedRelatedRows.isEmpty()) {
            return null;
        }
        IKey key = (IKey)this.insertedRows.get(index);
        return (IKey)this.insertedRelatedRows.get(key);
    }

    private int[] getChangedAspectRows() {
        Iterator it = this.updatedRows.keySet().iterator();
        int[] indexArray = new int[this.updatedRows.keySet().size()];
        int i = 0;
        while (it.hasNext()) {
            AspectRow row = (AspectRow)this.aspect.getAspectRow((IKey)it.next());
            this.checkLockStrategyAndLocks(row);
            indexArray[i++] = row.getIndex();
        }
        return indexArray;
    }

    private void checkLockStrategyAndLocks(AspectRow row) {
        if (row == null) {
            return;
        }
        if (row.getLockStateInternal().getLockStrategy() == LockStrategy.SHARED_PROMOTABLE_WITH_LOCK_PROMOTION_ON_UPDATE && !row.getLockStateInternal().hasLock()) {
            throw new IllegalStateException("AspectRow " + row.getKey() + ": promotion to Exclusive lock failed! (strategy=SHARED_PROMOTABLE_WITH_LOCK_PROMOTION_ON_UPDATE)");
        }
        if (row.getLockStateInternal().getLockStrategy() == LockStrategy.SHARED_WITH_EXCLUSIVE_LOCK_ON_UPDATE && !row.getLockStateInternal().hasExclusiveLock()) {
            throw new IllegalStateException("AspectRow " + row.getKey() + ": promotion to Exclusive lock failed! (strategy=SHARED_WITH_LOCK_PROMOTION_ON_UPDATE)");
        }
    }

    boolean isEmpty() {
        return (this.deletedKeyList == null || this.deletedKeyList.isEmpty()) && this.updatedRows.isEmpty() && this.insertedRows.isEmpty();
    }

    private Set getCalledActions() {
        HashSet<String> calledActions = new HashSet<String>();
        if (this.insertedRows.size() > 0) {
            calledActions.add("INSERT");
        }
        if (this.updatedRows.size() > 0) {
            if (this.updateCall instanceof ISrvMgrUpdateRow) {
                calledActions.add("UPDATE");
            } else {
                calledActions.add("UPDATE_FIELDS");
            }
        }
        if (this.deletedKeyList != null) {
            calledActions.add("DELETE");
        }
        if (this.actionCalls != null) {
            Iterator it = ((AbstractList)this.actionCalls).iterator();
            while (it.hasNext()) {
                ISrvMgrAction action = (ISrvMgrAction)it.next();
                calledActions.add(action.getAspectActionDescriptor().getName());
            }
        }
        return calledActions;
    }

    int getActualAffectsParameter() {
        Set changes = this.getCalledActions();
        int affects = 0;
        Iterator it = changes.iterator();
        Map invalidationHints = this.aspect.getInvalidationHints();
        while (it.hasNext()) {
            String actionName = (String)it.next();
            Integer actionAffects = (Integer)invalidationHints.get(actionName);
            if (actionAffects == 3) {
                return 3;
            }
            if (actionAffects == 2) {
                affects = 2;
            }
            if (actionAffects != 1 || affects == 2) continue;
            affects = 1;
        }
        return affects;
    }

    void sendChanges() {
        this.updatedRowIndices = this.getChangedAspectRows();
        ServiceModule serviceModule = (ServiceModule)this.aspect.getServiceModule();
        if (this.updatedRowIndices.length > 0) {
            if (!this.aspect.isFieldWiseChange()) {
                ISrvMgrUpdateRow updateRowCall = serviceModule.getSrvMgrServiceModule().createUpdateRow(this.aspect.getName());
                this.aspect.getWrappedEdoTable().getTable(this.updatedRowIndices, updateRowCall.getInRecords());
                this.updateCall = updateRowCall;
            } else {
                ISrvMgrUpdateField updateFieldCall = serviceModule.getSrvMgrServiceModule().createUpdateField(this.aspect.getName());
                this.aspect.getWrappedEdoTable().getTable(this.updatedRowIndices, updateFieldCall.getInRecords());
                GenericClientUtils.copyKeysAndFieldsToCall(this.aspect, this.updatedRows, updateFieldCall.getInFields());
                this.updateCall = updateFieldCall;
            }
            serviceModule.registerSrvMgrCallObject((ISrvMgrCall)this.updateCall, this.aspect);
            logger.infoT("sendChanges", "Update: updated AspectRows : " + this.updatedRowIndices.length);
        }
        if (this.deletedKeyList != null && !this.deletedKeyList.isEmpty()) {
            int i = 0;
            while (i < this.deletedKeyList.size()) {
                this.checkLockStrategyAndLocks((AspectRow)this.aspect.getAspectRow(this.deletedKeyList.getKey(i)));
                ++i;
            }
            this.deleteCall = serviceModule.getSrvMgrServiceModule().createDelete(this.aspect.getName());
            GenericClientUtils.copyFromKeyListToTable(this.deletedKeyList, this.deleteCall.getInKeys());
            serviceModule.registerSrvMgrCallObject((ISrvMgrCall)this.deleteCall, this.aspect);
            logger.infoT("sendChanges", "deleted AspectRows : " + this.deletedKeyList.size());
        }
        this.insertedRowIndices = this.getInsertedAspectRows();
        if (this.insertedRowIndices.length > 0) {
            this.insertCall = new ISrvMgrInsert[this.insertedRowIndices.length];
            int i = 0;
            while (i < this.insertedRowIndices.length) {
                this.insertCall[i] = serviceModule.getSrvMgrServiceModule().createInsert(this.aspect.getName());
                this.aspect.getWrappedEdoTable().getTable(new int[]{this.insertedRowIndices[i]}, this.insertCall[i].getInRecords());
                Key relatedSourceKey = (Key)this.getRelatedInsertedKey(i);
                if (relatedSourceKey != null) {
                    GenericClientUtils.copyFromKeyToStructure(relatedSourceKey, this.insertCall[i].getRelationInKey());
                }
                serviceModule.registerSrvMgrCallObject((ISrvMgrCall)this.insertCall[i], this.aspect);
                ++i;
            }
            logger.infoT("sendChanges", "inserted AspectRows : " + this.insertedRowIndices.length);
        }
    }

    void mergeUpdatedAspectRows(IEdoTable aspectData) {
        if (logger.bePath()) {
            logger.pathT("entering: mergeUpdatedAspectRows");
        }
        if (this.updateCall == null) {
            return;
        }
        IEdoTable outRecords = this.updateCall.getOutRecords();
        logger.infoT("mergeUpdatedAspectRows", "Number of OutRecords: " + outRecords.getRecordCount());
        if (outRecords.getRecordCount() == this.updatedRowIndices.length) {
            aspectData.setTable(this.updatedRowIndices, outRecords, 0);
            int i = 0;
            while (i < this.updatedRowIndices.length) {
                this.aspect.fireElementChanged(this.aspect.getAspectRow(this.updatedRowIndices[i]), this.updatedRowIndices[i]);
                ++i;
            }
            this.resetUpdates(this.updatedRowIndices);
        } else {
            int[] rowsToUpdate = this.getUpdatedRows(this.updateCall, this.updatedRowIndices);
            if (rowsToUpdate.length > 0) {
                aspectData.setTable(rowsToUpdate, outRecords, 0);
                this.resetUpdates(rowsToUpdate);
            }
        }
        this.updateCall = null;
    }

    void mergeInsertedAspectRows(IEdoTable aspectData) {
        if (this.insertCall == null) {
            return;
        }
        int i = 0;
        while (i < this.insertedRowIndices.length) {
            IEdoTable outRecords = this.insertCall[i].getOutRecords();
            if (outRecords.getRecordCount() == 1) {
                AspectRow relatedSourceRow;
                aspectData.setTable(new int[]{this.insertedRowIndices[i]}, outRecords, 0);
                AspectRow row = (AspectRow)this.aspect.getAspectRow(this.insertedRowIndices[i]);
                Key relatedSourceKey = (Key)this.getRelatedInsertedKey(i);
                this.resetInsert(row.getKey());
                this.aspect.updateKeyMap(row, (Key)row.getKey());
                this.aspect.fireElementChanged(row, row.getIndex());
                Aspect sourceAspect = this.aspect.getCallingAspect();
                if (relatedSourceKey != null && sourceAspect != null && (relatedSourceRow = (AspectRow)sourceAspect.getAspectRow(relatedSourceKey)) != null && this.insertCall[i].getRelationOutRecord() != null) {
                    GenericClientUtils.copyFromEdoStructureToTable(this.insertCall[i].getRelationOutRecord(), sourceAspect.getWrappedEdoTable(), relatedSourceRow.getIndex());
                }
            }
            ++i;
        }
        this.insertCall = null;
    }

    void handleDeleteCall() {
        if (this.deleteCall == null) {
            return;
        }
        IEdoTable returnCodes = this.deleteCall.getReturnCodes();
        IEdoTable inKeys = this.deleteCall.getInKeys();
        IKeyList keyList = null;
        IServiceModule serviceModule = null;
        IKeyAspectDescriptor keyDescriptor = null;
        int i = 0;
        while (i < inKeys.getRecordCount()) {
            if (GenericClientUtils.isFailedRecord(returnCodes, i)) {
                int inIndex;
                if (serviceModule == null) {
                    serviceModule = this.aspect.getServiceModule();
                    keyDescriptor = this.aspect.getDescriptor().getKeyDescriptor();
                }
                if (keyList == null) {
                    keyList = serviceModule.createKeyList(keyDescriptor.getName());
                }
                if ((inIndex = returnCodes.getIntValue(i, "INRECORD")) > this.deleteCall.getInKeys().getRecordCount() || inIndex < 1) {
                    logger.warningT("handleDeleteCall", "Index: " + inIndex + " is inconsistent to inKeys Table, which has size: " + this.deleteCall.getInKeys().getRecordCount());
                } else {
                    IKey key = GenericClientUtils.getKeyFromTable(this.deleteCall.getInKeys(), keyDescriptor, inIndex - 1);
                    keyList.add(key);
                }
            }
            ++i;
        }
        this.deleteCall = null;
        this.deletedKeyList = (KeyList)keyList;
    }

    void mergeActionsToAspectRows() {
        if (this.actionCalls == null) {
            return;
        }
        Iterator it = ((AbstractList)this.actionCalls).iterator();
        while (it.hasNext()) {
            ISrvMgrAction actionCall = (ISrvMgrAction)it.next();
            this.mergeActionToAspectRows(actionCall);
        }
        this.actionCalls.clear();
    }

    private void mergeActionToAspectRows(ISrvMgrAction actionCall) {
        IEdoTable outRecords = actionCall.getOutRecords();
        logger.infoT("mergeActionToAspectRows", "Action '" + actionCall.getAspectActionDescriptor().getName() + "' , Number of OutRecords: " + outRecords.getRecordCount());
        int i = 0;
        while (i < outRecords.getRecordCount()) {
            IKey parentKey;
            IKey key = GenericClientUtils.getKeyFromTable(outRecords, this.aspect.getDescriptor().getKeyDescriptor(), i);
            AspectRow row = (AspectRow)this.aspect.getAspectRow(key);
            boolean rowCreated = false;
            if (row == null) {
                rowCreated = true;
                row = (AspectRow)this.aspect.createAspectRowForKey(key);
            }
            this.aspect.getWrappedEdoTable().setTable(new int[]{row.getIndex()}, outRecords, i);
            if (rowCreated) {
                this.aspect.fireElementAdded(row, ((AbstractList)((Object)this.aspect)).indexOf(row));
            } else {
                this.aspect.fireElementChanged(row, ((AbstractList)((Object)this.aspect)).indexOf(row));
            }
            String crossAspectRelation = actionCall.getAspectActionDescriptor().getAttributeRelation();
            if (crossAspectRelation != null && !crossAspectRelation.equals("") && actionCall.getRelationOutRecord() != null && (parentKey = this.aspect.getRelationParentKey()) != null) {
                Aspect parent = this.aspect.getCallingAspect();
                AspectRow parentRow = (AspectRow)parent.getAspectRow(parentKey);
                GenericClientUtils.copyFromEdoStructureToTable(actionCall.getRelationOutRecord(), parent.getWrappedEdoTable(), parentRow.getIndex());
            }
            row.setFlushedChangesInTransaction(true);
            ++i;
        }
        IEdoTable inKeys = actionCall.getInKeys();
        IKeyAspectDescriptor keyDescriptor = actionCall.getAspectActionDescriptor().getInputKeysDescriptor();
        int i2 = 0;
        while (inKeys != null && i2 < inKeys.getRecordCount()) {
            IKey key = GenericClientUtils.getKeyFromTable(inKeys, keyDescriptor, i2);
            AspectRow row = (AspectRow)this.aspect.getAspectRow(key);
            if (row != null) {
                row.setState(0);
                if (!GenericClientUtils.isFailedRecord(actionCall.getReturnCodes(), i2)) {
                    row.setFlushedChangesInTransaction(true);
                }
            }
            ++i2;
        }
    }

    private int[] getUpdatedRows(ISrvMgrAspectCall updateRowCall, int[] updatedRowIndices) {
        IEdoTable returnCodes = updateRowCall.getReturnCodes();
        int noOfRows = updatedRowIndices.length;
        int failedRows = 0;
        int i = 0;
        while (i < returnCodes.getRecordCount()) {
            boolean failed = returnCodes.getBooleanValue(i, "FAILED");
            if (failed) {
                int inIndex = returnCodes.getIntValue(i, "INRECORD");
                if (inIndex < 1 || inIndex > noOfRows) {
                    throw new IllegalStateException("inRecord index '" + inIndex + "' in returnCodes is not in the valid range [1," + noOfRows + "]");
                }
                updatedRowIndices[inIndex - 1] = -1;
                ++failedRows;
            }
            ++i;
        }
        int outRecords = updateRowCall.getOutRecords().getRecordCount();
        if (noOfRows != failedRows + outRecords) {
            throw new IllegalStateException("number of inrecords(" + noOfRows + ") is not equal number of outrecords(" + outRecords + ") plus failed records(" + failedRows + ")");
        }
        int[] newIndexArray = new int[noOfRows - failedRows];
        int j = 0;
        int i2 = 0;
        while (i2 < noOfRows) {
            if (updatedRowIndices[i2] != -1) {
                newIndexArray[j++] = updatedRowIndices[i2];
            }
            ++i2;
        }
        return newIndexArray;
    }

    KeyList getDeletedKeyList() {
        return this.deletedKeyList;
    }

    void handleLockCall(ISrvMgrLock lockCall) {
        IEdoTable inKeys = lockCall.getInKeys();
        IEdoTable returnCodes = lockCall.getReturnCodes();
        this.aspect.setState(5);
        int i = 0;
        while (i < inKeys.getRecordCount()) {
            IKey key = GenericClientUtils.getKeyFromTable(inKeys, this.aspect.getDescriptor().getKeyDescriptor(), i);
            AspectRow aspectRow = (AspectRow)this.aspect.getAspectRow(key);
            aspectRow.setState(0);
            aspectRow.getLockStateInternal().setLockResult(aspectRow, lockCall.getLockMode(), this.aspect.getLockingStrategy(), GenericClientUtils.isFailedRecord(returnCodes, i));
            ++i;
        }
        this.aspect.setState(0);
    }

    void handleUnLockCall(ISrvMgrUnlock unLockCall) {
        this.aspect.setState(5);
        IEdoTable inKeys = unLockCall.getInKeys();
        IEdoTable returnCodes = unLockCall.getReturnCodes();
        int i = 0;
        while (i < inKeys.getRecordCount()) {
            if (!GenericClientUtils.isFailedRecord(returnCodes, i)) {
                IKey key = GenericClientUtils.getKeyFromTable(inKeys, this.aspect.getDescriptor().getKeyDescriptor(), i);
                AspectRow aspectRow = (AspectRow)this.aspect.getAspectRow(key);
                aspectRow.setState(0);
                ((ServiceModule)this.aspect.getServiceModule()).getServiceFacade().getLockCache().removeLock(this.aspect.getName(), key);
            }
            ++i;
        }
        this.aspect.setState(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.client.generic.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_client_generic/java/com/sap/tc/col/client/generic/core/AspectChanges.java#1 $");
    }
}

