/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.cmi.metadata.ICMIModelObjectCollectionInfo;
import com.sap.tc.cmi.model.ICMIModel;
import com.sap.tc.cmi.util.CMIAbstractObservableList;
import com.sap.tc.col.client.generic.api.IAction;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IValueSet;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.generic.api.SortingCriteria;
import com.sap.tc.col.client.generic.core.AspectCache;
import com.sap.tc.col.client.generic.core.AspectChanges;
import com.sap.tc.col.client.generic.core.AspectRow;
import com.sap.tc.col.client.generic.core.ColModelInfo;
import com.sap.tc.col.client.generic.core.DependantAspectCache;
import com.sap.tc.col.client.generic.core.GenericClientUtils;
import com.sap.tc.col.client.generic.core.ICacheRootObject;
import com.sap.tc.col.client.generic.core.ISrvMgrCaller;
import com.sap.tc.col.client.generic.core.Key;
import com.sap.tc.col.client.generic.core.KeyList;
import com.sap.tc.col.client.generic.core.LockState;
import com.sap.tc.col.client.generic.core.MessageList;
import com.sap.tc.col.client.generic.core.Query;
import com.sap.tc.col.client.generic.core.ServiceModule;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IValueSetDescriptor;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessageProvider;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrAction;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCopyCorresponding;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrDelete;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrInsert;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrLock;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrQuery;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrSelect;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrSelectByRelation;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrUnlock;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrUpdateField;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrUpdateRow;
import com.sap.tc.logging.Location;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Aspect
extends CMIAbstractObservableList
implements IAspect,
ICacheRootObject,
ISrvMgrCaller {
    private static final Location logger = Location.getLocation((Class)(class$com$sap$tc$col$client$generic$core$Aspect == null ? (class$com$sap$tc$col$client$generic$core$Aspect = Aspect.class$("com.sap.tc.col.client.generic.core.Aspect")) : class$com$sap$tc$col$client$generic$core$Aspect));
    protected static final int CLEAN = 0;
    protected static final int HOLLOW = 1;
    protected static final int DIRTY = 2;
    protected static final int DIRTY_PENDING = 3;
    protected static final int INVALID = 4;
    protected static final int PROCESS_QUEUE_WAITING = 5;
    protected static final int REFRESH_NEEDED = 6;
    private final ICMIModelObjectCollectionInfo modelObjectCollectionInfo;
    private int state = 0;
    private final IAspectDescriptor descriptor;
    private final ArrayList aspectRows = new ArrayList();
    private HashMap aspectRowsMap = new HashMap();
    private final ServiceModule serviceModule;
    private final AspectChanges aspectChanges;
    private IEdoTable wrappedEdoTable;
    private boolean cacheRootObject = false;
    private final DependantAspectCache dependantAspectCache = new DependantAspectCache(this);
    private AspectCache aspectCache;
    private Map invalidationHints;
    private IKeyList liveKeyList = new LiveKeyList();
    private Boolean fieldWiseChange;
    private CreationPath creationPath;
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$core$Aspect;

    protected Aspect(ServiceModule serviceModule, IAspectDescriptor descriptor, ISrvMgrCall srvMgrCall) {
        if (logger.bePath()) {
            logger.pathT("entering: Aspect constructor", "Aspect name: " + descriptor.getName());
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("AspectDescriptor must not be null");
        }
        if (serviceModule == null) {
            throw new IllegalArgumentException("ServiceModule must not be null");
        }
        this.descriptor = descriptor;
        this.serviceModule = serviceModule;
        this.creationPath = new CreationPath(srvMgrCall, this);
        this.aspectChanges = new AspectChanges(this);
        this.modelObjectCollectionInfo = ((ColModelInfo)serviceModule.associatedModelInfo()).getOrCreateModelObjectCollectionInfo(descriptor);
        int n = this.state = srvMgrCall == null ? 0 : 1;
        if (this.state == 0) {
            this.wrappedEdoTable = serviceModule.getSrvMgrServiceModule().createTable(descriptor.getStructure());
        }
    }

    protected void initFromKeyList(IKeyList keyList) {
        if (logger.bePath()) {
            logger.pathT("entering: initFromKeyList(IKeyList)", "Aspect name: " + this.getName());
        }
        this.state = 5;
        if (keyList != null) {
            int i = 0;
            while (i < keyList.size()) {
                IKey key = keyList.getKey(i);
                if (!key.isLocalKey()) {
                    AspectRow keyRow = (AspectRow)this.createAspectRowForKey(key);
                    keyRow.setKeyFields((Key)key);
                }
                ++i;
            }
            this.state = 0;
        } else {
            this.wrappedEdoTable = null;
            this.state = 1;
        }
    }

    public ICMIModel associatedModel() {
        if (logger.bePath()) {
            logger.pathT("entering: associatedModel", "Model name: " + this.serviceModule.getDescriptor().getName());
        }
        return this.serviceModule;
    }

    public ICMIModelObjectCollectionInfo associatedModelObjectCollectionInfo() {
        if (logger.bePath()) {
            logger.pathT("entering: associatedModelObjectCollectionInfo");
        }
        return this.modelObjectCollectionInfo;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    protected int getState() {
        return this.state;
    }

    protected void setState(int state) {
        this.state = state;
    }

    public IAspectRow getAspectRow(IKey key) {
        if (logger.bePath()) {
            logger.pathT("entering: getAspectRow", "AspectRow Key: " + key);
        }
        return this.getAspectRow(key, (LockStrategy)null);
    }

    public IAspectRow getAspectRow(IKey key, LockStrategy lockStrategy) {
        this.handleAccessAspect(true);
        if (logger.bePath()) {
            logger.pathT("entering: getAspectRow", "AspectRow Key: " + key + " LockStrategy: " + lockStrategy);
        }
        AspectRow aspectRow = (AspectRow)this.aspectRowsMap.get(key);
        if (lockStrategy != null) {
            this.lockAndRefresh(aspectRow, lockStrategy);
        }
        return aspectRow;
    }

    public IAspectRow getAspectRow(int row) {
        return this.getAspectRow(row, (LockStrategy)null);
    }

    public IAspectRow getAspectRow(int row, LockStrategy lockStrategy) {
        if (logger.bePath()) {
            logger.pathT("entering: getAspectRow", "AspectRow Index: " + row + " LockStrategy: " + lockStrategy);
        }
        if (row < 0 || row >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        AspectRow aspectRow = (AspectRow)this.aspectRows.get(row);
        if (lockStrategy != null) {
            this.lockAndRefresh(aspectRow, lockStrategy);
        }
        return aspectRow;
    }

    public IAspectRow createAspectRow() {
        if (logger.bePath()) {
            logger.pathT("entering: createAspectRow");
        }
        this.handleAccessAspect(false);
        IKey parentKey = null;
        if (this.descriptor.getAttributeInsertRelationRequired()) {
            parentKey = this.getRelationParentKey();
        }
        Key key = new Key(this.getDescriptor().getKeyDescriptor());
        AspectRow aspectRow = this.createAspectRowInternal(this.aspectRows.size(), key);
        this.addAspectRow(aspectRow);
        if (parentKey != null) {
            this.aspectChanges.registerInsertRelation(aspectRow, parentKey);
        }
        super.fireElementAdded((Object)aspectRow, aspectRow.getIndex());
        return aspectRow;
    }

    public IAspectRow createAspectRow(IKey parentKey) {
        if (logger.bePath()) {
            logger.pathT("entering: createAspectRow", "parent Key: " + parentKey);
        }
        this.handleAccessAspect(false);
        if (!this.descriptor.getAttributeInsertRelationRequired()) {
            throw new UnsupportedOperationException("insert with relation not allowed for Aspect '" + this.getName() + "'");
        }
        if (parentKey == null && (parentKey = this.getRelationParentKey()) == null) {
            throw new IllegalArgumentException("parentKey null not allowed, cause parent key is not known implicitly!");
        }
        Key key = new Key(this.getDescriptor().getKeyDescriptor());
        AspectRow aspectRow = this.createAspectRowInternal(this.aspectRows.size(), key);
        this.addAspectRow(aspectRow);
        this.aspectChanges.registerInsertRelation(aspectRow, parentKey);
        super.fireElementAdded((Object)aspectRow, aspectRow.getIndex());
        return aspectRow;
    }

    public IAspectRow createRelatedAspectRow(IKey parentKey) {
        if (logger.bePath()) {
            logger.pathT("entering: createRelatedAspectRow", "Key of related Aspect: " + parentKey);
        }
        if (!this.descriptor.getAttributeInsertRelationRequired()) {
            throw new UnsupportedOperationException("insert with relation not allowed for Aspect '" + this.getName() + "'");
        }
        String requiredRelation = this.descriptor.getAttributeInsertRelation();
        if (requiredRelation == null || requiredRelation.equals("")) {
            throw new UnsupportedOperationException("insert with relation not allowed for Aspect '" + this.getName() + "'");
        }
        Key key = new Key(this.getDescriptor().getKeyDescriptor());
        AspectRow aspectRow = this.createAspectRowInternal(this.aspectRows.size(), key);
        this.addAspectRow(aspectRow);
        this.aspectChanges.registerInsertRelation(aspectRow, parentKey);
        super.fireElementAdded((Object)aspectRow, aspectRow.getIndex());
        return aspectRow;
    }

    protected IAspectRow createAspectRowForKey(IKey key) {
        AspectRow aspectRow = this.createAspectRowInternal(this.aspectRows.size(), (Key)key);
        this.addAspectRow(aspectRow);
        this.updateKeyMap(aspectRow, (Key)key);
        return aspectRow;
    }

    protected IAspectRow createAspectRow(int index) {
        Key key = new Key(this.getDescriptor().getKeyDescriptor());
        AspectRow aspectRow = this.createAspectRowInternal(index, key);
        this.aspectRows.add(aspectRow);
        this.aspectRowsMap.put(key, aspectRow);
        return aspectRow;
    }

    protected AspectRow createAspectRowInternal(int index, Key key) {
        return new AspectRow(this, index, key);
    }

    public boolean removeAspectRow(IAspectRow aspectRow) {
        return this.removeAspectRow(aspectRow, null);
    }

    public boolean removeAspectRow(IAspectRow aspectRow, LockStrategy lockStrategy) {
        if (logger.bePath()) {
            logger.pathT("entering: removeAspectRow", "AspectRow: " + aspectRow + " LockStrategy: " + lockStrategy);
        }
        boolean result = false;
        int index = ((AspectRow)aspectRow).getIndex();
        if (index >= 0) {
            result = this.removeAspectRowSilently(aspectRow, lockStrategy);
            super.fireElementRemoved((Object)aspectRow, index);
        }
        return result;
    }

    private boolean removeAspectRowSilently(IAspectRow aspectRow, LockStrategy lockStrategy) {
        this.handleAccessAspect(true);
        if (((AbstractCollection)((Object)this)).contains(aspectRow)) {
            if (this.state == 0) {
                ((AspectRow)aspectRow).promoteLockIfNecessary();
            }
            this.aspectRowsMap.remove(aspectRow.getKey());
            ((AbstractCollection)this.aspectRows).remove(aspectRow);
            int rowIndex = ((AspectRow)aspectRow).getIndex();
            this.wrappedEdoTable.deleteFrom(rowIndex, 1);
            if (this.state == 0 || this.state == 2) {
                this.aspectChanges.registerDelete((AspectRow)aspectRow);
            }
            int i = rowIndex;
            while (i < this.size()) {
                AspectRow row = (AspectRow)this.aspectRows.get(i);
                row.setIndex(i);
                ++i;
            }
            ((AspectRow)aspectRow).invalidateInternal();
            return true;
        }
        return false;
    }

    protected void moveAspectRow(int fromIndex, int toIndex) {
        if (toIndex < 0 || toIndex >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("parameter toIndex(" + toIndex + ") is out of bounds size = " + this.size());
        }
        if (fromIndex < 0 || fromIndex >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("parameter fromIndex(" + fromIndex + ") is out of bounds size = " + this.size());
        }
        if (fromIndex == toIndex) {
            return;
        }
        AspectRow aspectRow = (AspectRow)this.aspectRows.remove(fromIndex);
        super.fireElementRemoved((Object)aspectRow, fromIndex);
        this.aspectRows.add(toIndex, aspectRow);
        super.fireElementAdded((Object)aspectRow, toIndex);
        int min = Math.min(fromIndex, toIndex);
        int max = Math.max(fromIndex, toIndex);
        int i = min;
        while (i <= max) {
            AspectRow row = (AspectRow)this.aspectRows.get(i);
            row.setIndex(i);
            ++i;
        }
    }

    public IAction createAction(String actionName) {
        if (logger.bePath()) {
            logger.pathT("entering: createAction", "Aspect Name: " + this.getName() + " Action Name: " + actionName);
        }
        this.handleAccessAspect(true);
        IAspectActionDescriptor aspectActionDescriptor = this.descriptor.getAspectActionDescriptor(actionName);
        if (aspectActionDescriptor == null) {
            throw new IllegalArgumentException("AspectActionDescriptor for Action " + actionName + " doesn't exist");
        }
        return this.serviceModule.createActionInternal(aspectActionDescriptor, this);
    }

    public IValueSet createValueSet(String fieldName) {
        IValueSetDescriptor valueSetDescriptor;
        if (logger.bePath()) {
            logger.pathT("entering: createValueSet", "Aspect Name: " + this.getName() + " Field Name: " + fieldName);
        }
        if ((valueSetDescriptor = this.descriptor.getValueSetDescriptor(fieldName)) == null) {
            logger.fatalT("ValueSet for attribute with name '" + fieldName + "' in Aspect '" + this.getName() + "' doesn't exist!");
            throw new IllegalArgumentException("ValueSet for attribute with name '" + fieldName + "' in Aspect '" + this.getName() + "' doesn't exist!");
        }
        IValueSet newValueSet = this.serviceModule.createValueSetInternal(valueSetDescriptor);
        return newValueSet;
    }

    IRelationDescriptor getRelationDescriptorOrFail(String relationName) throws IllegalArgumentException {
        IRelationDescriptor relationDescriptor = this.descriptor.getRelationDescriptor(relationName);
        if (relationDescriptor == null) {
            if (!this.descriptor.isKeyAspect()) {
                relationDescriptor = this.descriptor.getKeyDescriptor().getRelationDescriptor(relationName);
            }
            if (relationDescriptor == null) {
                throw new IllegalArgumentException("aspect '" + this.getName() + "' or its Key has no relation with name '" + relationName + "'");
            }
        }
        return relationDescriptor;
    }

    public IAspect getRelatedAspect(String relationName) {
        return this.getRelatedAspect(relationName, (LockStrategy)null, null);
    }

    public IAspect getRelatedAspect(String relationName, LockStrategy lockStrategy) {
        return this.getRelatedAspect(relationName, lockStrategy, null);
    }

    public IAspect getRelatedAspect(String relationName, LockStrategy lockStrategy, SortingCriteria sorting) {
        Aspect targetAspect;
        if (logger.bePath()) {
            logger.pathT("entering: getRelatedAspect", "AspectName: " + this.getName() + " RelationName: " + relationName + " LockStrategy: " + lockStrategy + " Sorting: " + sorting);
        }
        if (this.state != 1) {
            this.handleAccessAspect(true);
        }
        if ((targetAspect = this.dependantAspectCache.getRelatedAspect(relationName)) != null) {
            if (lockStrategy != null) {
                if (targetAspect.getState() != 0 && targetAspect.getState() != 1) {
                    throw new IllegalStateException("Locking of aspect '" + targetAspect.getName() + "' not allowed, cause Aspect is not CLEAN or HOLLOW!");
                }
                targetAspect.lockAndRefresh(lockStrategy);
            }
            return targetAspect;
        }
        IRelationDescriptor relationDescriptor = this.getRelationDescriptorOrFail(relationName);
        String sourceAspectName = relationDescriptor.getSourceAspectDescriptor().getName();
        if (!sourceAspectName.equals(this.getName())) {
            return this.getAspect(sourceAspectName).getRelatedAspect(relationName, lockStrategy);
        }
        ISrvMgrSelectByRelation selectByRelationCall = this.serviceModule.getSrvMgrServiceModule().createSelectByRelation(sourceAspectName, relationName);
        if (this.wrappedEdoTable != null) {
            selectByRelationCall.setInRecords(this.wrappedEdoTable);
        } else {
            selectByRelationCall.setInRecords(this.getCreateAspectCall().getOutRecords());
        }
        if (lockStrategy != null) {
            int lockMode = LockState.getLockModeFromStrategy(relationDescriptor.getTargetAspectDescriptor(), lockStrategy);
            selectByRelationCall.setLockMode(lockMode);
        }
        if (sorting != null) {
            GenericClientUtils.copyFromSortingCriteriaToCall(sorting, selectByRelationCall.getInSortingOptions());
        }
        targetAspect = this.serviceModule.createAspectInCache(this.aspectCache, relationDescriptor.getTargetAspectDescriptor().getName(), (ISrvMgrCall)selectByRelationCall);
        targetAspect.setLockingStrategy(lockStrategy);
        this.serviceModule.registerSrvMgrCallObject((ISrvMgrCall)selectByRelationCall, targetAspect);
        this.dependantAspectCache.addRelatedAspect(relationName, targetAspect, selectByRelationCall.getRelations());
        return targetAspect;
    }

    public IAspect getRelatedAspect(String relationName, String targetAspectName) {
        return this.getRelatedAspect(relationName, targetAspectName, (LockStrategy)null);
    }

    public IAspect getRelatedAspect(String relationName, String targetAspectName, LockStrategy lockStrategy) {
        IRelationDescriptor relationDescriptor;
        String targetOfRelation;
        if (logger.bePath()) {
            logger.pathT("entering: getRelatedAspect", "AspectName: " + this.getName() + " RelationName: " + relationName + " target Aspect: " + targetAspectName + " LockStrategy: " + lockStrategy);
        }
        if ((targetOfRelation = (relationDescriptor = this.getRelationDescriptorOrFail(relationName)).getTargetAspectDescriptor().getName()).equals(targetAspectName)) {
            return this.getRelatedAspect(relationName, lockStrategy);
        }
        Aspect targetAspect = (Aspect)this.getRelatedAspect(relationName, (LockStrategy)null);
        return targetAspect.getAspect(targetAspectName, lockStrategy);
    }

    public IAspect getKeyAspect() {
        return this.getAspect(this.descriptor.getKeyDescriptor().getName());
    }

    public IAspect getAspect(String aspectName) {
        return this.getAspect(aspectName, null);
    }

    public IAspect getAspect(String aspectName, LockStrategy lockStrategy) {
        if (logger.bePath()) {
            logger.pathT("entering: getAspect", "AspectName: " + this.getName() + " TargetAspect: " + aspectName + " LockStrategy: " + lockStrategy);
        }
        if (this.getName().equals(aspectName)) {
            if (lockStrategy != null) {
                if (this.state != 0 && this.state != 1) {
                    throw new IllegalStateException("Locking of aspect '" + aspectName + "' not allowed, cause Aspect is not CLEAN or HOLLOW!");
                }
                this.lockAndRefresh(lockStrategy);
            }
            return this;
        }
        if (this.state != 1) {
            this.handleAccessAspect(true);
        }
        if (!this.isValidAspectName(aspectName)) {
            throw new IllegalArgumentException("No select from aspect '" + this.getName() + "' to Aspect with name '" + aspectName + "'");
        }
        Aspect resultAspect = this.dependantAspectCache.getSiblingAspect(aspectName);
        if (resultAspect != null) {
            if (lockStrategy != null) {
                if (resultAspect.getState() != 0 && resultAspect.getState() != 1) {
                    throw new IllegalArgumentException("Locking of aspect '" + aspectName + "' not allowed, cause Aspect is not CLEAN or HOLLOW!");
                }
                resultAspect.lockAndRefresh(lockStrategy);
            }
            return resultAspect;
        }
        resultAspect = (Aspect)this.serviceModule.getAspect(this, aspectName, this.liveKeyList, lockStrategy);
        this.dependantAspectCache.addSiblingAspect(aspectName, resultAspect);
        return resultAspect;
    }

    void lockAndRefresh(AspectRow row, LockStrategy lockStrategy) {
        if (row.getState() == 2) {
            throw new IllegalStateException("AspectRow with Key " + row.getKey() + " of Aspect '" + this.getName() + "' cannot be locked, cause it is dirty");
        }
        LockState lockState = row.getLockStateInternal();
        if (lockState.hasLock() && lockState.getLockStrategy() != lockStrategy) {
            throw new IllegalStateException("Changing lock strategy from '" + lockState.getLockStrategy() + "' to '" + lockStrategy + "' not allowed in one transaction (Aspect: '" + this.getName() + "')");
        }
        int lockMode = LockState.getLockModeFromStrategy(this.getDescriptor(), lockStrategy);
        if (lockState.hasLock()) {
            return;
        }
        lockState.setLockStrategy(lockStrategy);
        ISrvMgrSelect selectCall = this.serviceModule.getSrvMgrServiceModule().createSelect(this.getName());
        GenericClientUtils.copyFromKeyToTable((Key)row.getKey(), selectCall.getInKeys(), 0);
        selectCall.setLockMode(lockMode);
        row.refresh();
        row.setState(1);
        this.serviceModule.registerSrvMgrCallObject((ISrvMgrCall)selectCall, this);
    }

    void lockAndRefresh(LockStrategy lockStrategy) {
        LockState.checkLockConsistenceOfAspect(this, lockStrategy);
        int lockMode = LockState.getLockModeFromStrategy(this.getDescriptor(), lockStrategy);
        this.setLockingStrategy(lockStrategy);
        if (this.state == 1) {
            ISrvMgrCall createAspectCall = this.getCreateAspectCall();
            if (createAspectCall instanceof ISrvMgrSelect) {
                ((ISrvMgrSelect)createAspectCall).setLockMode(lockMode);
            } else if (createAspectCall instanceof ISrvMgrSelectByRelation) {
                ((ISrvMgrSelectByRelation)createAspectCall).setLockMode(lockMode);
            }
        } else if (this.state == 0) {
            GenericClientUtils.selectAspectFromKeys(this, this.liveKeyList, lockMode, null);
        }
    }

    protected void addAspectRow(AspectRow aspectRow) {
        if (aspectRow != null) {
            if (this.aspectRows.contains(aspectRow)) {
                return;
            }
            this.wrappedEdoTable.append(1);
            this.aspectRows.add(aspectRow);
            this.aspectRowsMap.put(aspectRow.getKey(), aspectRow);
            if (this.state == 0 || this.state == 2) {
                this.aspectChanges.registerInsert(aspectRow);
            }
        }
    }

    public IAspectDescriptor getDescriptor() {
        return this.descriptor;
    }

    public IServiceModule getServiceModule() {
        return this.serviceModule;
    }

    protected void registerUpdate(IKey key, String fieldName) {
        if (this.state == 0 || this.state == 2) {
            this.aspectChanges.registerUpdate(key, fieldName);
            this.setState(2);
        }
    }

    public void sendChanges() {
        if (logger.bePath()) {
            logger.pathT("entering: sendChanges", "Aspect Name: " + this.getName());
        }
        if (this.getState() != 2) {
            logger.infoT("sendChanges", "exit, cause Aspect is not dirty");
            return;
        }
        this.aspectChanges.sendChanges();
        this.setState(3);
    }

    protected void handleAccessAspect(boolean readOnly) {
        if (this.state == 3 || this.state == 1) {
            this.serviceModule.flush("handleAccessAspect");
        }
        if (this.state == 6) {
            this.startRefreshingAspect();
            if (this.state == 1) {
                this.serviceModule.flush("handleAccessAspect");
            }
        }
        if (this.state == 4) {
            logger.fatalT(" Aspect '" + this.getName() + "' is invalid: Fatal Access Error!!!");
            throw new IllegalStateException(" Aspect '" + this.getName() + "' is invalid: Fatal Access Error!!!");
        }
        if (this.state == 0 && !readOnly) {
            this.state = 2;
        }
    }

    protected void onServiceQueueWillBeFlushed() {
        if (this.getState() == 2) {
            this.sendChanges();
        }
    }

    protected void addActionCall(ISrvMgrAction actionCall, IKeyList keyList) {
        this.aspectChanges.registerAction(actionCall, keyList);
    }

    protected IEdoTable getWrappedEdoTable() {
        return this.wrappedEdoTable;
    }

    void setWrappedEdoTable(IEdoTable newAspectData) {
        this.wrappedEdoTable = newAspectData;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("  <Aspect name=\"" + this.getName() + "\" >").append(nl);
        int i = 0;
        while (i < this.size()) {
            buf.append("  <Row " + i + ">").append(nl);
            buf.append(this.get(i).toString());
            buf.append("  </Row>").append(nl);
            ++i;
        }
        buf.append("  </Aspect>").append(nl);
        return buf.toString();
    }

    public void addSilently(int index, Object element) {
        throw new UnsupportedOperationException("Aspect doesn't support adding rows via its List interface");
    }

    public Object get(int index) {
        return this.getAspectRow(index);
    }

    public Object removeSilently(int index) {
        if (logger.bePath()) {
            logger.pathT("entering: removeSilently", "AspectRow index: " + index);
        }
        IAspectRow row = this.getAspectRow(index);
        this.removeAspectRowSilently(row, null);
        return row;
    }

    public Object setSilently(int index, Object element) {
        throw new UnsupportedOperationException("Aspect doesn't support changing rows via its List interface");
    }

    public int size() {
        this.handleAccessAspect(true);
        return this.aspectRows.size();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public void invalidate() {
        if (logger.bePath()) {
            logger.pathT("entering: invalidate", "Aspect Name: " + this.getName());
        }
        this.invalidateInternal();
        if (!this.isCacheRootObject()) {
            this.unLinkFromCache(this.creationPath);
        } else {
            this.serviceModule.removeCacheRootObject(this);
        }
    }

    protected void invalidateInternal() {
        if (this.getState() == 4) {
            return;
        }
        this.serviceModule.unregisterAspect(this);
        this.setState(4);
        this.dependantAspectCache.invalidate();
        Iterator rowsIterator = ((AbstractList)this.aspectRows).iterator();
        while (rowsIterator.hasNext()) {
            AspectRow row = (AspectRow)rowsIterator.next();
            row.invalidateInternal();
        }
        this.aspectCache.remove(this);
    }

    public void refresh() {
        if (logger.bePath()) {
            logger.pathT("entering: refresh", "Aspect Name: " + this.getName());
        }
        if (this.state == 4) {
            logger.fatalT(" Aspect '" + this.getName() + "' is invalid: Fatal Access Error!!!");
            throw new IllegalStateException(" Aspect '" + this.getName() + "' is invalid: Fatal Access Error!!!");
        }
        if (this.state == 3) {
            logger.fatalT(" There are pending changes for Aspect '" + this.getName() + "', so it could not be refreshed.");
            throw new IllegalStateException(" There are pending changes for Aspect '" + this.getName() + "', so it could not be refreshed.");
        }
        if (this.isCacheRootObject() || this.getCreationPath().callingQuery != null) {
            this.updateSourceKeyList(this.getKeyList());
        }
        if (this.state == 2) {
            KeyList keyList = this.aspectChanges.getDeletedKeyList();
            if (keyList != null) {
                this.updateSourceKeyList(keyList);
            }
            this.aspectChanges.reset();
        }
        this.setState(6);
        this.dependantAspectCache.refresh();
        DependantAspectCache[] caches = new DependantAspectCache[this.aspectRows.size()];
        int i = 0;
        while (i < this.aspectRows.size()) {
            caches[i] = ((AspectRow)this.aspectRows.get(i)).getDependantAspectCache();
            ++i;
        }
        int i2 = 0;
        while (i2 < caches.length) {
            caches[i2].refresh();
            ++i2;
        }
        super.fireComplexChange(-1, -1, 6);
    }

    void refreshSubTree() {
        this.dependantAspectCache.refresh();
        DependantAspectCache[] caches = new DependantAspectCache[this.aspectRows.size()];
        int i = 0;
        while (i < this.aspectRows.size()) {
            caches[i] = ((AspectRow)this.aspectRows.get(i)).getDependantAspectCache();
            ++i;
        }
        int i2 = 0;
        while (i2 < caches.length) {
            caches[i2].refresh();
            ++i2;
        }
    }

    protected void startRefreshingAspect() {
        Aspect parent = this;
        ArrayList<CreationPath> listOfCallHistory = new ArrayList<CreationPath>();
        while (parent.getState() == 6) {
            listOfCallHistory.add(0, parent.getCreationPath());
            parent = parent.getCallingAspect();
            if (parent == null) break;
        }
        int i = 0;
        while (i < listOfCallHistory.size()) {
            CreationPath path = (CreationPath)listOfCallHistory.get(i);
            parent = path.callingAspect;
            if (parent == null) {
                GenericClientUtils.selectAspectFromKeys(path.targetAspect, path.sourceKeyList, 0, null);
            } else {
                IKey parentKey = path.aspectRowKey;
                if (parentKey != null) {
                    AspectRow parentRow = (AspectRow)parent.getAspectRow(parentKey);
                    if (parentRow == null) {
                        this.invalidate();
                        break;
                    }
                    parentRow.executeRefreshCall(path.creationCall, path.targetAspect);
                } else {
                    parent.executeRefreshCall(path.creationCall, path.targetAspect);
                }
            }
            ++i;
        }
    }

    protected void executeRefreshCall(ISrvMgrCall call, Aspect target) {
        if (call == null || call instanceof ISrvMgrCopyCorresponding) {
            if (this.getState() == 1) {
                ISrvMgrCopyCorresponding copyCall = (ISrvMgrCopyCorresponding)call;
                if (copyCall == null) {
                    copyCall = this.serviceModule.getSrvMgrServiceModule().createCopyCorresponding(this.getName(), this.getDescriptor().getKeyDescriptor().getName());
                    call = copyCall;
                } else {
                    copyCall.reset();
                }
                copyCall.setInRecords(this.getCreateAspectCall().getOutRecords());
                target.refreshCreateAspectCall((ISrvMgrCall)copyCall);
            } else {
                IEdoTable wrappedKeyEdoTable = this.serviceModule.getSrvMgrServiceModule().createTable(this.descriptor.getKeyDescriptor().getStructure());
                GenericClientUtils.copyFromKeyListToTable(this.liveKeyList, wrappedKeyEdoTable);
                GenericClientUtils.updateAspectWithOutRecords(target, wrappedKeyEdoTable, call);
                call = null;
            }
        } else if (call instanceof ISrvMgrSelect) {
            ISrvMgrSelect selectCall = (ISrvMgrSelect)call;
            selectCall.reset();
            if (this.state != 1) {
                GenericClientUtils.copyFromKeyListToTable(this.liveKeyList, selectCall.getInKeys());
            } else {
                ISrvMgrCopyCorresponding copyCall = this.serviceModule.getSrvMgrServiceModule().createCopyCorresponding(this.getName(), this.getDescriptor().getKeyDescriptor().getName());
                copyCall.setInRecords(this.getCreateAspectCall().getOutRecords());
                this.serviceModule.registerSrvMgrCallObject((ISrvMgrCall)copyCall, null);
                selectCall.setInKeys(copyCall.getOutRecords());
            }
        } else if (call instanceof ISrvMgrSelectByRelation) {
            ISrvMgrSelectByRelation selectByRelationCall = (ISrvMgrSelectByRelation)call;
            selectByRelationCall.reset();
            if (this.state != 1) {
                selectByRelationCall.setInRecords(this.wrappedEdoTable);
            } else {
                selectByRelationCall.setInRecords(this.getCreateAspectCall().getOutRecords());
            }
            this.dependantAspectCache.setIndexTable(selectByRelationCall.getRelationDescriptor().getName(), selectByRelationCall.getRelations());
        }
        if (call != null) {
            this.serviceModule.registerSrvMgrCallObject(call, target);
            target.setState(1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unLinkFromCache(CreationPath creationPath) {
        Aspect aspect = creationPath.callingAspect;
        if (aspect != null) {
            DependantAspectCache dependentAspectCache = null;
            IKey key = creationPath.aspectRowKey;
            if (key != null) {
                AspectRow aspectRow = (AspectRow)aspect.getAspectRow(key);
                if (aspectRow == null) return;
                dependentAspectCache = aspectRow.getDependantAspectCache();
            } else {
                dependentAspectCache = aspect.getDependantAspectCache();
            }
            if (creationPath.creationCall == null || creationPath.creationCall instanceof ISrvMgrSelect) {
                dependentAspectCache.removeSiblingAspect(this);
                return;
            } else {
                if (!(creationPath.creationCall instanceof ISrvMgrSelectByRelation)) return;
                dependentAspectCache.removeRelatedAspect(((ISrvMgrSelectByRelation)creationPath.creationCall).getRelationDescriptor().getName());
            }
            return;
        } else {
            Query query = creationPath.callingQuery;
            if (query == null) return;
            query.setResult(null);
        }
    }

    protected void bindAspectCache(AspectCache aspectCache) {
        this.aspectCache = aspectCache;
    }

    public boolean isCacheRootObject() {
        return this.cacheRootObject;
    }

    protected void setCacheRootObject(boolean cacheRootObject) {
        this.cacheRootObject = cacheRootObject;
    }

    DependantAspectCache getDependantAspectCache() {
        return this.dependantAspectCache;
    }

    public AspectCache getAspectCache() {
        return this.aspectCache;
    }

    protected Aspect getSelectedAspect(String aspectName) {
        return this.dependantAspectCache.getSiblingAspect(aspectName);
    }

    public IKeyList getKeyList() {
        if (logger.bePath()) {
            logger.pathT("entering: getKeyList");
        }
        this.handleAccessAspect(true);
        KeyList keyList = (KeyList)this.serviceModule.createKeyList(this.descriptor.getKeyDescriptor().getName());
        Iterator it = ((AbstractList)this.aspectRows).iterator();
        while (it.hasNext()) {
            AspectRow aspectRow = (AspectRow)it.next();
            keyList.add(aspectRow.getKey());
        }
        return keyList;
    }

    Map getInvalidationHints() {
        if (this.invalidationHints == null) {
            this.invalidationHints = new HashMap();
            this.invalidationHints.put("UPDATE", this.getAffectsParameter("UPDATE"));
            this.invalidationHints.put("UPDATE_FIELDS", this.getAffectsParameter("UPDATE_FIELDS"));
            this.invalidationHints.put("INSERT", this.getAffectsParameter("INSERT"));
            this.invalidationHints.put("DELETE", this.getAffectsParameter("DELETE"));
            IAspectActionDescriptor[] actionDescriptors = this.descriptor.getAspectActionDescriptors();
            int i = 0;
            while (i < actionDescriptors.length) {
                this.invalidationHints.put(actionDescriptors[i].getName(), this.getAffectsParameter(actionDescriptors[i].getName()));
                ++i;
            }
        }
        return this.invalidationHints;
    }

    Integer getAffectsParameter(String actionName) {
        try {
            return new Integer(this.descriptor.getActionAttributeAffects(actionName));
        }
        catch (UnsupportedOperationException e) {
            return new Integer(0);
        }
    }

    public void setInvalidationHint(String actionName, int affects) {
        if (logger.bePath()) {
            logger.pathT("entering: setInvalidationHint", "AspectName: " + this.getName() + " Action Name: " + actionName + " Affects: " + affects);
        }
        if (affects != 3 && affects != 2 && affects != 1 && affects != 0) {
            throw new IllegalArgumentException("Invalid AFFECTS parameter '" + affects + "' in method call setInvalidationHint of Aspect '" + this.getName() + "'");
        }
        Map invalidationHints = this.getInvalidationHints();
        Integer oldAffects = (Integer)invalidationHints.get(actionName);
        if (oldAffects == null) {
            throw new IllegalArgumentException("Invalid actionName parameter '" + actionName + "' in method call setInvalidationHint of Aspect '" + this.getName() + "'");
        }
        if (oldAffects != affects) {
            invalidationHints.put(actionName, new Integer(affects));
        }
    }

    private boolean isValidAspectName(String aspectName) {
        if (aspectName == null || aspectName.equals(this.getName())) {
            return false;
        }
        IKeyAspectDescriptor keyDescriptor = this.descriptor.getKeyDescriptor();
        if (keyDescriptor.getName().equals(aspectName)) {
            return true;
        }
        IAspectDescriptor target = keyDescriptor.getAspectDescriptor(aspectName);
        return target != null;
    }

    IKeyList getLiveKeyList() {
        return this.liveKeyList;
    }

    public void promoteLock() {
        if (logger.bePath()) {
            logger.pathT("entering: promoteLock", "AspectName: " + this.getName());
        }
        this.handleAccessAspect(true);
        ISrvMgrLock lockCall = this.serviceModule.getSrvMgrServiceModule().createLock(this.getName());
        GenericClientUtils.copyFromKeyListToTable(this.liveKeyList, lockCall.getInKeys());
        lockCall.setLockMode(1);
        this.serviceModule.registerSrvMgrCallObject((ISrvMgrCall)lockCall, this);
        this.setState(1);
    }

    public void unlock() {
        if (logger.bePath()) {
            logger.pathT("entering: unlock", "AspectName: " + this.getName());
        }
        this.handleAccessAspect(true);
        ISrvMgrUnlock unLockCall = this.serviceModule.getSrvMgrServiceModule().createUnlock(this.getName());
        GenericClientUtils.copyFromKeyListToTable(this.liveKeyList, unLockCall.getInKeys());
        this.serviceModule.registerSrvMgrCallObject((ISrvMgrCall)unLockCall, this);
        this.setState(1);
    }

    public void onCallsProcessed(ISrvMgrCall[] calls) {
        if (logger.bePath()) {
            logger.pathT("entering: onCallsProcessed", "AspectName: " + this.getName());
        }
        if (this.state == 4) {
            return;
        }
        int i = 0;
        while (i < calls.length) {
            this.processSrvMgrCall(calls[i]);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processSrvMgrCall(ISrvMgrCall srvMgrCall) {
        if (logger.bePath()) {
            logger.pathT("entering: processSrvMgrCall");
            GenericClientUtils.dumpSrvMgrCall(srvMgrCall, logger);
        }
        if (srvMgrCall instanceof ISrvMgrQuery || srvMgrCall instanceof ISrvMgrSelect || srvMgrCall instanceof ISrvMgrCopyCorresponding || srvMgrCall instanceof ISrvMgrSelectByRelation) {
            if (this.state == 1 && this.wrappedEdoTable == null) {
                GenericClientUtils.setOutRecordsToAspect(this, srvMgrCall.getOutRecords(), srvMgrCall);
                this.serviceModule.registerAspect(this);
                return;
            }
            if (this.wrappedEdoTable != null) {
                GenericClientUtils.mergeOutRecordsWithAspect(this, srvMgrCall);
                return;
            }
            logger.fatalT("Aspect '" + this.getName() + "' is in an unexpected state '" + this.state + "' for call " + srvMgrCall.getClass());
            throw new IllegalStateException("Aspect is in an unexpected state '" + this.state + "' for call " + srvMgrCall.getClass());
        }
        if (srvMgrCall instanceof ISrvMgrUpdateRow || srvMgrCall instanceof ISrvMgrUpdateField || srvMgrCall instanceof ISrvMgrInsert || srvMgrCall instanceof ISrvMgrDelete || srvMgrCall instanceof ISrvMgrAction) {
            this.state = 5;
            int affects = this.aspectChanges.getActualAffectsParameter();
            this.aspectChanges.mergeUpdatedAspectRows(this.wrappedEdoTable);
            this.aspectChanges.mergeInsertedAspectRows(this.wrappedEdoTable);
            this.aspectChanges.handleDeleteCall();
            this.aspectChanges.mergeActionsToAspectRows();
            if (!this.aspectChanges.isEmpty()) {
                this.state = 2;
                return;
            }
            if (affects == 3) {
                this.aspectCache.setDirty(true);
                this.aspectChanges.reset();
            } else if (affects == 2) {
                this.aspectCache.setDirtySubTree(this);
                this.aspectChanges.reset();
            }
            this.state = 0;
            return;
        }
        if (srvMgrCall instanceof ISrvMgrLock) {
            this.aspectChanges.handleLockCall((ISrvMgrLock)srvMgrCall);
            return;
        }
        if (srvMgrCall instanceof ISrvMgrUnlock) {
            this.aspectChanges.handleUnLockCall((ISrvMgrUnlock)srvMgrCall);
            return;
        }
        logger.fatalT("Unknown call object: " + srvMgrCall.getClass());
        throw new IllegalArgumentException("Unknown call object: " + srvMgrCall.getClass());
    }

    public IMessageList getMessages() {
        if (logger.bePath()) {
            logger.pathT("entering: getMessages", "Aspect Name: " + this.getName());
        }
        return new MessageList((ISrvMgrMessageProvider)this.serviceModule.getSrvMgrServiceModule().getServiceManager(), this);
    }

    protected void updateKeyMap(AspectRow row, Key key) {
        if (key.isLocalKey()) {
            if (this.aspectRowsMap.containsKey(key)) {
                this.aspectRowsMap.remove(key);
            }
            key.takeFieldsFromRow(row);
        }
        this.aspectRowsMap.put(key, row);
    }

    public boolean isValid() {
        if (logger.bePath()) {
            logger.pathT("entering: isValid", "Aspect Name: " + this.getName());
        }
        return this.state != 4;
    }

    boolean isFieldWiseChange() {
        if (this.fieldWiseChange == null) {
            boolean rowWiseFlag = false;
            boolean fieldWiseFlag = false;
            try {
                rowWiseFlag = this.descriptor.getAttributeRowwiseOperation();
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            try {
                fieldWiseFlag = this.descriptor.getAttributeFieldwiseOperation();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.fieldWiseChange = rowWiseFlag || !fieldWiseFlag ? Boolean.FALSE : Boolean.TRUE;
        }
        return this.fieldWiseChange;
    }

    protected void fireElementAdded(IAspectRow row, int index) {
        super.fireElementAdded((Object)row, index);
    }

    protected void fireElementChanged(IAspectRow row, int index) {
        ((AspectRow)row).incrementModCount();
        super.fireElementChanged((Object)row, index);
    }

    protected void refreshCreateAspectCall(ISrvMgrCall call) {
        this.creationPath.creationCall = call;
        if (this.state != 1) {
            this.state = 1;
        }
    }

    protected ISrvMgrCall getCreateAspectCall() {
        return this.creationPath.creationCall;
    }

    void setLockingStrategy(LockStrategy lockStrategy) {
        this.creationPath.lockStrategy = lockStrategy;
    }

    LockStrategy getLockingStrategy() {
        return this.creationPath.lockStrategy;
    }

    void setCallingAspect(Aspect aspect) {
        this.creationPath.callingAspect = aspect;
    }

    void setCallingQuery(Query query) {
        this.creationPath.callingQuery = query;
    }

    void setCallingAspectRowKey(IKey key) {
        this.creationPath.aspectRowKey = key;
    }

    protected Aspect getCallingAspect() {
        return this.creationPath.callingAspect;
    }

    protected void setLocalRelationCreationCall(String relationName) {
        this.creationPath.localRelation = relationName;
    }

    protected void updateSourceKeyList(IKeyList keyList) {
        if (this.creationPath.sourceKeyList == null) {
            this.creationPath.sourceKeyList = keyList;
        } else {
            int i = 0;
            while (i < keyList.size()) {
                IKey key = keyList.getKey(i);
                if (!this.creationPath.sourceKeyList.contains(key)) {
                    this.creationPath.sourceKeyList.add(key);
                }
                ++i;
            }
        }
    }

    protected void resetSourceKeyList() {
        this.creationPath.sourceKeyList = null;
    }

    protected String getLocalRelationCreationCall() {
        return this.creationPath.localRelation;
    }

    protected IKey getRelationParentKey() {
        Aspect parent = this.getCallingAspect();
        if (parent != null && this.creationPath.aspectRowKey != null && this.creationPath.creationCall instanceof ISrvMgrSelectByRelation) {
            return this.creationPath.aspectRowKey;
        }
        return null;
    }

    CreationPath getCreationPath() {
        return this.creationPath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.client.generic.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_client_generic/java/com/sap/tc/col/client/generic/core/Aspect.java#2 $");
    }

    private class CreationPath {
        private ISrvMgrCall creationCall;
        private LockStrategy lockStrategy;
        private String localRelation;
        private Aspect callingAspect;
        private Query callingQuery;
        private IKey aspectRowKey;
        private IKeyList sourceKeyList;
        private Aspect targetAspect;

        private CreationPath(ISrvMgrCall call, Aspect aspect) {
            this.creationCall = call;
            this.targetAspect = aspect;
        }
    }

    private class LiveKeyList
    extends AbstractList
    implements IKeyList {
        private LiveKeyList() {
        }

        public IKeyAspectDescriptor getDescriptor() {
            return Aspect.this.getDescriptor().getKeyDescriptor();
        }

        public IKey getKey(int index) {
            return Aspect.this.getAspectRow(index).getKey();
        }

        public Object get(int index) {
            return this.getKey(index);
        }

        public int size() {
            return Aspect.this.size();
        }
    }
}

