/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.model.ICMIModel;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.col.client.generic.api.IAction;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.core.AbstractModelClass;
import com.sap.tc.col.client.generic.core.Aspect;
import com.sap.tc.col.client.generic.core.ColModelInfo;
import com.sap.tc.col.client.generic.core.GenericClientUtils;
import com.sap.tc.col.client.generic.core.ISrvMgrCaller;
import com.sap.tc.col.client.generic.core.Key;
import com.sap.tc.col.client.generic.core.ServiceModule;
import com.sap.tc.col.client.generic.core.Structure;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrAction;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.logging.Location;

public class Action
extends AbstractModelClass
implements IAction,
ISrvMgrCaller {
    private static final Location logger = Location.getLocation((Class)(class$com$sap$tc$col$client$generic$core$Action == null ? (class$com$sap$tc$col$client$generic$core$Action = Action.class$("com.sap.tc.col.client.generic.core.Action")) : class$com$sap$tc$col$client$generic$core$Action));
    private final ICMIModelClassInfo modelClassInfo;
    private IAspectActionDescriptor descriptor;
    private IKeyList inputKeyList;
    private Aspect inputAspect;
    private Structure inputParameter;
    private Key relationTargetKey;
    private ISrvMgrAction srvMgrAction;
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$core$Action;

    protected Action(IAspectActionDescriptor descriptor, Aspect inputAspect) {
        if (descriptor == null) {
            throw new IllegalArgumentException("AspectActionDescriptor must not be null");
        }
        this.descriptor = descriptor;
        this.inputAspect = inputAspect;
        ServiceModule serviceModule = (ServiceModule)inputAspect.getServiceModule();
        this.srvMgrAction = serviceModule.getSrvMgrServiceModule().createAction(inputAspect.getName(), this.getDescriptor().getName());
        if (descriptor.hasInputParameters()) {
            this.inputParameter = (Structure)serviceModule.createStructureInternal(descriptor.getInputParameters(), this.srvMgrAction.createInParameterList());
        }
        if (descriptor.getInputKeysDescriptor() != null) {
            this.inputKeyList = serviceModule.createKeyList(descriptor.getInputKeysDescriptor().getName());
        }
        this.modelClassInfo = ((ColModelInfo)this.associatedModel().associatedModelInfo()).getOrCreateModelClassInfo(descriptor);
    }

    public ICMIModel associatedModel() {
        if (logger.bePath()) {
            logger.pathT("entering: associatedModel");
        }
        return this.inputAspect.associatedModel();
    }

    public ICMIModelClassInfo associatedModelClassInfo() {
        if (logger.bePath()) {
            logger.pathT("entering: associatedModelClassInfo");
        }
        return this.modelClassInfo;
    }

    public void execute() {
        if (logger.bePath()) {
            logger.pathT("entering: execute");
        }
        ServiceModule serviceModule = (ServiceModule)this.inputAspect.getServiceModule();
        if (this.srvMgrAction == null) {
            this.srvMgrAction = serviceModule.getSrvMgrServiceModule().createAction(this.inputAspect.getName(), this.getDescriptor().getName());
        }
        if (this.inputParameter != null) {
            this.srvMgrAction.setInParameters(this.inputParameter.getEdoStructure());
        }
        IEdoTable inKeys = this.srvMgrAction.getInKeys();
        GenericClientUtils.copyFromKeyListToTable(this.inputKeyList, inKeys);
        String crossAspectRelation = this.descriptor.getAttributeRelation();
        if (crossAspectRelation != null && !crossAspectRelation.equals("")) {
            if (this.relationTargetKey == null) {
                this.relationTargetKey = (Key)this.inputAspect.getRelationParentKey();
            }
            if (this.relationTargetKey != null) {
                GenericClientUtils.copyFromKeyToStructure(this.relationTargetKey, this.srvMgrAction.getRelationInKey());
            } else {
                logger.warningT("No relation target Key set for cross Aspect Action '" + this.descriptor.getName() + "' (nor explicit nor implicit");
            }
        }
        this.inputAspect.sendChanges();
        ((ServiceModule)this.inputAspect.getServiceModule()).registerSrvMgrCallObject((ISrvMgrCall)this.srvMgrAction, this);
        this.inputAspect.addActionCall(this.srvMgrAction, this.inputKeyList);
        this.srvMgrAction = null;
    }

    public IAspectActionDescriptor getDescriptor() {
        if (logger.bePath()) {
            logger.pathT("entering: getDescriptor");
        }
        return this.descriptor;
    }

    public IStructure getInputParameterStructure() {
        if (logger.bePath()) {
            logger.pathT("entering: getInputParameterStructure");
        }
        if (this.inputParameter == null) {
            throw new UnsupportedOperationException("Action '" + this.descriptor.getName() + "'doesn't support input parameter!");
        }
        return this.inputParameter;
    }

    public IStructure getInputParameter() {
        return this.getInputParameterStructure();
    }

    public IKeyList getInputKeyList() {
        if (logger.bePath()) {
            logger.pathT("entering: getInputKeyList");
        }
        return this.inputKeyList;
    }

    public void setRelationTargetKey(IKey key) {
        if (this.descriptor.getAttributeRelation() == null || "".equals(this.descriptor.getAttributeRelation())) {
            throw new IllegalArgumentException("setting of relation target Key not allowed for not Cross Aspect Action");
        }
        this.relationTargetKey = (Key)key;
    }

    public ICMIModelClass getRelatedModelObject(String rolename) {
        if (logger.bePath()) {
            logger.pathT("entering: getRelatedModelObject", "Role: " + rolename);
        }
        if (rolename.equalsIgnoreCase("inputParameter")) {
            return this.getInputParameterStructure();
        }
        return super.getRelatedModelObject(rolename);
    }

    public void onCallsProcessed(ISrvMgrCall[] calls) {
        this.inputAspect.onCallsProcessed(calls);
    }

    public String getName() {
        if (logger.bePath()) {
            logger.pathT("entering: getName");
        }
        return this.descriptor.getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.client.generic.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_client_generic/java/com/sap/tc/col/client/generic/core/Action.java#1 $");
    }
}

