/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.wizards.jpx.ui;

import com.sap.ide.eclipse.wizards.jpx.tools.Jpx2EclipseProjectConverter;
import com.sap.ide.eclipse.wizards.jpx.tools.Jpx2eclipseUtil;
import com.sap.ide.eclipse.wizards.jpx.tools.ProjectConstants;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class JpxImportStartPage
extends WizardPage
implements ProjectConstants {
    private static final boolean MDEBUG = ProjectConstants.DEBUG_UI_P1;
    public static final String TEXT_TITLE = "Import .jpx Project";
    public static final String TEXT_MESSAGE_DEFAULT = "Please select the .jpx project file to import";
    public static final String TEXT_MESSAGE_2 = "Select the eclipse project name and location";
    public static final String TEXT_UI_LABEL_JPX_FILE = ".jpx project file:";
    public static final String TEXT_UI_LABEL_PROJ_NAME = "Eclipse project name:";
    public static final String TEXT_UI_LABEL_PROJ_LOC = "Create Eclipse project in this directory (location):";
    private IWorkbench workbench;
    private Jpx2EclipseProjectConverter conversionBag;
    private IWorkspace RES_Workspace = ResourcesPlugin.getWorkspace();
    private IWorkspaceRoot RES_WorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private Text projectNameField;
    private Text jpx_locationPathField;
    private Button jpx_browseButton;
    private Text eclipse_locationPathField;
    private String eclipse_locationLatestPath = "";
    private Button eclipse_browseButton;
    private Label locationLabel;
    private Button locationDefaultSelector;
    private Label eclipse_locLabel;
    private Listener projectNameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            if (MDEBUG) {
                System.out.println("event:changed project name field");
            }
            String newName = JpxImportStartPage.this.projectNameField.getText();
            JpxImportStartPage.this.conversionBag.setProjectName(newName);
            if (newName != null && newName.length() != 0 && JpxImportStartPage.this.locationDefaultSelector.getSelection()) {
                JpxImportStartPage.this.eclipse_locationPathField.setText(JpxImportStartPage.this.getDefaultLocation());
            } else {
                JpxImportStartPage.this.validatePage();
            }
        }
    };
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            if (MDEBUG) {
                System.out.println("event:changed project location field");
            }
            String newPath = JpxImportStartPage.this.eclipse_locationPathField.getText();
            if (JpxImportStartPage.this.eclipse_locationLatestPath.equalsIgnoreCase(newPath)) {
                return;
            }
            JpxImportStartPage.this.conversionBag.setEclipseProjectLocation(newPath);
            if (!JpxImportStartPage.this.getDefaultLocation().equalsIgnoreCase(newPath)) {
                JpxImportStartPage.this.eclipse_locationLatestPath = newPath;
            }
            JpxImportStartPage.this.validatePage();
        }
    };
    String jpxFile = "";
    private static final String[] jpxFileFilter = new String[]{"*.jpx", "*.*"};

    protected JpxImportStartPage(Jpx2EclipseProjectConverter conversionBag, IWorkbench workbench) {
        super("jpx import, start-page");
        this.workbench = workbench;
        this.conversionBag = conversionBag;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createJpxProjectLocationGroup(composite);
        this.createProjectNameGroup(composite);
        this.createSpacer(composite);
        this.createEclipseProjectLocationGroup(composite);
        this.projectNameField.setFocus();
        this.setControl((Control)composite);
        this.validatePage();
        this.setTitle(TEXT_TITLE);
        this.setMessage(TEXT_MESSAGE_DEFAULT);
        this.setErrorMessage(null);
    }

    public void setVisible(boolean visi) {
        if (MDEBUG) {
            System.out.println("W-P1:setVisible(" + visi + ")");
        }
        super.setVisible(visi);
    }

    private final void createJpxProjectLocationGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectContentsLabel = new Label(projectGroup, 0);
        projectContentsLabel.setText(TEXT_UI_LABEL_JPX_FILE);
        this.jpx_locationPathField = new Text(projectGroup, 2048);
        this.jpx_locationPathField.setEditable(false);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.jpx_locationPathField.setLayoutData((Object)data);
        this.jpx_browseButton = new Button(projectGroup, 8);
        this.jpx_browseButton.setText("select");
        this.jpx_browseButton.setFocus();
        this.jpx_browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JpxImportStartPage.this.handleJpxFileBrowseButtonPressed();
            }
        });
        this.jpx_locationPathField.addListener(24, this.locationModifyListener);
    }

    private final void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(TEXT_UI_LABEL_PROJ_NAME);
        this.projectNameField = new Text(projectGroup, 2048);
        this.projectNameField.setEditable(false);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.addListener(24, this.projectNameModifyListener);
    }

    private final void createEclipseProjectLocationGroup(Composite parent) {
        Composite loc_projectGroup = new Composite(parent, 0);
        GridLayout e_layout = new GridLayout();
        e_layout.numColumns = 1;
        loc_projectGroup.setLayout((Layout)e_layout);
        loc_projectGroup.setLayoutData((Object)new GridData(768));
        Label projectContentsLabel = new Label(loc_projectGroup, 0);
        projectContentsLabel.setText(TEXT_UI_LABEL_PROJ_LOC);
        this.locationDefaultSelector = new Button(loc_projectGroup, 32);
        this.locationDefaultSelector.setText("Use &default");
        this.locationDefaultSelector.setSelection(true);
        this.locationDefaultSelector.setEnabled(false);
        this.conversionBag.setCreateInDefaultWorkspace(true);
        Composite eclipseLocField = new Composite(loc_projectGroup, 0);
        GridLayout locfield_layout = new GridLayout();
        locfield_layout.numColumns = 3;
        locfield_layout.marginWidth = 0;
        eclipseLocField.setLayout((Layout)locfield_layout);
        eclipseLocField.setLayoutData((Object)new GridData(768));
        this.eclipse_locLabel = new Label(eclipseLocField, 0);
        this.eclipse_locLabel.setText("Directory:");
        this.eclipse_locLabel.setEnabled(false);
        this.eclipse_locationPathField = new Text(eclipseLocField, 2048);
        this.eclipse_locationPathField.setEditable(false);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.eclipse_locationPathField.setLayoutData((Object)data);
        this.eclipse_browseButton = new Button(eclipseLocField, 8);
        this.eclipse_browseButton.setText("select");
        this.eclipse_browseButton.setEnabled(false);
        this.eclipse_browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JpxImportStartPage.this.handleEclipseLocationBrowseButtonPressed();
            }
        });
        this.locationDefaultSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JpxImportStartPage.this.conversionBag.setCreateInDefaultWorkspace(JpxImportStartPage.this.locationDefaultSelector.getSelection());
                if (JpxImportStartPage.this.locationDefaultSelector.getSelection()) {
                    JpxImportStartPage.this.eclipse_locationPathField.setText(JpxImportStartPage.this.getDefaultLocation());
                    JpxImportStartPage.this.eclipse_locationPathField.setEditable(false);
                    JpxImportStartPage.this.eclipse_browseButton.setEnabled(false);
                    JpxImportStartPage.this.eclipse_locLabel.setEnabled(false);
                } else {
                    JpxImportStartPage.this.eclipse_locationPathField.setText(JpxImportStartPage.this.eclipse_locationLatestPath);
                    JpxImportStartPage.this.eclipse_locationPathField.setEditable(true);
                    JpxImportStartPage.this.eclipse_browseButton.setEnabled(true);
                    JpxImportStartPage.this.eclipse_locLabel.setEnabled(true);
                }
                JpxImportStartPage.this.validatePage();
            }
        });
        this.eclipse_locationPathField.addListener(24, this.locationModifyListener);
    }

    private String getDefaultLocation() {
        String defaultLocation = Platform.getLocation().append(this.projectNameField.getText().trim()).toOSString();
        return defaultLocation;
    }

    protected void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    private void handleEclipseLocationBrowseButtonPressed() {
        String selectedDirectory;
        DirectoryDialog dialog = new DirectoryDialog(this.eclipse_locationPathField.getShell());
        dialog.setMessage("select eclipse project location");
        if (MDEBUG) {
            System.out.println("Dialog-FilterPath=" + dialog.getFilterPath());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.changeProjectLocation(selectedDirectory);
        }
        this.validatePage();
    }

    private void handleJpxFileBrowseButtonPressed() {
        FileDialog fdialog = new FileDialog(this.jpx_locationPathField.getShell());
        fdialog.setText("select .jpx  Project File");
        fdialog.setFilterExtensions(jpxFileFilter);
        String selectedFile = fdialog.open();
        if (MDEBUG) {
            System.out.println("W-P1:selectedFile open() " + selectedFile);
        }
        if (selectedFile != null) {
            this.changeJpxFile(selectedFile);
        }
        this.validatePage();
    }

    protected String getLocation() {
        if (this.eclipse_locationPathField == null) {
            return "";
        }
        return this.eclipse_locationPathField.getText().trim();
    }

    private void setProjectLocationGUI(String location) {
        this.eclipse_locationLatestPath = location;
        if (!this.locationDefaultSelector.getSelection()) {
            this.eclipse_locationPathField.setText(location);
            this.eclipse_locationPathField.setEditable(true);
            this.eclipse_browseButton.setEnabled(true);
        }
    }

    private void changeJpxFile(String newJpxFile) {
        if (this.jpxFile.equals(newJpxFile)) {
            return;
        }
        this.jpxFile = newJpxFile;
        this.jpx_locationPathField.setText(newJpxFile);
        this.conversionBag.setJpxWrapper(newJpxFile);
        String newProjectName = this.conversionBag.getProjectName();
        this.projectNameField.setText(newProjectName);
        this.projectNameField.setEditable(true);
        this.locationDefaultSelector.setEnabled(true);
    }

    private void changeProjectLocation(String newLocation) {
        IStatus isValidDir = Jpx2eclipseUtil.isValidProjectLocation(newLocation);
        if (MDEBUG) {
            System.out.println("WIZ: finish() - validate location " + newLocation + " =>" + isValidDir);
        }
        if (isValidDir.isOK()) {
            this.conversionBag.setEclipseProjectLocation(newLocation);
            this.setProjectLocationGUI(newLocation);
        } else {
            this.conversionBag.setEclipseProjectLocation(newLocation);
            this.setProjectLocationGUI(newLocation);
            this.setErrorMessage(isValidDir.getMessage());
        }
    }

    private boolean validatePage() {
        if (MDEBUG) {
            System.out.println("W-P1:validatePage()");
        }
        this.setPageComplete(false);
        if (this.conversionBag.getJpxWrapper() == null || this.conversionBag.getProjectName() == null) {
            this.setPageComplete(false);
            return false;
        }
        String name = this.projectNameField.getText();
        IStatus nameValid = this.RES_Workspace.validateName(name, 4);
        if (MDEBUG) {
            System.out.println("W-P1: validatePage() - validate name " + name + " =>" + nameValid);
        }
        if (!nameValid.isOK()) {
            this.setPageComplete(false);
            this.setMessage("project name is not valid");
            this.setErrorMessage(nameValid.getMessage());
            return false;
        }
        if (this.RES_WorkspaceRoot.getProject(name).exists()) {
            this.setPageComplete(false);
            this.setErrorMessage("a project with the specified name already exists, choose another name");
            return false;
        }
        String location = this.getLocation();
        if (location.length() == 0) {
            this.setPageComplete(false);
            return false;
        }
        boolean locOK = false;
        String errMsg = "";
        if (this.conversionBag.isCreateInDefaultWorkspace()) {
            locOK = new Path("").isValidPath(location);
            errMsg = "The location is not a valid path";
        } else {
            IStatus locationStatus = Jpx2eclipseUtil.isValidProjectLocation(location);
            locOK = locationStatus.isOK();
            errMsg = locationStatus.getMessage();
        }
        if (MDEBUG) {
            System.out.println("W-P1: validatePage() - validate location " + location + " =>" + locOK);
        }
        if (MDEBUG) {
            System.out.println("       defaultWorkspace ? " + this.conversionBag.isCreateInDefaultWorkspace());
        }
        if (MDEBUG) {
            System.out.println("       location ok? " + Jpx2eclipseUtil.isValidProjectLocation(location).isOK());
        }
        if (MDEBUG) {
            System.out.println("       path ok? " + new Path("").isValidPath(location));
        }
        if (!locOK) {
            this.setMessage("project location is not valid");
            this.setErrorMessage(errMsg);
            this.setPageComplete(false);
            return false;
        }
        if (this.jpx_locationPathField.getText().trim().length() == 0) {
            this.setMessage(TEXT_MESSAGE_DEFAULT);
        } else {
            this.setMessage(TEXT_MESSAGE_2);
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        return true;
    }
}

