/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.wizards.jpx.ui;

import com.sap.ide.eclipse.wizards.jpx.tools.EclipseClasspathDescription;
import com.sap.ide.eclipse.wizards.jpx.tools.EclipseClasspathEntry;
import com.sap.ide.eclipse.wizards.jpx.tools.FileCopyDescriptor;
import com.sap.ide.eclipse.wizards.jpx.tools.JPXWrapper;
import com.sap.ide.eclipse.wizards.jpx.tools.Jpx2EclipseProjectConverter;
import com.sap.ide.eclipse.wizards.jpx.tools.Jpx2eclipseUtil;
import com.sap.ide.eclipse.wizards.jpx.tools.ProjectConstants;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import com.tssap.util.ui.viewer.table.SapTableViewer;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class JpxImportSrcPage
extends WizardPage
implements ProjectConstants {
    private Composite parent;
    private static final boolean MDEBUG = ProjectConstants.DEBUG_UI_SRC;
    private static final String TEXT_TITLE = "Copy Sources to Eclipse Location";
    private static String pageDescriptionInfoLabel = "Info: ";
    private static String pageDescription = "Some sources that are included in the jpx project are not located below the eclipse project location.";
    private static String pageDescriptionExt1 = " They have to be copied to the project location.";
    private static String pageDescriptionExt2 = " They have to be copied to the project location or have to be imported later manually.";
    private String[] tableHeaders = new String[]{"", "from:", "to: (subdirectory)"};
    private IWorkbench workbench;
    private Jpx2EclipseProjectConverter conversionBag;
    private Composite myCo;
    private Composite updateComposite;
    private Composite filterSelect;
    private int showCount = 1;
    private boolean copySrcSelected = true;
    private ArrayList toCopy;
    private ArrayList notCopy = new ArrayList();
    SelSrcTableModel pTableModel;
    ISapTableViewer tableViewer;
    Text filterSelect_filterFilesText;
    Button filterSelect_allFilesButton;
    Label filterSelect_overwriteLabel;
    private static final String[] jpxFileFilter = new String[]{"*.jpx", "*.*"};

    protected JpxImportSrcPage(Jpx2EclipseProjectConverter conversionBag, IWorkbench workbench) {
        super("jpx import, src-page");
        if (MDEBUG) {
            System.out.println("W-SRC:constructor");
        }
        this.workbench = workbench;
        this.conversionBag = conversionBag;
        this.initRefreshStuff();
    }

    private void initRefreshStuff() {
        this.myCo = null;
        this.updateComposite = null;
        this.filterSelect = null;
        this.copySrcSelected = true;
        this.toCopy = null;
        this.notCopy = new ArrayList();
        this.pTableModel = null;
        this.filterSelect_filterFilesText = null;
        this.filterSelect_allFilesButton = null;
        this.conversionBag.initLevel3();
    }

    private void createOverwriteInfo(Composite composite) {
        this.filterSelect = new Composite(composite, 0);
        this.filterSelect.setLayout((Layout)new GridLayout());
        this.filterSelect.setLayoutData((Object)new GridData(768));
        Label l1 = new Label(this.filterSelect, 0);
        l1.setText("Info:");
        Label l2 = new Label(this.filterSelect, 0);
        l2.setText("All files from the source directory are copied and");
        Label l3 = new Label(this.filterSelect, 0);
        l3.setText("Files in the destination directory might be overwritten");
    }

    public void createControl(Composite parent) {
        this.parent = parent;
        this.createControl_Tab(parent);
    }

    public void createControl_Tab(Composite parent) {
        if (MDEBUG) {
            System.out.println("W-SRC:createControl_Tab()");
        }
        this.myCo = new Composite(parent, 0);
        this.toCopy = this.srcPathToCopy();
        if (this.toCopy == null) {
            if (MDEBUG) {
                System.out.println("W-SRC:createControl- abort, no data, occurs only during init");
            }
            this.setControl((Control)this.myCo);
            return;
        }
        ArrayList srcPath = JpxImportSrcPage.srcPathInProjectLocation(this.conversionBag);
        this.myCo.setLayout((Layout)new RowLayout(512));
        Composite buttons = new Composite(this.myCo, 0);
        buttons.setLayout((Layout)new GridLayout());
        Button dontCopyButton = new Button(buttons, 16);
        dontCopyButton.setText("Don't copy Sources, import sources later manually");
        dontCopyButton.setSelection(false);
        Button doCopyButton = new Button(buttons, 16);
        doCopyButton.setText("Copy external sources to project location");
        doCopyButton.setSelection(true);
        doCopyButton.addSelectionListener((SelectionListener)new CopySrcSelector(doCopyButton, true));
        if (this.toCopy.size() > 0 || srcPath.size() > 0) {
            this.createSpacerRowData(this.myCo);
            this.createCopyComponents_Tab(this.myCo, this.toCopy, srcPath);
        }
        this.createSpacerRowData(this.myCo);
        if (this.toCopy.size() > 0) {
            Composite infoComp = new Composite(this.myCo, 0);
            infoComp.setLayout((Layout)new GridLayout());
            this.createOverwriteInfo(infoComp);
        }
        this.setTitle(TEXT_TITLE);
        this.setControl((Control)this.myCo);
        this.validatePage();
        this.setErrorMessage(null);
        if (this.toCopy.size() > 0) {
            this.setMessage(pageDescriptionInfoLabel + pageDescription + pageDescriptionExt1);
        } else {
            this.setMessage(pageDescriptionInfoLabel + " No sources have to be copied");
        }
        if (MDEBUG) {
            System.out.println("W-SRC:createControl()-end");
        }
    }

    protected void createSpacerRowData(Composite parent) {
        Label spacer = new Label(parent, 0);
        RowData data = new RowData();
        data.height = 20;
        data.width = 20;
        spacer.setLayoutData((Object)data);
    }

    protected void createSpacerGridData(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    private void createCopyComponents_Tab(Composite composite, ArrayList toCopy, ArrayList srcPath) {
        this.updateComposite = new Composite(composite, 0);
        this.updateComposite.setLayout((Layout)new RowLayout(512));
        Composite t1 = new Composite(this.updateComposite, 0);
        GridLayout gl1 = new GridLayout();
        gl1.numColumns = 1;
        gl1.marginWidth = 0;
        t1.setLayout((Layout)gl1);
        Label locLabel1 = new Label(t1, 0);
        locLabel1.setText("Eclipse project location: ");
        Label locLabel2 = new Label(t1, 2048);
        locLabel2.setText("  " + this.conversionBag.getEclipseProjectLocation() + "  ");
        new Label(t1, 0).setText("");
        new Label(t1, 0).setText("Copy:");
        Composite tabComponent = new Composite(this.updateComposite, 0);
        RowData tableLayoutData = new RowData();
        tableLayoutData.height = 100;
        tableLayoutData.width = 400;
        tabComponent.setLayoutData((Object)tableLayoutData);
        int cols = 3;
        int rows = toCopy.size();
        Object[][] tableData = new Object[rows][cols];
        int currRow = 0;
        String srcPathToCreate = "src";
        int pathExtCounter = 1;
        Iterator i = ((AbstractList)toCopy).iterator();
        while (i.hasNext()) {
            EclipseClasspathEntry ece = (EclipseClasspathEntry)i.next();
            tableData[currRow][0] = new Boolean(true);
            String srcString = this.stringNotNull(ece.path, "sources,path");
            tableData[currRow][1] = srcString;
            tableData[currRow][2] = srcPathToCreate + pathExtCounter++;
            ++currRow;
        }
        this.pTableModel = new SelSrcTableModel(tableData, this.tableHeaders);
        this.tableViewer = SapTableViewer.createTableViewer((Composite)tabComponent, (TableModel)this.pTableModel);
        this.tableViewer.setBooleanColumnHandler(0);
        this.tableViewer.getTable().getColumn(0).setWidth(20);
        this.tableViewer.getTable().getColumn(1).setWidth(190);
        this.tableViewer.getTable().getColumn(2).setWidth(186);
        this.pTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e_tm) {
                int col = e_tm.getColumn();
                int rowa = e_tm.getFirstRow();
                int rowb = e_tm.getLastRow();
                if (MDEBUG) {
                    System.out.println("Table changed at col:" + col + ", row:" + rowa + "-" + rowb + " event:" + e_tm);
                }
                JpxImportSrcPage.this.validatePage();
            }
        });
        if (srcPath.size() > 0) {
            this.createSpacerRowData(this.updateComposite);
            Label srcLabel = new Label(this.updateComposite, 0);
            String[] listItems = new String[srcPath.size()];
            int i2 = 0;
            Iterator it = ((AbstractList)srcPath).iterator();
            while (it.hasNext()) {
                String srcpath;
                EclipseClasspathEntry ece = (EclipseClasspathEntry)it.next();
                listItems[i2] = srcpath = this.stringNotNull(ece.path, "sources,path");
                ++i2;
            }
            int viewerStyle = 68352;
            viewerStyle |= 4;
            Composite listComponent = new Composite(this.updateComposite, 0);
            RowData listLayoutData = new RowData();
            if (srcPath.size() == 1) {
                listLayoutData.height = 30;
                srcLabel.setText("Source path already located in project:");
            } else {
                listLayoutData.height = 60;
                srcLabel.setText("Source paths already located in project:");
            }
            listLayoutData.width = 400;
            listComponent.setLayoutData((Object)listLayoutData);
            listComponent.setLayout((Layout)new FillLayout());
            List newList = new List(listComponent, viewerStyle);
            newList.setItems(listItems);
        }
    }

    private boolean isCopySrcSelected() {
        return this.copySrcSelected;
    }

    private FileCopyDescriptor getCopyDescriptor() {
        if (this.pTableModel == null) {
            System.err.println("No TableModel creating empty copy descriptor");
            return new FileCopyDescriptor(new File[0], new File[0], new String[0], new ArrayList());
        }
        ArrayList<File> srcFiles = new ArrayList<File>();
        ArrayList<File> destFiles = new ArrayList<File>();
        ArrayList<String> relDestPaths = new ArrayList<String>();
        int i = 0;
        while (i < this.pTableModel.getRowCount()) {
            if (this.pTableModel.isRowSelected(i)) {
                srcFiles.add(new File(this.conversionBag.getEclipseProjectLocation(), this.pTableModel.getSrcPath(i)));
                destFiles.add(new File(this.conversionBag.getEclipseProjectLocation(), this.pTableModel.getDestPath(i)));
                relDestPaths.add(this.pTableModel.getDestPath(i));
            }
            ++i;
        }
        ArrayList filter = new ArrayList();
        File[] src = srcFiles.toArray(new File[0]);
        File[] dest = destFiles.toArray(new File[0]);
        String[] rp = relDestPaths.toArray(new String[0]);
        FileCopyDescriptor fcd = new FileCopyDescriptor(src, dest, rp, filter);
        return fcd;
    }

    private ArrayList srcPathToCopy() {
        this.notCopy = new ArrayList();
        if (MDEBUG) {
            System.out.println("W-SRC:srcPathToCopy()");
        }
        ArrayList<EclipseClasspathEntry> copy = new ArrayList<EclipseClasspathEntry>();
        EclipseClasspathDescription ecd = this.conversionBag.getSrcPath();
        if (ecd == null) {
            return null;
        }
        Iterator i = ((AbstractList)ecd.getClasspathEntries()).iterator();
        while (i.hasNext()) {
            EclipseClasspathEntry ece = (EclipseClasspathEntry)i.next();
            if (ece.kind.equals("src") && ece.path.startsWith("..")) {
                if (MDEBUG) {
                    System.out.println("W-SRC:  TOCOPY:" + ece.kind + ":" + ece.path);
                }
                copy.add(ece);
                continue;
            }
            if (MDEBUG) {
                System.out.println("W-SRC:  NOTCOPY:" + ece.kind + ":" + ece.path);
            }
            this.notCopy.add(ece);
        }
        return copy;
    }

    private void enableUpdateComposite(boolean enabled) {
        if (this.tableViewer != null && this.tableViewer.getTable() != null) {
            this.tableViewer.getTable().setEnabled(enabled);
        }
        if (this.filterSelect != null) {
            this.filterSelect.setEnabled(enabled);
        }
        if (this.filterSelect_overwriteLabel != null) {
            this.filterSelect_overwriteLabel.setEnabled(enabled);
        }
    }

    private boolean validatePage() {
        if (MDEBUG) {
            System.out.println("W-SRC - validatePage()");
        }
        this.setPageComplete(false);
        if (this.conversionBag == null || this.conversionBag.getJpxWrapper() == null || this.conversionBag.getProjectName() == null) {
            return false;
        }
        if (!this.isCopySrcSelected()) {
            this.enableUpdateComposite(false);
        } else {
            this.enableUpdateComposite(true);
        }
        this.conversionBag.setCopySrc(this.isCopySrcSelected());
        FileCopyDescriptor fcd = this.getCopyDescriptor();
        this.conversionBag.setCopyDescriptor(fcd);
        EclipseClasspathDescription ecd = new EclipseClasspathDescription();
        Iterator i = ((AbstractList)this.notCopy).iterator();
        while (i.hasNext()) {
            EclipseClasspathEntry ece = (EclipseClasspathEntry)i.next();
            if (MDEBUG) {
                System.out.println("   notCopy " + ece.path);
            }
            ecd.addClasspathEntry(ece);
        }
        String[] pdest = fcd.destRelPath;
        int i2 = 0;
        while (i2 < pdest.length) {
            if (MDEBUG) {
                System.out.println("   do Copy " + pdest[i2]);
            }
            ecd.addClasspathSourceEntryRel(pdest[i2]);
            ++i2;
        }
        this.conversionBag.setSrcPath(ecd);
        this.setPageComplete(true);
        return true;
    }

    private String stringNotNull(String s, String description) {
        if (MDEBUG) {
            System.out.println(description + "=" + s);
        }
        return s == null ? "" : s;
    }

    private static ArrayList srcPathInProjectLocation(Jpx2EclipseProjectConverter conversionBag) {
        ArrayList<EclipseClasspathEntry> srcPath = new ArrayList<EclipseClasspathEntry>();
        String loc = conversionBag.getEclipseProjectLocation();
        JPXWrapper wrapper = conversionBag.getJpxWrapper();
        EclipseClasspathDescription ecd = Jpx2eclipseUtil.createSrcpathDescription(loc, wrapper);
        ArrayList al = ecd.getClasspathEntries();
        Iterator i = ((AbstractList)al).iterator();
        while (i.hasNext()) {
            EclipseClasspathEntry ece = (EclipseClasspathEntry)i.next();
            if (!ece.kind.equals("src") || ece.path.startsWith("..")) continue;
            srcPath.add(ece);
        }
        return srcPath;
    }

    public void resetControl() {
        this.setControl(null);
    }

    static class SelSrcTableModel
    extends DefaultTableModel {
        protected SelSrcTableModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        public boolean isCellEditable(int row, int col) {
            if (MDEBUG) {
                System.out.println("A-is cell Editable: " + row + "," + col + " selected: " + this.isRowSelected(row));
            }
            if (col == 0) {
                return true;
            }
            return col != 1;
        }

        protected boolean isRowSelected(int row) {
            if (row >= this.getRowCount()) {
                return false;
            }
            return (Boolean)this.getValueAt(row, 0);
        }

        protected String getSrcPath(int row) {
            if (row >= this.getRowCount()) {
                return null;
            }
            return (String)this.getValueAt(row, 1);
        }

        protected String getDestPath(int row) {
            if (row >= this.getRowCount()) {
                return null;
            }
            return (String)this.getValueAt(row, 2);
        }
    }

    class CopySrcSelector
    extends SelectionAdapter {
        Button selectionTrigger;
        boolean validatePage;

        protected CopySrcSelector(Button p_selectionTrigger, boolean p_validatePage) {
            this.selectionTrigger = p_selectionTrigger;
            this.validatePage = p_validatePage;
        }

        public void widgetSelected(SelectionEvent evt) {
            JpxImportSrcPage.this.copySrcSelected = this.selectionTrigger.getSelection();
            if (this.validatePage) {
                JpxImportSrcPage.this.validatePage();
            }
        }
    }

    class SelectionEnableDisableReactor
    extends SelectionAdapter {
        Button selectionTrigger;
        Control uiControl;
        boolean validatePage;

        protected SelectionEnableDisableReactor(Button p_selectionTrigger, Control p_uiControl, boolean p_validatePage) {
            this.selectionTrigger = p_selectionTrigger;
            this.uiControl = p_uiControl;
            this.validatePage = p_validatePage;
        }

        public void widgetSelected(SelectionEvent evt) {
            if (this.uiControl != null) {
                this.uiControl.setEnabled(this.selectionTrigger.getSelection());
            }
            if (this.validatePage) {
                JpxImportSrcPage.this.validatePage();
            }
        }
    }
}

