/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.wizards.jpx.ui;

import com.sap.ide.eclipse.wizards.jpx.tools.Jpx2EclipseProjectConverter;
import com.sap.ide.eclipse.wizards.jpx.tools.ProjectConstants;
import com.sap.ide.eclipse.wizards.jpx.ui.Jpx2eprjWizard;
import com.sap.ide.eclipse.wizards.jpx.ui.JpxImportSrcPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;

public class JpxImportLibPage
extends WizardPage
implements ProjectConstants {
    private static final boolean DEBUG = ProjectConstants.DEBUG_DEFAULT;
    private static final boolean INIT_SELECTION_DOIMPORT_BUTTON = true;
    private static final boolean INIT_SELECTION_IGNORE_ERRORS_BUTTON = false;
    public static final String TEXT_TITLE = "Import Libraries";
    public static final String TEXT_MESSAGE_DEFAULT = "Select if the libraries shall be converted automatically.";
    public static final String TEXT_MESSAGE_FAILS = "Not all library description files can be found. \nSelect \"ignore errors\" to import only parts of the libraries.";
    public static final String TEXT_UI_LABEL_INCOMPLETE = "Ignore errors.\n Missing libraries can be added manually in the Eclipse project settings";
    private IWorkbench workbench;
    private Jpx2EclipseProjectConverter converterBag;
    Composite jbselect;
    Label jblabel;
    Button doImportButton;
    Button dontImportButton;
    Button ignoreErrorsButton;
    List jpxLibList;

    protected JpxImportLibPage(Jpx2EclipseProjectConverter conversionBag, IWorkbench workbench) {
        super("jpx import, lib-page");
        if (DEBUG) {
            System.out.println("W-LIB:constructor");
        }
        this.workbench = workbench;
        this.converterBag = conversionBag;
    }

    public boolean isImportLibrarySelected() {
        if (this.doImportButton == null) {
            return true;
        }
        return this.doImportButton.getSelection();
    }

    public boolean isIgnoreErrorsSelected() {
        if (this.ignoreErrorsButton == null) {
            return false;
        }
        return this.ignoreErrorsButton.getSelection();
    }

    public String[] getJpxLibPath() {
        if (this.jpxLibList == null || !this.jpxLibList.isEnabled()) {
            return null;
        }
        String[] path = this.jpxLibList.getItems();
        return path;
    }

    public void setVisible(boolean visible) {
        if (DEBUG) {
            System.out.println("W-LIB:setVisible(" + visible + ")");
        }
        if (visible) {
            boolean canconvert = this.converterBag.canConvertLibs(null, false);
            boolean enableJBSelection = !canconvert;
            this.jblabel.setEnabled(enableJBSelection);
            if (this.jpxLibList != null) {
                this.jpxLibList.removeAll();
            }
            String[] paths = this.converterBag.getJpxLibraryPath();
            if (this.jpxLibList != null && paths != null) {
                int i = 0;
                while (i < paths.length) {
                    this.jpxLibList.add(paths[i]);
                    ++i;
                }
            }
            this.validatePage();
        }
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        if (DEBUG) {
            System.out.println("W-LIB:createControl()");
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite buttons = new Composite(composite, 0);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(768));
        this.dontImportButton = new Button(buttons, 16);
        this.dontImportButton.setText("Don't import libraries. Libraries will have to be set manually in the project settings");
        this.dontImportButton.setSelection(false);
        this.doImportButton = new Button(buttons, 16);
        this.doImportButton.setText("Import jpx libraries");
        this.doImportButton.setSelection(true);
        this.dontImportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JpxImportLibPage.this.validatePage();
            }
        });
        this.doImportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JpxImportLibPage.this.validatePage();
            }
        });
        this.jbselect = new Composite(composite, 0);
        this.jbselect.setLayout((Layout)new GridLayout());
        this.jbselect.setLayoutData((Object)new GridData(1808));
        this.jblabel = new Label(this.jbselect, 0);
        this.jblabel.setText("jpx library folders:");
        this.addJPXList(this.jbselect);
        this.ignoreErrorsButton = new Button(this.jbselect, 32);
        this.ignoreErrorsButton.setText(TEXT_UI_LABEL_INCOMPLETE);
        this.ignoreErrorsButton.setEnabled(false);
        this.ignoreErrorsButton.setSelection(false);
        this.ignoreErrorsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JpxImportLibPage.this.validatePage();
            }
        });
        this.setTitle(TEXT_TITLE);
        this.setControl((Control)composite);
        this.validatePage();
        this.setMessage(TEXT_MESSAGE_DEFAULT);
        this.setErrorMessage(null);
        if (DEBUG) {
            System.out.println("W-LIB:createControl()-end");
        }
    }

    private void addJPXList(Composite jbselect) {
        Composite listComp = new Composite(jbselect, 0);
        listComp.setLayout((Layout)new RowLayout(256));
        this.jpxLibList = new List(listComp, 2048);
        RowData listLayoutData = new RowData();
        listLayoutData.height = 100;
        listLayoutData.width = 300;
        this.jpxLibList.setLayoutData((Object)listLayoutData);
        String[] libPath = this.converterBag.getJpxLibraryPath();
        if (libPath != null) {
            int i = 0;
            while (i < libPath.length) {
                this.jpxLibList.add(libPath[i]);
                ++i;
            }
        }
        Composite buttonComponent = new Composite(listComp, 0);
        buttonComponent.setLayout((Layout)new GridLayout(1, false));
        Button b_add = new Button(buttonComponent, 8);
        Button b_rem = new Button(buttonComponent, 8);
        Button b_def = new Button(buttonComponent, 8);
        b_add.setLayoutData((Object)new GridData(768));
        b_rem.setLayoutData((Object)new GridData(768));
        b_def.setLayoutData((Object)new GridData(768));
        b_add.setText("Add Entry");
        b_rem.setText("Remove");
        b_def.setText("Defaults");
        b_add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog ddialog = new DirectoryDialog(JpxImportLibPage.this.jpxLibList.getShell());
                ddialog.setText("Add directory to libraray path");
                ddialog.setMessage("Selected directory must contain *.library files");
                String dir = ddialog.open();
                if (dir != null) {
                    JpxImportLibPage.this.jpxLibList.add(dir);
                }
                JpxImportLibPage.this.validatePage();
            }
        });
        b_rem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int i = JpxImportLibPage.this.jpxLibList.getSelectionIndex();
                if (i < 0) {
                    return;
                }
                JpxImportLibPage.this.jpxLibList.remove(i);
                JpxImportLibPage.this.validatePage();
            }
        });
        b_def.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JpxImportLibPage.this.restoreDefaults();
            }
        });
    }

    private void restoreDefaults() {
        if (this.converterBag.getJpxWrapper() != null) {
            this.jpxLibList.removeAll();
            String[] libPath = this.converterBag.getJpxWrapper().getDefaultJpxLibraryPath();
            if (libPath != null) {
                int i = 0;
                while (i < libPath.length) {
                    this.jpxLibList.add(libPath[i]);
                    ++i;
                }
            }
            this.ignoreErrorsButton.setSelection(false);
            this.dontImportButton.setSelection(false);
            this.doImportButton.setSelection(true);
            this.validatePage();
        }
    }

    private boolean validatePage() {
        if (DEBUG) {
            System.out.println("W-LIB:validatePage()");
        }
        this.setMessage(null);
        boolean val = true;
        if (!this.isImportLibrarySelected()) {
            val = true;
            this.setMessage(TEXT_MESSAGE_DEFAULT);
        } else if (this.converterBag.canConvertLibs(this.getJpxLibPath(), this.isIgnoreErrorsSelected())) {
            val = true;
            if (this.converterBag.canConvertLibs(this.getJpxLibPath(), false) && !this.ignoreErrorsButton.getSelection()) {
                this.ignoreErrorsButton.setEnabled(false);
            }
        } else {
            val = false;
            this.setMessage(TEXT_MESSAGE_FAILS);
            this.ignoreErrorsButton.setEnabled(true);
        }
        this.converterBag.setConvertLibraries(this.isImportLibrarySelected());
        this.converterBag.setJpxLibraryPath(this.getJpxLibPath());
        this.converterBag.setIgnoreErrors(this.isIgnoreErrorsSelected());
        if (DEBUG) {
            System.out.println("W-LIB:validatePage() - pageComplete? " + val);
        }
        this.setPageComplete(val);
        return val;
    }

    public IWizardPage getNextPage() {
        JpxImportSrcPage srcPage = ((Jpx2eprjWizard)this.getWizard()).getJpxImportSrcPage();
        srcPage.resetControl();
        return srcPage;
    }
}

