/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.wizards.jpx.ui;

import com.sap.ide.eclipse.wizards.jpx.tools.EclipseClasspathDescription;
import com.sap.ide.eclipse.wizards.jpx.tools.EclipseClasspathEntry;
import com.sap.ide.eclipse.wizards.jpx.tools.FileCopyDescriptor;
import com.sap.ide.eclipse.wizards.jpx.tools.IOUtils;
import com.sap.ide.eclipse.wizards.jpx.tools.Jpx2EclipseProjectConverter;
import com.sap.ide.eclipse.wizards.jpx.tools.ProjectConstants;
import com.sap.ide.eclipse.wizards.jpx.ui.JpxImportLibPage;
import com.sap.ide.eclipse.wizards.jpx.ui.JpxImportSrcPage;
import com.sap.ide.eclipse.wizards.jpx.ui.JpxImportStartPage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class Jpx2eprjWizard
extends Wizard
implements IImportWizard {
    private static final boolean DEBUG = ProjectConstants.DEBUG_DEFAULT;
    private static final String[] JPX_IMPORT_NATURE_IDS = new String[]{"org.eclipse.jdt.core.javanature"};
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private JpxImportStartPage mainPage;
    private JpxImportLibPage importLibPage;
    private JpxImportSrcPage importSrcPage;
    private Jpx2EclipseProjectConverter conversionBag = new Jpx2EclipseProjectConverter();
    private IWorkspace RES_Workspace = ResourcesPlugin.getWorkspace();
    private IWorkspaceRoot RES_WorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

    public boolean canFinish() {
        return this.conversionBag.canFinish();
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new JpxImportStartPage(this.conversionBag, this.workbench);
        this.importLibPage = new JpxImportLibPage(this.conversionBag, this.workbench);
        this.importSrcPage = new JpxImportSrcPage(this.conversionBag, this.workbench);
        this.addPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.importLibPage);
        this.addPage((IWizardPage)this.importSrcPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle("Import .jpx Project - beta version");
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(null);
        try {
            pmd.run(false, true, this.getRunnable());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        pmd.close();
        if (DEBUG) {
            System.out.println("WIZ-finish() - END");
        }
        return true;
    }

    private IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.conversionBag.getProjectName());
    }

    private IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.getProjectHandle());
    }

    private IPath getLocationPath() {
        String location = this.conversionBag.getEclipseProjectLocation();
        return new Path(location);
    }

    private IPath getOutputLocation() {
        String projName = this.getProjectHandle().getName();
        String outpath = null;
        ArrayList l_o = this.conversionBag.calculateOutPathDescriptions().getClasspathEntries();
        if (l_o.size() > 0) {
            EclipseClasspathEntry ece = (EclipseClasspathEntry)l_o.get(0);
            if (!ece.path.startsWith("..")) {
                outpath = ece.path;
            }
        }
        if (outpath == null) {
            outpath = projName + "/bin";
        }
        outpath = projName + "/bin";
        Path op = new Path(outpath);
        return op.makeAbsolute();
    }

    private ArrayList getPathEntries() {
        String projName = this.getProjectHandle().getName();
        ArrayList<IClasspathEntry> pathEntries = new ArrayList<IClasspathEntry>();
        EclipseClasspathDescription ecd_src = this.conversionBag.getSrcPath();
        EclipseClasspathDescription ecd_lib = this.conversionBag.calculateLibPathDescriptions();
        EclipseClasspathDescription ecd_out = this.conversionBag.calculateOutPathDescriptions();
        if (DEBUG) {
            System.out.println("  src-Path:" + ecd_src);
            System.out.println("  lib-Path:" + ecd_lib);
            System.out.println("  out-Path:" + ecd_out);
        }
        Iterator i = ((AbstractList)ecd_src.getClasspathEntries()).iterator();
        while (i.hasNext()) {
            EclipseClasspathEntry nextSrc = (EclipseClasspathEntry)i.next();
            pathEntries.add(nextSrc.convertToIClasspathEntry(projName));
        }
        Iterator i2 = ((AbstractList)ecd_lib.getClasspathEntries()).iterator();
        while (i2.hasNext()) {
            EclipseClasspathEntry nextLib = (EclipseClasspathEntry)i2.next();
            pathEntries.add(nextLib.convertToIClasspathEntry(projName));
        }
        pathEntries.add(JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), null, null));
        return pathEntries;
    }

    private static void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                int workLeft = 10;
                monitor.beginTask("creating Project", workLeft);
                IProject project = Jpx2eprjWizard.this.getProjectHandle();
                try {
                    try {
                        if (!project.exists()) {
                            IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
                            IPath locationPath = Jpx2eprjWizard.this.getLocationPath();
                            if (Platform.getLocation().equals((Object)locationPath) || Jpx2eprjWizard.this.conversionBag.isCreateInDefaultWorkspace()) {
                                locationPath = null;
                            }
                            desc.setLocation(locationPath);
                            project.create(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            --workLeft;
                        }
                        if (!project.isOpen()) {
                            project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            --workLeft;
                        }
                        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                            Jpx2eprjWizard.addNatureToProject(project, "org.eclipse.jdt.core.javanature", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            --workLeft;
                        }
                        Jpx2eprjWizard.doCopySrc(Jpx2eprjWizard.this.conversionBag, monitor, workLeft);
                        IRunnableWithProgress jrunnable = Jpx2eprjWizard.this.getJavaProjectSettingsRunnable(Jpx2eprjWizard.this.getJavaProject());
                        jrunnable.run((IProgressMonitor)new SubProgressMonitor(monitor, workLeft));
                        if (DEBUG) {
                            System.out.println("-- refresh project --");
                        }
                        project.close(null);
                        project.open(null);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
    }

    private static void ironOutPath(List pathEntries) {
        ArrayList<IClasspathEntry> allEntriesList = new ArrayList<IClasspathEntry>();
        Iterator i = pathEntries.iterator();
        while (i.hasNext()) {
            allEntriesList.add((IClasspathEntry)i.next());
        }
        ArrayList<IClasspathEntry> toRemove = new ArrayList<IClasspathEntry>();
        Iterator i2 = pathEntries.iterator();
        while (i2.hasNext()) {
            IClasspathEntry nextEntry = (IClasspathEntry)i2.next();
            int eqCount = 0;
            int all = 0;
            while (all < allEntriesList.size()) {
                if (nextEntry.equals(allEntriesList.get(all))) {
                    ++eqCount;
                }
                ++all;
            }
            if (eqCount <= true) continue;
            if (DEBUG) {
                System.out.println("found duplicate: " + nextEntry);
            }
            toRemove.add(nextEntry);
            ((AbstractCollection)allEntriesList).remove(nextEntry);
        }
        Iterator i3 = ((AbstractList)toRemove).iterator();
        while (i3.hasNext()) {
            pathEntries.remove(i3.next());
        }
    }

    private IRunnableWithProgress getJavaProjectSettingsRunnable(IJavaProject currJProject) {
        final ArrayList pathEntries = this.getPathEntries();
        final IPath path = this.getOutputLocation();
        final IJavaProject fCurrJProject = currJProject;
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("writing Java Project Settings", 10);
                try {
                    try {
                        Jpx2eprjWizard.ironOutPath(pathEntries);
                        if (DEBUG) {
                            System.out.println("finish - path entries = " + pathEntries);
                        }
                        Jpx2eprjWizard.this.createJavaProject(pathEntries, path, fCurrJProject, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
                if (DEBUG) {
                    System.out.println("-- finished project settings --");
                }
            }
        };
    }

    private void createJavaProject(List pathEntries, IPath buildPath, IJavaProject fCurrJProject, IProgressMonitor monitor) throws CoreException {
        monitor.worked(2);
        int numE = pathEntries.size();
        IClasspathEntry[] classpath = new IClasspathEntry[numE];
        int i = 0;
        while (i < numE) {
            classpath[i] = (IClasspathEntry)pathEntries.get(i);
            ++i;
        }
        monitor.worked(1);
        fCurrJProject.setRawClasspath(classpath, buildPath, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
    }

    private static void doCopySrc(Jpx2EclipseProjectConverter conversionBag, IProgressMonitor monitor, int workLeft) throws InvocationTargetException, InterruptedException {
        FileCopyDescriptor fcd;
        if (conversionBag.isCopySrcSelected() && (fcd = conversionBag.getCopyDescriptor()) != null) {
            if (DEBUG) {
                System.out.println("WIZ-finish() - copy sources");
            }
            SourceFilesCopyProcess sfcp = new SourceFilesCopyProcess(fcd);
            sfcp.run((IProgressMonitor)new SubProgressMonitor(monitor, workLeft));
        }
    }

    public static void jdt_createFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                Jpx2eprjWizard.jdt_createFolder((IFolder)parent, force, local, null);
            }
            folder.create(force, local, monitor);
        }
    }

    public JpxImportSrcPage getJpxImportSrcPage() {
        return this.importSrcPage;
    }

    static class SourceFilesCopyProcess
    implements IRunnableWithProgress {
        private FileCopyDescriptor fcd;

        public SourceFilesCopyProcess(FileCopyDescriptor p_fcd) {
            this.fcd = p_fcd;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Copying Sources", this.fcd.src.length);
            if (DEBUG) {
                System.out.println("WIZ: SRC-copy - Copying Sources" + this.fcd.src.length);
            }
            this.copySources(monitor);
        }

        private void copySources(IProgressMonitor monitor) {
            int worked = 0;
            int i = 0;
            while (i < this.fcd.src.length) {
                monitor.subTask("copy sources: " + i);
                monitor.worked(worked++);
                try {
                    if (DEBUG) {
                        System.out.println("W-COPY:toDir=" + this.fcd.dest[i] + ",from=" + this.fcd.src[i]);
                    }
                    if (!this.fcd.dest[i].exists()) {
                        this.fcd.dest[i].mkdirs();
                    }
                    File[] childFiles = this.fcd.src[i].listFiles();
                    int cfIndex = 0;
                    while (childFiles != null && cfIndex < childFiles.length) {
                        IOUtils.copyRecursive(childFiles[cfIndex], IOUtils.getFullFilename(this.fcd.dest[i]));
                        ++cfIndex;
                    }
                }
                catch (IOException e_io) {
                    e_io.printStackTrace();
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                ++i;
            }
        }
    }
}

