/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.wizards.jpx.tools;

import com.sap.ide.eclipse.wizards.jpx.tools.EclipseClasspathDescription;
import com.sap.ide.eclipse.wizards.jpx.tools.IOUtils;
import com.sap.ide.eclipse.wizards.jpx.tools.JPXLibrary;
import com.sap.ide.eclipse.wizards.jpx.tools.JPXWrapper;
import com.sap.ide.eclipse.wizards.jpx.tools.ProjectConstants;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class Jpx2eclipseUtil {
    private static final boolean DEBUG = ProjectConstants.DEBUG_JBPATHSTUFF;
    public static final String PI_RESOURCES = "com.sap.ide.eclipse.wizards.jpx.tools";
    public static final String TEXT_MSGERR_PROJ_EXISTS = "A project already exists in the selected directory.";
    private static final boolean USE_LIB_SRCPATH = false;
    private static final boolean USE_LIB_DOCPATH = false;
    public static final String CLASSPATH_VAR = "var";
    public static final String CLASSPATH_LIB = "lib";
    public static final String CLASSPATH_SRC = "src";
    public static final String CLASSPATH_OUT = "output";

    public static JPXWrapper createJPXWrapper(String jpxFile) {
        File f = new File(jpxFile);
        String jpxFileDir = IOUtils.getFullFilename(f.getParentFile());
        String jpxFileName = IOUtils.getFilename(f);
        return Jpx2eclipseUtil.createJPXWrapper(jpxFileDir, jpxFileName);
    }

    public static JPXWrapper createJPXWrapper(String jpxFileDir, String jpxFileName) {
        return new JPXWrapper(jpxFileDir, jpxFileName);
    }

    protected static String suggestLocation_deprecated(JPXWrapper jproj) {
        String commonroot;
        String basepath = jproj.getSysProperty("WorkingDirectory");
        basepath = IOUtils.getFullFilename(new File(jproj.getJpxDir(), basepath));
        if (DEBUG) {
            System.out.println("first suggestion:" + basepath);
        }
        if ((commonroot = Jpx2eclipseUtil.getSourcesLongestCommonPrefix(jproj)).length() == 0) {
            if (DEBUG) {
                System.out.println("no common prefix found => have to copy sources");
            }
            if (!Jpx2eclipseUtil.isAcceptableBasePath(new File(basepath))) {
                if (DEBUG) {
                    System.out.println("path " + basepath + " is not acceptable to create a new project");
                }
                basepath = Jpx2eclipseUtil.createNewSubdir(basepath, jproj.getJpxFileNameWithoutExtension());
            }
        } else {
            if (DEBUG) {
                System.out.println("common prefix : " + commonroot);
            }
            if (Jpx2eclipseUtil.isAcceptableBasePath(new File(commonroot))) {
                if (DEBUG) {
                    System.out.println("checked path for other eclipse projects, seems to be clean");
                }
                basepath = commonroot;
            } else {
                if (DEBUG) {
                    System.out.println("path " + commonroot + " is not acceptable to create a new project");
                }
                basepath = Jpx2eclipseUtil.createNewSubdir(commonroot, jproj.getJpxFileNameWithoutExtension());
            }
        }
        return basepath;
    }

    protected static String createNewSubdir(String basepath, String dirname) {
        String compoundPath;
        String newPath = basepath + File.separator + dirname;
        File f = new File(newPath);
        if (!f.exists()) {
            compoundPath = newPath;
        } else {
            int i = 0;
            while (f.exists()) {
                f = new File(newPath + ++i);
            }
            compoundPath = newPath + i;
        }
        return compoundPath;
    }

    protected static boolean isAcceptableBasePath(File path) {
        boolean acceptable = true;
        String fileToCheck = ".project";
        Stack<File> dirs = new Stack<File>();
        dirs.push(path);
        File f = null;
        try {
            while (!dirs.empty() && acceptable) {
                f = (File)dirs.pop();
                if (f.isFile()) {
                    String name = IOUtils.getFilename(f);
                    if (!name.equals(fileToCheck)) continue;
                    acceptable = false;
                    continue;
                }
                if (!f.isDirectory()) continue;
                File[] children = f.listFiles();
                int i = children.length - 1;
                while (i >= 0) {
                    dirs.push(children[i]);
                    --i;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return acceptable;
    }

    public static IStatus isValidProjectLocation(String location) {
        File f;
        IStatus isValidDir = ResourcesPlugin.getWorkspace().validateProjectLocation(ResourcesPlugin.getWorkspace().getRoot().getProject("dummy"), (IPath)new Path(location));
        if (isValidDir.isOK() && (f = new File(location)).exists() && f.isDirectory() && new File(f, ".project").exists()) {
            isValidDir = new Status(4, PI_RESOURCES, 4, TEXT_MSGERR_PROJ_EXISTS, null);
        }
        return isValidDir;
    }

    public static EclipseClasspathDescription createLibpathDescription(JPXWrapper jproj, String[] p_jpxLibraryPath, boolean ignoreErrors) {
        if (DEBUG) {
            System.out.println("JpxUtil:createLibpathDescription");
        }
        EclipseClasspathDescription ecd = new EclipseClasspathDescription();
        if (DEBUG) {
            System.out.println("-------------");
        }
        String libpath = jproj.getSysProperty("Libraries");
        String[] libp = jproj.tokenizeSysPath(libpath);
        int i = 0;
        while (i < libp.length) {
            JPXLibrary jblib;
            if (DEBUG) {
                System.out.println("----\nlibp[" + i + "] - name:" + libp[i]);
            }
            if ((jblib = Jpx2eclipseUtil.loadJPXLibrary(libp[i], p_jpxLibraryPath)).getClassPath(true) == null && !ignoreErrors) {
                return null;
            }
            if (DEBUG) {
                System.out.println("LIB:" + jblib);
            }
            String lp_src_abs = null;
            String lp_root = null;
            String lp_path_abs = jblib.getClassPath(true);
            String[] lp_p_abs = jproj.tokenizeSysPath(lp_path_abs);
            int j = 0;
            while (j < lp_p_abs.length) {
                if (lp_src_abs == null) {
                    ecd.addClasspathLibEntryAbs(lp_p_abs[j]);
                } else {
                    ecd.addClasspathEntryAbs(CLASSPATH_LIB, lp_p_abs[j], lp_root, lp_src_abs);
                }
                ++j;
            }
            ++i;
        }
        return ecd;
    }

    public static EclipseClasspathDescription createSrcpathDescription(String location, JPXWrapper jproj) {
        EclipseClasspathDescription ecd = new EclipseClasspathDescription();
        if (DEBUG) {
            System.out.println("-------------");
        }
        String srcpath = jproj.getSysProperty("SourcePath");
        String[] srcp = jproj.tokenizeSysPath(srcpath);
        int i = 0;
        while (i < srcp.length) {
            if (DEBUG) {
                System.out.println("----\nsrcp[" + i + "] - rel:" + srcp[i]);
            }
            File srcpathFile = new File(jproj.getJpxDir(), srcp[i]);
            String rel_src = IOUtils.getRelativePath(new File(location), srcpathFile);
            if (DEBUG) {
                System.out.println("srcp[" + i + "] - loc:" + rel_src);
            }
            ecd.addClasspathSourceEntryRel(rel_src);
            ++i;
        }
        return ecd;
    }

    public static EclipseClasspathDescription createOutpathDescription(String location, JPXWrapper jproj) {
        String outpath;
        EclipseClasspathDescription ecd = new EclipseClasspathDescription();
        if (DEBUG) {
            System.out.println("-------------");
        }
        if ((outpath = jproj.getSysProperty("OutPath")) != null) {
            if (DEBUG) {
                System.out.println("outpath - rel:" + outpath);
            }
            File outpathFile = new File(jproj.getJpxDir(), outpath);
            String abs_out = IOUtils.getFullFilename(outpathFile);
            if (DEBUG) {
                System.out.println("outpath - abs:" + abs_out);
            }
            ecd.addClasspathOutEntryAbs(abs_out);
        }
        return ecd;
    }

    public static JPXLibrary loadJPXLibrary(String libname, String[] libraryPath) {
        return JPXLibrary.loadLibrary(libname, libraryPath);
    }

    protected static String getSourcesLongestCommonPrefix(JPXWrapper jproj) {
        File f;
        String prefix = "";
        String srcpath = jproj.getSysProperty("SourcePath");
        String[] srcp = jproj.tokenizeSysPath(srcpath);
        if (srcp.length > 0) {
            f = new File(jproj.getJpxDir(), srcp[0]);
            prefix = IOUtils.getFullFilename(f);
        }
        int i = 1;
        while (i < srcp.length) {
            f = new File(jproj.getJpxDir(), srcp[i]);
            prefix = IOUtils.longestCommonPrefix(f, new File(prefix));
            ++i;
        }
        return prefix;
    }

    public static void copySources(File srcBase, File destBase) throws IOException {
        IOUtils.copyRecursive(srcBase, IOUtils.getFullFilename(destBase));
    }
}

