/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.wizards.jpx.tools;

import com.sap.ide.eclipse.wizards.jpx.tools.EclipseClasspathDescription;
import com.sap.ide.eclipse.wizards.jpx.tools.EclipseClasspathEntry;
import com.sap.ide.eclipse.wizards.jpx.tools.FileCopyDescriptor;
import com.sap.ide.eclipse.wizards.jpx.tools.IOUtils;
import com.sap.ide.eclipse.wizards.jpx.tools.JPXWrapper;
import com.sap.ide.eclipse.wizards.jpx.tools.Jpx2eclipseUtil;
import com.sap.ide.eclipse.wizards.jpx.tools.ProjectConstants;
import java.io.File;
import java.io.FilenameFilter;
import java.util.AbstractList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class Jpx2EclipseProjectConverter
implements ProjectConstants {
    private static final boolean DEBUG = ProjectConstants.DEBUG_JBUTILS;
    private JPXWrapper jpxWrapper;
    private String projectName;
    private String projectLocation;
    private boolean createInDefaultWorkspace;
    private boolean convertLibs;
    private String[] jpxLibraryPath;
    private boolean ignoreErrors;
    private boolean copySrc = true;
    private FileCopyDescriptor copyDescriptor;
    private EclipseClasspathDescription srcPath;

    public Jpx2EclipseProjectConverter() {
        this.initLevel2();
    }

    public boolean canFinish() {
        String location = this.getEclipseProjectLocation();
        if (location == null || location.length() == 0) {
            return false;
        }
        boolean locOK = false;
        locOK = this.isCreateInDefaultWorkspace() ? new Path("").isValidPath(location) : Jpx2eclipseUtil.isValidProjectLocation(location).isOK();
        if (!locOK) {
            return false;
        }
        boolean l_convertLibs = this.convertLibs;
        if (l_convertLibs && !this.ignoreErrors && !this.canConvertLibs(this.jpxLibraryPath, this.ignoreErrors)) {
            return false;
        }
        if (this.isCopySrcSelected()) {
            EclipseClasspathDescription srcList = this.getSrcPath();
            if (srcList == null) {
                return false;
            }
            Iterator i = ((AbstractList)srcList.getClasspathEntries()).iterator();
            while (i.hasNext()) {
                String nextPath = ((EclipseClasspathEntry)i.next()).path;
                if (DEBUG) {
                    System.out.println("W-CONV:canFinish:nextPath:" + nextPath);
                }
                if (!nextPath.startsWith("..")) continue;
                return false;
            }
        }
        return true;
    }

    public JPXWrapper getJpxWrapper() {
        return this.jpxWrapper;
    }

    public void setJpxWrapper(String jpxFile) {
        this.createJPXWrapper(jpxFile);
        this.initLevel2();
        this.initLevel3();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getEclipseProjectLocation() {
        return this.projectLocation;
    }

    public void setEclipseProjectLocation(String location) {
        this.projectLocation = location;
        this.initLevel2();
        this.initLevel3();
    }

    public boolean isCreateInDefaultWorkspace() {
        return this.createInDefaultWorkspace;
    }

    public void setCreateInDefaultWorkspace(boolean cr) {
        this.createInDefaultWorkspace = cr;
    }

    private void initLevel2() {
        this.convertLibs = true;
        this.ignoreErrors = false;
        this.jpxLibraryPath = null;
        if (this.jpxWrapper != null) {
            this.jpxLibraryPath = this.jpxWrapper.getDefaultJpxLibraryPath();
        }
    }

    public void setJpxLibraryPath(String[] p_path) {
        this.jpxLibraryPath = p_path;
    }

    public String[] getJpxLibraryPath() {
        return this.jpxLibraryPath;
    }

    public void setConvertLibraries(boolean p_convert) {
        this.convertLibs = p_convert;
    }

    public void setIgnoreErrors(boolean p_ignoreErrors) {
        this.ignoreErrors = p_ignoreErrors;
    }

    public void initLevel3() {
        this.copySrc = true;
        this.srcPath = null;
        this.copyDescriptor = null;
        if (this.projectLocation != null && this.jpxWrapper != null) {
            this.initSrcPathDescriptions();
        }
    }

    public void setCopySrc(boolean p_copy) {
        this.copySrc = p_copy;
    }

    public boolean isCopySrcSelected() {
        return this.copySrc;
    }

    public boolean isCopySrcDescrAvailable() {
        EclipseClasspathDescription ecd = this.getSrcPath();
        if (ecd == null) {
            return true;
        }
        Iterator i = ((AbstractList)ecd.getClasspathEntries()).iterator();
        while (i.hasNext()) {
            EclipseClasspathEntry ece = (EclipseClasspathEntry)i.next();
            if (!ece.kind.equals("src") || !ece.path.startsWith("..")) continue;
            return true;
        }
        return false;
    }

    public void setSrcPath(EclipseClasspathDescription p_srcPath) {
        this.srcPath = p_srcPath;
    }

    public EclipseClasspathDescription getSrcPath() {
        if (this.jpxWrapper == null || this.projectLocation == null) {
            return null;
        }
        if (this.srcPath == null) {
            this.initSrcPathDescriptions();
        }
        return this.srcPath;
    }

    public void setCopyDescriptor(FileCopyDescriptor p_copyDescriptor) {
        this.copyDescriptor = p_copyDescriptor;
    }

    public FileCopyDescriptor getCopyDescriptor() {
        return this.copyDescriptor;
    }

    protected void initSrcPathDescriptions() {
        if (this.projectLocation == null || this.jpxWrapper == null) {
            if (this.projectLocation == null) {
                System.err.println("Jpx2EclipseProjectConverter: could not create eclipse src-path, since project location is not specified");
            }
            if (this.jpxWrapper == null) {
                System.err.println("Jpx2EclipseProjectConverter: could not create eclipse src-path, since jpx project file is not specified");
            }
            return;
        }
        this.srcPath = Jpx2eclipseUtil.createSrcpathDescription(this.getEclipseProjectLocation(), this.jpxWrapper);
    }

    public EclipseClasspathDescription calculateLibPathDescriptions() throws IllegalArgumentException {
        return this.calculateLibPathDescriptions(this.jpxLibraryPath, this.ignoreErrors);
    }

    private EclipseClasspathDescription calculateLibPathDescriptions(String[] jpxLibPath, boolean ignoreErrors) throws IllegalArgumentException {
        if (this.projectLocation == null || this.jpxWrapper == null) {
            throw new IllegalArgumentException("eclipse location or jpxWrapper not yet specified");
        }
        return Jpx2eclipseUtil.createLibpathDescription(this.jpxWrapper, jpxLibPath, ignoreErrors);
    }

    public EclipseClasspathDescription calculateOutPathDescriptions() throws IllegalArgumentException {
        if (this.projectLocation == null || this.jpxWrapper == null) {
            throw new IllegalArgumentException("eclipse location or jpxWrapper not yet specified");
        }
        return Jpx2eclipseUtil.createOutpathDescription(this.getEclipseProjectLocation(), this.jpxWrapper);
    }

    private void createJPXWrapper(String jpxFile) {
        this.jpxWrapper = Jpx2eclipseUtil.createJPXWrapper(jpxFile);
        String newName = this.jpxWrapper.getJpxFileNameWithoutExtension();
        IStatus nameValid = ResourcesPlugin.getWorkspace().validateName(newName, 4);
        int i = 1;
        while (!nameValid.isOK()) {
            newName = newName + i++;
            nameValid = Jpx2EclipseProjectConverter.validateProjectName(newName);
            if (i <= 1000) continue;
            System.err.println("could not find valid project name");
            break;
        }
        this.projectName = newName;
        this.projectLocation = this.suggestLocation(this.jpxWrapper);
    }

    public static IStatus validateProjectName(String projectName) {
        IProject proj;
        IStatus is = ResourcesPlugin.getWorkspace().validateName(projectName, 4);
        if (!is.isOK() || (proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).exists()) {
            // empty if block
        }
        return is;
    }

    public boolean canConvertLibs(String[] jpxLibraryPath, boolean ignoreErrors) {
        boolean canconv;
        if (DEBUG) {
            System.out.println("W-CONV:canConvertLibs(" + jpxLibraryPath + ", " + ignoreErrors + ")");
        }
        if (this.jpxWrapper == null) {
            if (DEBUG) {
                System.out.println("W-CONV:canConvertLibs:error jpxWrapper == null");
            }
            return false;
        }
        EclipseClasspathDescription ecd = Jpx2eclipseUtil.createLibpathDescription(this.jpxWrapper, jpxLibraryPath, ignoreErrors);
        boolean bl = canconv = ecd != null;
        if (DEBUG) {
            System.out.println("  e-loc = " + this.projectLocation);
        }
        if (DEBUG) {
            System.out.println("  result:" + canconv);
        }
        return canconv;
    }

    protected String suggestLocation(JPXWrapper jproj) {
        String basepath = jproj.getSysProperty("WorkingDirectory");
        basepath = IOUtils.getFullFilename(new File(jproj.getJpxDir(), basepath));
        if (DEBUG) {
            System.out.println("first suggestion:" + basepath);
        }
        IStatus locValid = Jpx2eclipseUtil.isValidProjectLocation(basepath);
        if (DEBUG) {
            System.out.println("WIZ: finish() - validate location " + basepath + " =>" + locValid);
        }
        FilenameFilter fnf = new FilenameFilter(){

            public boolean accept(File arg0, String arg1) {
                return arg1.equals(".project");
            }
        };
        File p1 = new File(basepath);
        boolean projectDir = false;
        while (p1 != null && !projectDir) {
            if (p1.exists() && p1.list(fnf).length > 0) {
                projectDir = true;
            }
            if (projectDir) continue;
            p1 = p1.getParentFile();
        }
        if (DEBUG) {
            System.out.println("W-BAG: suggestLocation: project in root:" + projectDir + ", stopped at" + p1);
        }
        if (!locValid.isOK() && projectDir) {
            File baseFile = p1.getParentFile();
            String extName = this.getProjectName();
            int i = 1;
            while (new File(baseFile, extName + i).exists()) {
                if (++i > 10000) break;
            }
            return IOUtils.getFullFilename(new File(baseFile, extName + i));
        }
        if (!locValid.isOK()) {
            File baseFile = new File(basepath);
            String extName = this.getProjectName();
            int i = 1;
            while (new File(baseFile, extName + i).exists()) {
                if (++i > 1000) break;
            }
            return IOUtils.getFullFilename(new File(baseFile, extName + i));
        }
        return basepath;
    }
}

