/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.wizards.jpx.tools;

import com.sap.ide.eclipse.wizards.jpx.tools.JPXReader;
import com.sap.ide.eclipse.wizards.jpx.tools.ProjectConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class JPXWrapper
implements ProjectConstants {
    public static final String[] JB_INSTALL_DEFAULTS = new String[]{"c:/JBuilder", "c:/JBuilder5", "c:/JBuilder6", "c:/Program Files/JBuilder", "c:/Program Files/JBuilder5", "c:/Program Files/JBuilder6", "c:/Programme/JBuilder", "c:/Programme/JBuilder5", "c:/Programme/JBuilder6"};
    private JPXReader jpxReader;
    private String jpxFile;
    private String jpxDir;
    protected static String cl_homeDir = System.getProperty("user.home");
    private ArrayList sysPropertyNames = null;
    private Hashtable sysProperties = null;

    public JPXWrapper(String jpxFileDir, String jpxFileName) {
        this.jpxDir = jpxFileDir;
        this.jpxFile = jpxFileName;
        this.jpxReader = new JPXReader(jpxFileDir, jpxFileName);
    }

    public String getJpxDir() {
        return this.jpxDir;
    }

    public String getJpxFileNameWithoutExtension() {
        String name = this.jpxFile;
        int idx = this.jpxFile.lastIndexOf(".jpx");
        if (idx < 0) {
            idx = this.jpxFile.lastIndexOf(".");
        }
        return name.substring(0, idx);
    }

    public String[] getDefaultJpxLibraryPath() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.getJpxDir());
        File ftest = new File(cl_homeDir, ".jbuilder5");
        if (ftest.exists() && ftest.isDirectory()) {
            l.add(ftest.getAbsolutePath());
        }
        if ((ftest = new File(cl_homeDir, ".jbuilder6")).exists() && ftest.isDirectory()) {
            l.add(ftest.getAbsolutePath());
        }
        int i = 0;
        while (i < JB_INSTALL_DEFAULTS.length) {
            ftest = new File(JB_INSTALL_DEFAULTS[i], "lib");
            if (ftest.exists() && ftest.isDirectory()) {
                l.add(ftest.getAbsolutePath());
            }
            ++i;
        }
        String[] path = new String[l.size()];
        int i2 = 0;
        while (i2 < l.size()) {
            path[i2] = (String)l.get(i2);
            ++i2;
        }
        return path;
    }

    public ArrayList getSysPropertyNames() {
        if (this.sysPropertyNames == null) {
            this.sysPropertyNames = new ArrayList();
            this.sysProperties = this.jpxReader.getSysProperties();
            this.sysPropertyNames.addAll(this.sysProperties.keySet());
        }
        return this.sysPropertyNames;
    }

    public String getSysProperty(String name) {
        ArrayList names = this.getSysPropertyNames();
        if (!names.contains(name)) {
            return null;
        }
        return (String)this.sysProperties.get(name);
    }

    public String[] tokenizeSysPath(String syspath) {
        if (syspath == null) {
            String[] se = new String[]{};
            return se;
        }
        StringTokenizer st = new StringTokenizer(syspath, ";");
        String[] tokens = new String[st.countTokens()];
        int i = 0;
        while (i < tokens.length) {
            tokens[i] = st.nextToken();
            ++i;
        }
        return tokens;
    }

    public String[] getFilePaths() {
        String[] path = new String[]{};
        return path;
    }

    public static void main(String[] args) {
        System.out.println("WARNING: this is a test routine");
        String jpxFile = "teststuff1.jpx";
        String jpxDir = "C:/work/projects/jpx2eclipse/testjpx";
        JPXWrapper jw = new JPXWrapper(jpxDir, jpxFile);
        JPXWrapper.test1(jw);
    }

    private static void test1(JPXWrapper jw) {
        ArrayList sn = jw.getSysPropertyNames();
        System.out.println("----------------------------------------------");
        System.out.println("----------------------------------------------");
        System.out.println("all sys properties:\n" + sn);
        System.out.println("----------------------------------------------");
        System.out.println("jpx dir    :" + jw.getJpxDir());
        System.out.println("working dir:" + jw.getSysProperty("WorkingDirectory"));
        System.out.println("source path:" + jw.getSysProperty("SourcePath"));
        System.out.println("out dir    :" + jw.getSysProperty("OutPath"));
        System.out.println("Libraries  :" + jw.getSysProperty("Libraries"));
        System.out.println("----------------------------------------------");
        System.out.println("----------------------------------------------");
    }
}

