/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.wizards.jpx.tools;

import com.sap.ide.eclipse.wizards.jpx.tools.ProjectConstants;
import java.io.File;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JPXReader
implements ProjectConstants {
    private Hashtable sysProperties = null;
    private String jpxFile;
    private String jpxDir;
    private Document jpxxmlDoc;

    public JPXReader(String jpxDir, String jpxFile) {
        this.jpxDir = jpxDir;
        this.jpxFile = jpxFile;
        this.initParser();
    }

    private void initParser() {
        File jpxSourceFile = new File(this.jpxDir, this.jpxFile);
        try {
            DocumentBuilderFactoryImpl dbf = new DocumentBuilderFactoryImpl();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.jpxxmlDoc = db.parse(jpxSourceFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Hashtable getSysProperties() {
        if (this.sysProperties == null) {
            this.parseJPX();
        }
        return this.sysProperties;
    }

    private void parseJPX() {
        this.sysProperties = new Hashtable();
        NodeList nl = this.jpxxmlDoc.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node next;
            if (!(next = nl.item(i++)).getNodeName().equalsIgnoreCase("project")) continue;
            this.internalizeProject(next);
        }
    }

    private void internalizeProject(Node project) {
        NodeList children = project.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node next;
            if ((next = children.item(i++)).getNodeName().equalsIgnoreCase("property")) {
                String category = next.getAttributes().getNamedItem("category").getNodeValue();
                String name = next.getAttributes().getNamedItem("name").getNodeValue();
                String value = next.getAttributes().getNamedItem("value").getNodeValue();
                if (category.equals("sys")) {
                    this.sysProperties.put(name, value);
                    continue;
                }
                if (!ProjectConstants.DEBUG_NYI) continue;
                System.out.println("NYI:category " + category + " not yet implemented");
                continue;
            }
            if (!next.getNodeName().equalsIgnoreCase("node") && !next.getNodeName().equalsIgnoreCase("file")) continue;
        }
    }
}

