/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.wizards.jpx.tools;

import com.sap.ide.eclipse.wizards.jpx.tools.IOUtils;
import com.sap.ide.eclipse.wizards.jpx.tools.ProjectConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;

public class JPXLibrary {
    private static final boolean DEBUG = ProjectConstants.DEBUG_JBLIBS;
    private String libname;
    private String location;
    private String classPath;
    private String sourcePath;
    private String apidocPath;
    private String classPathAbs;
    private String sourcePathAbs;
    private String apidocPathAbs;

    private JPXLibrary(String libname) {
        this.libname = libname;
    }

    public String getClassPath(boolean absolute) {
        if (!absolute) {
            return this.classPath;
        }
        return this.classPathAbs;
    }

    public String getSourcePath(boolean absolute) {
        if (!absolute) {
            return this.sourcePath;
        }
        return this.sourcePathAbs;
    }

    public String getDocumentationPath(boolean absolute) {
        if (!absolute) {
            return this.apidocPath;
        }
        return this.apidocPathAbs;
    }

    private void createAbsPaths() {
        this.classPathAbs = this.createAbsPath(this.classPath, this.location);
        this.sourcePathAbs = this.createAbsPath(this.sourcePath, this.location);
        this.apidocPathAbs = this.createAbsPath(this.apidocPath, this.location);
    }

    private String createAbsPath(String path, String basedir) {
        StringBuffer pb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(path, ";");
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            int devidx = next.indexOf("%|");
            if (devidx < 0) {
                pb.append(IOUtils.getFullFilename(new File(basedir, next.trim())));
            } else {
                String newName = next.substring(0, devidx) + ":" + next.substring(devidx + 2);
                pb.append(IOUtils.getFullFilename(new File(newName)));
            }
            if (!st.hasMoreTokens()) continue;
            pb.append(";");
        }
        return pb.toString();
    }

    public static JPXLibrary loadLibrary(String libname, String[] libraryPath) {
        JPXLibrary lib = null;
        if (libraryPath != null) {
            int i = 0;
            while (i < libraryPath.length && lib == null) {
                lib = JPXLibrary.loadLibrary(libname, libraryPath[i]);
                ++i;
            }
        } else if (DEBUG) {
            System.err.println("\nWARNING: JPXLibrary:loadLibrary() with libraryPath == null");
        }
        if (lib == null) {
            lib = new JPXLibrary(libname);
        }
        return lib;
    }

    private static String appendToPath(String path, String subdir) {
        path = path.endsWith("/") || path.endsWith("\\") ? path + subdir : path + "/" + subdir;
        return path;
    }

    /*
     * WARNING - void declaration
     */
    protected static JPXLibrary loadLibrary(String libname, String basedir) {
        File f;
        if (DEBUG) {
            System.out.println("search for " + libname + ".library in " + basedir);
        }
        if (!(f = new File(basedir, libname + ".library")).exists()) {
            return null;
        }
        JPXLibrary jbl = new JPXLibrary(libname);
        jbl.location = basedir;
        jbl.classPath = "";
        jbl.sourcePath = "";
        jbl.apidocPath = "";
        try {
            String line;
            BufferedReader bf = new BufferedReader(new FileReader(f));
            while ((line = bf.readLine()) != null) {
                String path;
                int end;
                int start;
                void var5_6;
                line = var5_6.trim();
                if (line.startsWith("<class>")) {
                    while (!(line = bf.readLine().trim()).equals("</class>")) {
                        start = line.indexOf("<path>");
                        end = line.indexOf("</path>");
                        path = line.substring(start + "<path>".length(), end);
                        if (path.startsWith("[")) {
                            path = path.substring(1, path.length() - 1);
                        }
                        jbl.classPath = jbl.classPath.length() == 0 ? path : jbl.classPath + ";" + path;
                    }
                    continue;
                }
                if (line.startsWith("<source>")) {
                    while (!(line = bf.readLine().trim()).equals("</source>")) {
                        start = line.indexOf("<path>");
                        end = line.indexOf("</path>");
                        path = line.substring(start + "<path>".length(), end);
                        if (path.startsWith("[")) {
                            path = path.substring(1, path.length() - 1);
                        }
                        jbl.sourcePath = jbl.sourcePath.length() == 0 ? path : jbl.classPath + ";" + path;
                    }
                    continue;
                }
                if (!line.startsWith("<documentation>")) continue;
                while (!(line = bf.readLine().trim()).equals("</documentation>")) {
                    start = line.indexOf("<path>");
                    end = line.indexOf("</path>");
                    path = line.substring(start + "<path>".length(), end);
                    if (path.startsWith("[")) {
                        path = path.substring(1, path.length() - 1);
                    }
                    jbl.apidocPath = jbl.apidocPath.length() == 0 ? path : jbl.classPath + ";" + path;
                }
            }
        }
        catch (NullPointerException e) {
            System.err.println("Error parsing " + libname + " in " + basedir);
            System.err.println("file doesn't seem to be correct library file");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
        jbl.createAbsPaths();
        return jbl;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("JPXLibrary - " + this.libname);
        sb.append("\nlocation " + this.location);
        sb.append("\nclasses  " + this.classPath);
        sb.append("\nsource   " + this.sourcePath);
        sb.append("\napidoc   " + this.apidocPath);
        sb.append("\nclassesAbs  " + this.classPathAbs);
        sb.append("\nsourceAbs   " + this.sourcePathAbs);
        sb.append("\napidocAbs   " + this.apidocPathAbs);
        return sb.toString();
    }
}

