/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.wizards.jpx.tools;

import com.sap.ide.eclipse.wizards.jpx.tools.ProjectConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;

public class IOUtils {
    public static final boolean DEBUG = ProjectConstants.DEBUG_JBUTILS;

    public static int longestMatch(String a, String b) {
        char[] cb;
        char[] ca = a.toCharArray();
        int len = ca.length < (cb = b.toCharArray()).length ? ca.length : cb.length;
        int i = 0;
        while (i < len) {
            if (ca[i] != cb[i]) break;
            ++i;
        }
        return i;
    }

    public static String longestCommonPrefix(File a, File b) {
        String as = IOUtils.getFullFilename(a);
        String bs = IOUtils.getFullFilename(b);
        StringBuffer commonPath = new StringBuffer();
        StringTokenizer ast = new StringTokenizer(as, File.separator);
        StringTokenizer bst = new StringTokenizer(bs, File.separator);
        while (ast.hasMoreTokens() && bst.hasMoreTokens()) {
            String next = ast.nextToken();
            if (!next.equals(bst.nextToken())) continue;
            if (commonPath.length() > 0) {
                commonPath.append(File.separatorChar);
            }
            commonPath.append(next);
        }
        return commonPath.toString();
    }

    public static int countOccurrence(String str, char c) {
        int index = 0;
        char[] chars = str.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == c) {
                ++index;
            }
            ++i;
        }
        return index;
    }

    public static String getFullFilename(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e_io) {
            return file.getAbsolutePath();
        }
    }

    public static String getFilename(File file) {
        String complete = IOUtils.getFullFilename(file);
        int idx = complete.lastIndexOf(File.separatorChar);
        if (idx < 0) {
            return complete;
        }
        return complete.substring(idx + 1);
    }

    public static String getRelativePath(File basePath, File filename) {
        String commonPrxf;
        int is;
        String file = IOUtils.getFullFilename(filename);
        if (DEBUG) {
            System.out.println("file " + file);
        }
        String base = IOUtils.getFullFilename(basePath);
        if (DEBUG) {
            System.out.println("base " + base);
        }
        if ((is = (commonPrxf = IOUtils.longestCommonPrefix(basePath, filename)).length()) == 0) {
            return file;
        }
        if (file.startsWith(base)) {
            String newName = file.substring(is);
            if (newName.startsWith(File.separator)) {
                return newName.substring(1);
            }
            return newName;
        }
        String fileremains = file.substring(is);
        String baseremains = base.substring(is);
        if (baseremains.startsWith(File.separator)) {
            baseremains = baseremains.substring(1);
        }
        if (fileremains.startsWith(File.separator)) {
            fileremains = fileremains.substring(1);
        }
        if (!baseremains.endsWith(File.separator)) {
            baseremains = baseremains + File.separator;
        }
        int numberOfSeparators = IOUtils.countOccurrence(baseremains, File.separatorChar);
        StringBuffer newName = new StringBuffer();
        int i = 0;
        while (i < numberOfSeparators) {
            newName.append(".." + File.separator);
            ++i;
        }
        newName.append(fileremains);
        return newName.toString();
    }

    public static void copyRecursive(File src, String destDir) throws IOException {
        if (DEBUG) {
            System.out.println("COPY: copyRecursive from:" + src + " ,to:" + destDir);
        }
        String destFile = destDir + File.separator + IOUtils.getFilename(src);
        if (src.isFile()) {
            IOUtils.copyFile(src, new File(destFile));
        } else if (src.isDirectory()) {
            File[] children = src.listFiles();
            int i = 0;
            while (i < children.length) {
                IOUtils.copyRecursive(children[i], destFile);
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void copyFile(File src, File dest) throws IOException {
        int c;
        if (DEBUG) {
            System.out.println("copy from:" + src + " ,to:" + dest);
        }
        File inputFile = src;
        File outputFile = dest;
        if (!outputFile.exists()) {
            outputFile.getParentFile().mkdirs();
            outputFile.createNewFile();
        }
        FileInputStream in = new FileInputStream(inputFile);
        FileOutputStream out = new FileOutputStream(outputFile);
        while ((c = in.read()) != -1) {
            void var6_6;
            out.write((int)var6_6);
        }
        in.close();
        out.close();
    }
}

