/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.wizards.jpx.tools;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;

public class EclipseClasspathEntry {
    public String kind;
    public String path;
    public String rootpath;
    public String sourcepath;

    public EclipseClasspathEntry(String kind, String path) {
        this.kind = kind;
        this.path = path;
    }

    public EclipseClasspathEntry(String kind, String path, String rootpath, String sourcepath) {
        this.kind = kind;
        this.path = path;
        this.sourcepath = sourcepath;
        this.rootpath = rootpath;
    }

    public String toString() {
        return this.toXml();
    }

    public IClasspathEntry convertToIClasspathEntry(String projectName) {
        if (this.kind.equalsIgnoreCase("lib")) {
            Path ipathClasses = new Path(this.path);
            Path ipathSrc = null;
            Path ipathRoot = null;
            if (ipathSrc != null) {
                ipathSrc = new Path(this.sourcepath);
            }
            if (ipathRoot != null) {
                ipathRoot = new Path(this.rootpath);
            }
            return JavaCore.newLibraryEntry((IPath)ipathClasses, (IPath)ipathSrc, ipathRoot);
        }
        if (this.kind.equalsIgnoreCase("src")) {
            Path ipath = new Path("/" + projectName + "/" + this.path);
            ipath.makeAbsolute();
            return JavaCore.newSourceEntry((IPath)ipath);
        }
        if (this.kind.equalsIgnoreCase("output")) {
            return null;
        }
        if (this.kind.equalsIgnoreCase("var")) {
            Path ipathVar = new Path(this.path);
            Path ipathSrc = null;
            Path ipathRoot = null;
            if (ipathSrc != null) {
                ipathSrc = new Path(this.sourcepath);
            }
            if (ipathRoot != null) {
                ipathRoot = new Path(this.rootpath);
            }
            return JavaCore.newVariableEntry((IPath)ipathVar, (IPath)ipathSrc, ipathRoot);
        }
        System.err.println("Warning in EclipseClasspathEntry: " + this.kind + " is not a valid path type");
        return null;
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<classpathentry kind=\"" + this.kind + "\" path=\"" + this.path + "\"");
        if (this.rootpath != null) {
            sb.append(" rootpath=\"" + this.rootpath + "\"");
        }
        if (this.sourcepath != null) {
            sb.append(" sourcepath=\"" + this.sourcepath + "\"");
        }
        sb.append("/>");
        return sb.toString();
    }
}

