/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.sap;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnDifference;
import com.sap.dictionary.database.dbs.DbColumnsDifference;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.sap.DbSapColumn;
import com.sap.dictionary.database.sap.DbSapEnvironment;

public class DbSapColumnsDifference
extends DbColumnsDifference {
    public DbObjectSqlStatements getDdlStatementsForAlter(String tableName) throws Exception {
        DbColumn column;
        DbObjectSqlStatements statements = new DbObjectSqlStatements(tableName);
        DbColumnsDifference.MultiIterator iterator = this.iterator();
        String addCmd = "ALTER TABLE \"" + tableName + "\" ADD ( ";
        String dropCmd = "ALTER TABLE \"" + tableName + "\" DROP ";
        String modifyCmd = "ALTER TABLE \"" + tableName + "\" MODIFY ( ";
        String columnCmd = "ALTER TABLE \"" + tableName + "\" COLUMN ";
        iterator = this.iterator();
        DbSqlStatement statement = new DbSqlStatement();
        while (iterator.hasNextWithDrop()) {
            column = iterator.nextWithDrop().getOrigin();
            statement.addLine("\"" + column.getName() + (iterator.hasNextWithDrop() ? "\", " : "\""));
        }
        this.addStatement(statements, statement, dropCmd, false);
        while (iterator.hasNextWithAdd()) {
            column = iterator.nextWithAdd().getTarget();
            statement = new DbSqlStatement();
            statement.addLine("\"" + column.getName() + "\" " + column.getDdlTypeClause());
            this.addStatement(statements, statement, addCmd, true);
            if (column.getJavaSqlType() == -4) {
                statement = new DbSqlStatement();
                statement.addLine(((DbSapColumn)column).getDdlLongVarbinaryClause(tableName));
                statements.add(statement);
            }
            if (column.getDefaultValue() != null) {
                if (column.isNotNull()) {
                    statement = new DbSqlStatement();
                    statement.addLine("UPDATE \"" + tableName + "\" ");
                    statement.addLine("SET \"" + column.getName() + "\" = " + column.getJavaSqlTypeInfo().getDefaultValuePrefix() + column.getDefaultValue() + column.getJavaSqlTypeInfo().getDefaultValueSuffix());
                    statement.addLine(" WHERE \"" + column.getName() + "\" IS NULL ");
                    statements.add(statement);
                }
                statement = new DbSqlStatement();
                statement.addLine("\"" + column.getName() + "\" ADD DEFAULT " + column.getJavaSqlTypeInfo().getDefaultValuePrefix() + column.getDefaultValue() + column.getJavaSqlTypeInfo().getDefaultValueSuffix());
                this.addStatement(statements, statement, columnCmd, false);
            }
            statement = new DbSqlStatement();
            if (column.isNotNull()) {
                statement.addLine("\"" + column.getName() + "\" NOT NULL ");
            }
            this.addStatement(statements, statement, columnCmd, false);
        }
        while (iterator.hasNextWithTypeLenDecChange()) {
            DbColumnDifference difference = iterator.nextWithTypeLenDecChange();
            if (difference.getAction() != Action.ALTER) continue;
            column = difference.getTarget();
            if (column.getJavaSqlType() == -4 && !DbSapEnvironment.isSpecJ2EEColumn(tableName, column.getName(), null)) {
                statement = new DbSqlStatement();
                statement.addLine(((DbSapColumn)column).getDdlLongVarbinaryClause(tableName));
                statements.add(statement);
                continue;
            }
            statement = new DbSqlStatement();
            statement.addLine("\"" + column.getName() + "\" " + column.getDdlTypeClause());
            this.addStatement(statements, statement, modifyCmd, true);
        }
        statement = new DbSqlStatement();
        while (iterator.hasNextWithDefaultValueChange()) {
            column = iterator.nextWithDefaultValueChange().getTarget();
            if (column.getDefaultValue() != null) {
                statement.addLine("\"" + column.getName() + "\" " + column.getDdlDefaultValueClause() + (iterator.hasNextWithDefaultValueChange() ? " , " : ""));
                continue;
            }
            statement.addLine("\"" + column.getName() + "\" DEFAULT NULL" + (iterator.hasNextWithDefaultValueChange() ? " , " : ""));
        }
        this.addStatement(statements, statement, modifyCmd, true);
        while (iterator.hasNextWithNullabilityChange()) {
            column = iterator.nextWithNullabilityChange().getTarget();
            if (!column.isNotNull()) continue;
            statement = new DbSqlStatement();
            statement.addLine("UPDATE \"" + tableName + "\" ");
            statement.addLine("SET \"" + column.getName() + "\" = " + column.getJavaSqlTypeInfo().getDefaultValuePrefix() + column.getDefaultValue() + column.getJavaSqlTypeInfo().getDefaultValueSuffix());
            statement.addLine(" WHERE \"" + column.getName() + "\" IS NULL ");
            statements.add(statement);
        }
        statement = new DbSqlStatement();
        DbColumnsDifference.MultiIterator iterator1 = this.iterator();
        while (iterator1.hasNextWithNullabilityChange()) {
            column = iterator1.nextWithNullabilityChange().getTarget();
            if (column.isNotNull()) {
                statement.addLine("\"" + column.getName() + "\" NOT NULL" + (iterator1.hasNextWithNullabilityChange() ? " , " : ""));
                continue;
            }
            statement.addLine("\"" + column.getName() + "\" NULL" + (iterator1.hasNextWithNullabilityChange() ? " , " : ""));
        }
        this.addStatement(statements, statement, modifyCmd, true);
        return statements;
    }

    private void addStatement(DbObjectSqlStatements statements, DbSqlStatement statement, String s, boolean close_bracket) {
        if (!statement.isEmpty()) {
            if (close_bracket) {
                statement.addLine(" ) ");
            }
            DbSqlStatement st = new DbSqlStatement();
            st.addLine(s);
            st.merge(statement);
            statements.add(st);
        }
    }
}

