/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.sap;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnDifference;
import com.sap.dictionary.database.dbs.DbColumnDifferencePlan;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.sap.DbSapEnvironment;
import com.sap.dictionary.database.sap.JavaSapSqlTypeInfo;
import com.sap.tc.logging.Location;
import java.text.SimpleDateFormat;

public class DbSapColumn
extends DbColumn {
    private static Location loc = Logger.getLocation("sap.DbSapColumn");

    public DbSapColumn(DbFactory factory) {
        super(factory);
    }

    public DbSapColumn(DbFactory factory, DbColumn other) {
        super(factory, other);
    }

    public DbSapColumn(DbFactory factory, XmlMap xmlMap) {
        super(factory, xmlMap);
    }

    public DbSapColumn(DbFactory factory, String name, int position, int javaSqlType, String dbType, long length, int decimals, boolean isNotNull, String defaultValue) {
        if (dbType.equals("FIXED")) {
            if (length == 19L) {
                javaSqlType = -5;
                length = 0L;
            } else {
                javaSqlType = 3;
            }
        } else if (dbType.equals("FLOAT")) {
            if (length == 38L) {
                javaSqlType = 8;
                length = 0L;
            } else if (length == 16L) {
                javaSqlType = 7;
                length = 0L;
            } else {
                javaSqlType = 6;
            }
        } else if (dbType.equals("LONG ASCII") || dbType.equals("LONG UNICODE")) {
            javaSqlType = 2005;
        } else if (dbType.equals("LONG BYTE")) {
            javaSqlType = 2004;
        } else if (dbType.equals("VARCHAR() BYTE")) {
            javaSqlType = length > 255L ? -3 : -2;
        }
        if (length > 0L && !factory.getJavaSqlTypes().getInfo(javaSqlType).hasLengthAttribute()) {
            length = 0L;
        }
        this.constructorPart(factory, name, position, javaSqlType, dbType, length, decimals, isNotNull, defaultValue);
    }

    public String getDdlTypeClause() throws Exception {
        loc.entering("getDdlTypeClause");
        String clause = "";
        clause = DbSapEnvironment.isSpecJ2EEColumn(this.getColumns().getTable().getName(), this.getName(), this.getJavaSqlTypeName()) ? "VARCHAR(" + this.getLength() + ") BYTE" : super.getDdlTypeClause();
        loc.exiting();
        return clause;
    }

    public String getDdlDefaultValueClause() throws Exception {
        loc.entering("getDdlDefaultValueClause");
        try {
            String defVal;
            String clause = "";
            int javaSqlType = super.getJavaSqlType();
            JavaSapSqlTypeInfo javaSqlTypeInfo = (JavaSapSqlTypeInfo)super.getJavaSqlTypeInfo();
            if (javaSqlTypeInfo.hasDefaultValue() && (defVal = super.getDefaultValue()) != null) {
                if (javaSqlType == 91 || javaSqlType == 92 || javaSqlType == 93) {
                    if (defVal.equalsIgnoreCase("DATE") || defVal.equalsIgnoreCase("TIME") || defVal.equalsIgnoreCase("TIMESTAMP")) {
                        clause = "DEFAULT " + defVal.toUpperCase();
                    } else {
                        SimpleDateFormat orgFormatter = (SimpleDateFormat)javaSqlTypeInfo.getFormatterForDefaultString();
                        SimpleDateFormat myFormatter = (SimpleDateFormat)javaSqlTypeInfo.getTargetFormatterForDefaultString();
                        try {
                            defVal = myFormatter.format(orgFormatter.parse(defVal));
                        }
                        catch (Exception ex) {
                            Object[] arguments = new Object[]{ex.toString(), defVal, orgFormatter.toPattern(), myFormatter.toPattern()};
                            loc.errorT("Exception caught reformatting default value:\n  {0}\n  Failed to convert {1} from {2} to {3}.", arguments);
                            loc.exiting();
                            throw JddException.createInstance(ex);
                        }
                        clause = "DEFAULT " + javaSqlTypeInfo.getDefaultValuePrefix() + defVal + javaSqlTypeInfo.getDefaultValueSuffix();
                    }
                } else {
                    clause = super.getDdlDefaultValueClause();
                }
            }
            loc.exiting();
            return clause;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDdlDefaultValueClause failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public String getDdlClause() throws Exception {
        loc.entering("getDdlClause");
        String clause = "";
        clause = super.getDdlClause();
        loc.exiting();
        return clause;
    }

    public DbObjectSqlStatements getDdlStatementsForLongVarbinary(String name) {
        loc.entering("getDdlStatementsForLongVarinary");
        DbObjectSqlStatements dbObjectSqlStatements = new DbObjectSqlStatements(name);
        DbSqlStatement dbSqlStatement = new DbSqlStatement();
        dbSqlStatement.addLine(this.getDdlLongVarbinaryClause(name));
        dbObjectSqlStatements.add(dbSqlStatement);
        loc.exiting();
        return dbObjectSqlStatements;
    }

    public String getDdlLongVarbinaryClause(String tabName) {
        loc.entering("getDdlLongVarbinbaryClause");
        String clause = "COMMENT ON COLUMN \"" + tabName + "\".\"" + this.getName() + "\" " + "IS '" + this.getJavaSqlTypeName() + " (" + this.getLength() + ")'";
        loc.exiting();
        return clause;
    }

    public DbColumnDifference compareTo(DbColumn target) throws Exception {
        Object[] arguments;
        String dbTypeOfOrgCol;
        loc.entering("compareTo");
        Object colDiff = null;
        DbSapColumn orgCol = this;
        DbSapColumn targetCol = null;
        DbColumnDifferencePlan plan = new DbColumnDifferencePlan();
        boolean hasToConvert = false;
        targetCol = (DbSapColumn)target;
        int orgType = orgCol.getJavaSqlType();
        int targetType = targetCol.getJavaSqlType();
        if (!(orgType == targetType || (orgType == 7 || orgType == 6 || orgType == 8) && (targetType == 7 || targetType == 6 || targetType == 8) || orgType == 12 && targetType == -1 || orgType == -1 && targetType == 12 || orgType == -2 && targetType == -3 || orgType == -3 && targetType == -2 || orgType == -3 && targetType == -4 && DbSapEnvironment.isSpecJ2EEColumn(this.getColumns().getTable().getName(), this.getName(), null) || orgType == 2004 && targetType == -4)) {
            plan.setTypeIsChanged(true);
            Object[] arguments2 = new Object[]{this.getName(), orgCol.getJavaSqlTypeName(), targetCol.getJavaSqlTypeName()};
            if (orgType != 5 || targetType != 4) {
                hasToConvert = true;
                loc.infoT("compareTo ({0}): CONVERT: original type {1} incompatible to target type {2}", arguments2);
            } else {
                loc.infoT("compareTo ({0}): ALTER type from {1} to {2}", arguments2);
            }
        }
        if (!hasToConvert && this.getColumns().getTable().getDbFactory().getConnection() != null && (dbTypeOfOrgCol = orgCol.getDbType()) != null && dbTypeOfOrgCol.equals("LONG BYTE") && DbSapEnvironment.isSpecJ2EEColumn(this.getColumns().getTable().getName(), this.getName(), this.getJavaSqlTypeName())) {
            plan.setTypeIsChanged(true);
            hasToConvert = true;
            Object[] arguments3 = new Object[]{this.getName(), orgCol.getDbType(), new Long(targetCol.getLength())};
            loc.infoT("compareTo ({0}): CONVERT: original type {1} incompatible to target type VARCHAR({2}) BYTE", arguments3);
        }
        if (!hasToConvert && (orgCol.getJavaSqlTypeInfo().hasLengthAttribute() || orgType == -4 || orgType == 2004 && targetType == -4)) {
            long orgLength = orgCol.getLength();
            long targetLength = targetCol.getLength();
            if (orgLength == 0L) {
                orgLength = orgCol.getJavaSqlTypeInfo().getDdlDefaultLength();
            }
            if (targetLength == 0L) {
                targetLength = targetCol.getJavaSqlTypeInfo().getDdlDefaultLength();
            }
            if (orgLength != targetLength) {
                plan.setLengthIsChanged(true);
                arguments = new Object[]{this.getName(), new Long(orgLength), new Long(targetLength)};
                if (orgLength > targetLength) {
                    hasToConvert = true;
                    loc.infoT("compareTo ({0}): CONVERT: original length {1} greater than target length {2}", arguments);
                } else {
                    loc.infoT("compareTo ({0}): ALTER length from {1} to {2}", arguments);
                }
            }
        }
        if (!hasToConvert && orgCol.getJavaSqlTypeInfo().hasDecimals() && orgCol.getDecimals() != targetCol.getDecimals()) {
            plan.setDecimalsAreChanged(true);
            if (orgCol.getDecimals() > targetCol.getDecimals()) {
                hasToConvert = true;
                Object[] arguments4 = new Object[]{this.getName(), new Long(orgCol.getDecimals()), new Long(targetCol.getDecimals())};
                loc.infoT("compareTo ({0}): CONVERT: original decimals {1} greater than target decimals {2}", arguments4);
            } else {
                long precTarget;
                long precOrigin = orgCol.getLength() - (long)orgCol.getDecimals();
                if (precOrigin > (precTarget = targetCol.getLength() - (long)targetCol.getDecimals())) {
                    hasToConvert = true;
                    arguments = new Object[]{this.getName(), new Long(precOrigin), new Long(precTarget)};
                    loc.infoT("compareTo ({0}): CONVERT: original precision {1} greater than target precision {2}", arguments);
                } else {
                    arguments = new Object[]{this.getName(), new Long(orgCol.getDecimals()), new Long(precOrigin), new Long(targetCol.getDecimals()), new Long(precTarget)};
                    loc.infoT("compareTo ({0}): ALTER decimals from ({1}.{2}) to ({3}.{4})", arguments);
                }
            }
        }
        if (!hasToConvert && orgCol.isNotNull() != targetCol.isNotNull()) {
            plan.setNullabilityIsChanged(true);
            Object[] arguments5 = new Object[]{this.getName()};
            if (targetCol.isNotNull() && targetCol.getDefaultValue() == null) {
                hasToConvert = true;
                loc.infoT("compareTo ({0}): CONVERT: NULL to NOT NULL without a default value", arguments5);
            } else if (targetCol.isNotNull()) {
                loc.infoT("compareTo ({0}): ALTER column to NOT NULL", arguments5);
            } else {
                loc.infoT("compareTo ({0}): ALTER column to NULL", arguments5);
            }
        }
        if (!hasToConvert) {
            if (orgCol.getDefaultValue() == null) {
                if (targetCol.getDefaultValue() != null) {
                    plan.setDefaultValueIsChanged(true);
                    Object[] arguments6 = new Object[]{this.getName(), targetCol.getDefaultValue()};
                    loc.infoT("compareTo ({0}): ALTER default to {1}", arguments6);
                }
            } else if (targetCol.getDefaultValue() == null) {
                plan.setDefaultValueIsChanged(true);
                loc.infoT("compareTo ({0}): ALTER default to NULL", new Object[]{this.getName()});
            } else {
                String orgDefVal = orgCol.getDefaultValue();
                String targetDefVal = targetCol.getDefaultValue();
                boolean differs = false;
                switch (targetType) {
                    case -5: 
                    case 4: 
                    case 5: {
                        long targetIntVal = Long.valueOf(targetDefVal);
                        long orgIntVal = Long.valueOf(orgDefVal);
                        differs = targetIntVal != orgIntVal;
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 8: {
                        double targetFloatVal = Double.valueOf(targetDefVal);
                        double orgFloatVal = Double.valueOf(orgDefVal);
                        differs = targetFloatVal != orgFloatVal;
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        if (orgDefVal.equalsIgnoreCase(targetDefVal)) break;
                        SimpleDateFormat orgFormatter = (SimpleDateFormat)targetCol.getJavaSqlTypeInfo().getFormatterForDefaultString();
                        SimpleDateFormat myFormatter = (SimpleDateFormat)((JavaSapSqlTypeInfo)targetCol.getJavaSqlTypeInfo()).getTargetFormatterForDefaultString();
                        try {
                            targetDefVal = myFormatter.format(orgFormatter.parse(targetDefVal));
                        }
                        catch (Exception ex) {
                            Object[] arguments7 = new Object[]{ex.toString(), targetDefVal, orgFormatter.toPattern(), myFormatter.toPattern()};
                            loc.errorT("Exception caught reformatting default value:\n  {0}\n  Failed to convert {1} from {2} to {3}.", arguments7);
                            loc.exiting();
                            throw JddException.createInstance(ex);
                        }
                        if (orgDefVal.equals(targetDefVal)) break;
                        differs = true;
                        break;
                    }
                    default: {
                        if (orgDefVal.equals(targetDefVal)) break;
                        differs = true;
                    }
                }
                if (differs) {
                    plan.setDefaultValueIsChanged(true);
                    Object[] arguments8 = new Object[]{this.getName(), targetCol.getDefaultValue()};
                    loc.infoT("compareTo ({0}): ALTER default to {1}", arguments8);
                }
            }
        }
        if (hasToConvert) {
            loc.exiting();
            return new DbColumnDifference(this, target, plan, Action.CONVERT);
        }
        if (plan.somethingIsChanged()) {
            loc.exiting();
            return new DbColumnDifference(this, target, plan, Action.ALTER);
        }
        loc.exiting();
        return null;
    }

    public boolean acceptedAdd() {
        return true;
    }

    public boolean acceptedDrop() {
        return true;
    }

    public boolean checkNameLength() {
        loc.entering("checkNameLength");
        int nameLen = this.getName().length();
        int maxLen = DbSapEnvironment.MaxNameLength();
        if (nameLen > 0 && nameLen <= maxLen) {
            loc.exiting();
            return true;
        }
        Object[] arguments = new Object[]{this.getName(), new Integer(nameLen), new Integer(maxLen)};
        loc.errorT("checkNameLength {0}: length {1} invalid (allowed range [1..{2}])", arguments);
        loc.exiting();
        return false;
    }

    public boolean checkNameForReservedWord() {
        loc.entering("checkNameForReservedWord");
        boolean isReserved = DbSapEnvironment.isReservedWord(this.getName());
        if (isReserved) {
            Object[] arguments = new Object[]{this.getName()};
            loc.errorT("{0} is a reserved word", arguments);
        }
        loc.exiting();
        return !isReserved;
    }

    public boolean checkTypeAttributes() {
        loc.entering("checkTypeAttributes");
        boolean check = true;
        switch (this.getJavaSqlType()) {
            case 2: 
            case 3: {
                Object[] arguments;
                long len = this.getLength();
                long maxLen = DbSapEnvironment.MaxDecimalLength();
                if (len < 0L || len > maxLen) {
                    check = false;
                    arguments = new Object[]{this.getName(), new Long(len), new Long(maxLen)};
                    loc.errorT("checkTypeAttributes {0}: a length of {1} is invalid for decimal-fields (allowed range [1..{2}])", arguments);
                }
                if (len >= (long)this.getDecimals()) break;
                check = false;
                arguments = new Object[]{this.getName(), new Integer(this.getDecimals()), new Long(len)};
                loc.errorT("checkTypeAttributes {0}: scale {1} is greater than precision {2}", arguments);
                break;
            }
            case -3: 
            case -2: {
                long len = this.getLength();
                long maxLen = DbSapEnvironment.MaxBinaryLength();
                if (len >= 0L && len <= maxLen) break;
                check = false;
                Object[] arguments = new Object[]{this.getName(), new Long(len), new Long(maxLen)};
                loc.errorT("checkTypeAttributes {0}: length of {1} is out of range for binary-fields (allowed range [1..{2}])", arguments);
                break;
            }
            case 1: 
            case 12: {
                long len = this.getLength();
                long maxLen = DbSapEnvironment.MaxCharacterLength();
                if (len >= 0L && len <= maxLen) break;
                check = false;
                Object[] arguments = new Object[]{this.getName(), new Long(len), new Long(maxLen)};
                loc.errorT("checkTypeAttributes {0}: length of {1} is out of range for character-fields (allowed range [1..{2}])", arguments);
            }
        }
        loc.exiting();
        return check;
    }
}

