/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.ora;

import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndex;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbIndexDifference;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.ora.DbOraEnvironment;
import com.sap.dictionary.database.ora.DbOraSegmentAttributes;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DbOraIndex
extends DbIndex {
    private DbOraSegmentAttributes segmentAttributes = null;
    private static Location location = Logger.getLocation("ora.DbOraIndex");

    public DbOraIndex() {
    }

    public DbOraIndex(DbFactory factory) {
        super(factory);
    }

    public DbOraIndex(DbFactory factory, DbIndex other) {
        super(factory, other);
    }

    public DbOraIndex(DbFactory factory, String tablename, String name) {
        super(factory, tablename, name);
    }

    public DbOraIndex(DbFactory factory, DbSchema schema, String tablename, String name) {
        super(factory, schema, tablename, name);
    }

    public void writeSpecificContentToXmlFile(PrintWriter file, String offset0) throws JddException {
        try {
            try {
                location.entering("writeSpecificContentToXmlFile");
                file.println(offset0 + "<index name=" + "\"" + this.getName() + "\">");
                String offset1 = offset0 + XmlHelper.tabulate();
                String offset2 = offset1 + XmlHelper.tabulate();
                if (this.segmentAttributes != null) {
                    file.println(offset1 + "<physical-properties>");
                    this.segmentAttributes.writeContentToXmlFile(file, offset2);
                    file.println(offset1 + "</physical-properties>");
                }
                file.println(offset0 + "</index>");
            }
            catch (Exception exception) {
                Object[] arguments = new Object[]{exception.getMessage()};
                location.errorT("writeSpecificContentToXmlFile failed: {0}", arguments);
                throw JddException.createInstance(exception);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
    }

    public void setSpecificContentViaXml(XmlMap xmlMap) throws JddException {
        try {
            block4: {
                try {
                    location.entering("setSpecificContentViaXml");
                    XmlMap physicalProperties = xmlMap.getXmlMap("physical-properties");
                    if (physicalProperties.isEmpty()) break block4;
                    XmlMap xmlSegmentAttributes = physicalProperties.getXmlMap("segment-attributes");
                    DbOraSegmentAttributes newSegmentAttributes = new DbOraSegmentAttributes();
                    newSegmentAttributes.setContentViaXml(xmlSegmentAttributes);
                    if (newSegmentAttributes.isNull()) break block4;
                    this.segmentAttributes = newSegmentAttributes;
                }
                catch (Exception exception) {
                    Object[] arguments = new Object[]{exception.getMessage()};
                    location.errorT("setSpecificContentViaXml failed: {0}", arguments);
                    throw JddException.createInstance(exception);
                }
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
    }

    public void setCommonContentViaDb() throws JddException {
        try {
            try {
                location.entering("setCommonContentViaDb");
                boolean isUnique = false;
                boolean isPrimaryKey = false;
                ArrayList<DbIndexColumnInfo> columnsInfo = new ArrayList<DbIndexColumnInfo>();
                Connection connection = this.getDbFactory().getConnection();
                PreparedStatement preparedStatement = NativeSQLAccess.prepareNativeStatement((Connection)connection, (String)"SELECT \"UNIQUENESS\" FROM   \"USER_INDEXES\" WHERE  \"INDEX_NAME\" = ? AND    \"TABLE_NAME\" = ? ");
                preparedStatement.setString(1, this.getName().toUpperCase());
                preparedStatement.setString(2, this.getTableName().toUpperCase());
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    isUnique = resultSet.getString(1).equals("UNIQUE");
                }
                preparedStatement.close();
                resultSet.close();
                preparedStatement = NativeSQLAccess.prepareNativeStatement((Connection)connection, (String)"SELECT   \"COLUMN_NAME\" FROM     \"USER_IND_COLUMNS\" WHERE    \"INDEX_NAME\" = ? AND      \"TABLE_NAME\" = ? ORDER BY \"COLUMN_POSITION\" ");
                preparedStatement.setString(1, this.getName().toUpperCase());
                preparedStatement.setString(2, this.getTableName().toUpperCase());
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    DbIndexColumnInfo indexColumnInfo = new DbIndexColumnInfo(resultSet.getString(1), false);
                    columnsInfo.add(indexColumnInfo);
                }
                preparedStatement.close();
                resultSet.close();
                this.setContent(isUnique, columnsInfo);
            }
            catch (Exception exception) {
                Object[] arguments = new Object[]{exception.getMessage()};
                location.errorT("setCommonContentViaDb failed: {0}", arguments);
                throw JddException.createInstance(exception);
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
    }

    public void setSpecificContentViaDb() throws JddException {
        try {
            try {
                Connection connection = this.getDbFactory().getConnection();
                PreparedStatement preparedStatement = NativeSQLAccess.prepareNativeStatement((Connection)connection, (String)"SELECT * FROM   \"USER_INDEXES\" WHERE  \"INDEX_NAME\" = ? AND    \"TABLE_NAME\" = ? ");
                preparedStatement.setString(1, this.getName().toUpperCase());
                preparedStatement.setString(2, this.getTableName().toUpperCase());
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    this.segmentAttributes.setContentViaDbCatalog(connection, resultSet, "USER_INDEXES");
                }
                preparedStatement.close();
                resultSet.close();
            }
            catch (Exception exception) {
                Object[] arguments = new Object[]{exception.getMessage()};
                location.errorT("setSpecificContentViaDb failed: {0}", arguments);
                throw JddException.createInstance(exception);
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DbIndexDifference compareTo(DbIndex target) throws JddException {
        DbIndexDifference dbIndexDifference;
        block6: {
            DbIndexDifference dbIndexDifference2;
            block5: {
                try {
                    try {
                        location.entering("compareTo");
                        DbIndexDifference indexDifference = null;
                        if (!this.getDbSpecificIsSet()) {
                            dbIndexDifference2 = super.compareTo(target);
                            Object var6_6 = null;
                            break block5;
                        }
                        dbIndexDifference = indexDifference;
                        break block6;
                    }
                    catch (Exception exception) {
                        Object[] arguments = new Object[]{target.getName(), exception.getMessage()};
                        location.errorT("compareTo ({0}) failed: {1}", arguments);
                        throw JddException.createInstance(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    location.exiting();
                    throw throwable;
                }
            }
            location.exiting();
            return dbIndexDifference2;
        }
        Object var6_7 = null;
        location.exiting();
        return dbIndexDifference;
    }

    public boolean existsOnDb() throws JddException {
        location.entering("existsOnDb");
        boolean exists = false;
        try {
            try {
                Connection connection = this.getDbFactory().getConnection();
                Statement statement = NativeSQLAccess.createNativeStatement((Connection)connection);
                ResultSet resultSet = statement.executeQuery("SELECT 1 FROM   \"DUAL\" WHERE  EXISTS(SELECT *               FROM   \"DBA_INDEXES\"               WHERE  \"INDEX_NAME\" = '" + this.getName().toUpperCase() + "' " + "              AND    \"TABLE_NAME\" = '" + this.getTableName().toUpperCase() + "') ");
                if (resultSet.next()) {
                    exists = true;
                }
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                Object[] arguments = new Object[]{exception.getMessage()};
                location.errorT("existsOnDb failed: {0}", arguments);
                throw JddException.createInstance(exception);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
        return exists;
    }

    protected DbOraSegmentAttributes getSegmentAttributes() {
        return this.segmentAttributes;
    }

    public boolean checkWidth() {
        boolean correct;
        location.entering("checkWidth");
        int blockSize = 0x400000;
        int width = 0;
        DbColumns columns = this.getIndexes().getTable().getColumns();
        Iterator iterator = ((AbstractList)this.getColumnNames()).iterator();
        while (iterator.hasNext()) {
            DbColumn column = columns.getColumn(((DbIndexColumnInfo)iterator.next()).getName());
            switch (column.getJavaSqlType()) {
                case -5: {
                    width += 22;
                    break;
                }
                case -2: {
                    width = (int)((long)width + column.getLength());
                    break;
                }
                case 2004: {
                    width += 0;
                    break;
                }
                case 1: {
                    width = (int)((long)width + Math.min(column.getLength() * 3L, 2000L));
                    break;
                }
                case 2005: {
                    width += 0;
                    break;
                }
                case 91: {
                    width += 7;
                    break;
                }
                case 3: {
                    width += 22;
                    break;
                }
                case 8: {
                    width += 22;
                    break;
                }
                case 6: {
                    width += 22;
                    break;
                }
                case 4: {
                    width += 22;
                    break;
                }
                case -4: {
                    width = (int)((long)width + column.getLength());
                    break;
                }
                case 2: {
                    width += 22;
                    break;
                }
                case 1111: {
                    width += 0;
                    break;
                }
                case 5: {
                    width += 22;
                    break;
                }
                case 92: {
                    width += 7;
                    break;
                }
                case 93: {
                    width += 11;
                    break;
                }
                case -3: {
                    width = (int)((long)width + column.getLength());
                    break;
                }
                case 12: {
                    width = (int)((long)width + Math.min(column.getLength() * 3L, 4000L));
                }
            }
        }
        boolean bl = correct = width < (int)(0.72 * (double)blockSize);
        if (!correct) {
            Object[] arguments = new Object[]{this.getName()};
            location.errorT("checkWidth failed: width of index {0} too large", arguments);
        }
        location.exiting();
        return correct;
    }

    public boolean checkNameLength() {
        boolean correct;
        location.entering("checkNameLength");
        boolean bl = correct = this.getName().length() > 0 && this.getName().length() < 31;
        if (!correct) {
            Object[] arguments = new Object[]{this.getName()};
            location.errorT("checkNameLength failed: name length of {0} is invalid", arguments);
        }
        location.exiting();
        return correct;
    }

    public boolean checkNumberOfColumns() {
        boolean correct;
        location.entering("checkNumberOfColumns");
        boolean bl = correct = this.getColumnNames().size() <= 32;
        if (!correct) {
            Object[] arguments = new Object[]{this.getName()};
            location.errorT("checkNumberOfColumns failed: index {0} has too many columns", arguments);
        }
        location.exiting();
        return correct;
    }

    public boolean checkNameForReservedWord() {
        boolean correct;
        location.entering("checkNameForReservedWord");
        boolean bl = correct = !DbOraEnvironment.isReservedWord(this.getName());
        if (!correct) {
            Object[] arguments = new Object[]{this.getName()};
            location.errorT("checkNameForReservedWord: {0} is reserved word", arguments);
        }
        location.exiting();
        return correct;
    }
}

